/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.marshal.DBObjectXMLHandler;
import oracle.javatools.db.marshal.DBObjectXMLSupport;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;

public class PlSqlObjectHandler
extends DBObjectHandler {
    private final DBObjectHandler m_delegateWriteHandler;
    private final List<DBObjectHandler> m_delegateReadHandlers;
    private final PlSqlTokenPattern m_typeAndNameSearch;
    private final PlSqlTokenPattern m_disabledTriggerSearch;
    private static final String NEWLINE = "\n";
    private static final String BLANKLINE = "\n\n";
    private static final String CR = "\r";
    private static final String CRNEWLINE = "\r\n";
    private static final String NEWLINESLASH = "\n/";
    private static final String NEWLINECOMMENT = "\n-- ";
    private static final String COMMENT = "-- ";
    private DatabaseDescriptor m_ora11gR2Descriptor;

    public PlSqlObjectHandler() {
        this(null);
    }

    public PlSqlObjectHandler(String string) {
        this.m_delegateWriteHandler = DBObjectXMLSupport.getInstance().getHandler(string);
        this.m_delegateReadHandlers = new ArrayList<DBObjectHandler>();
        this.m_delegateReadHandlers.add(this.m_delegateWriteHandler);
        this.m_typeAndNameSearch = new PlSqlTokenPattern("[create [or replace] ] <type ? [body]> <name ?.>");
        this.m_disabledTriggerSearch = new PlSqlTokenPattern("/ alter trigger ?. disable /");
    }

    public void addLegacyReadHandlers(String string) {
        DBObjectXMLHandler dBObjectXMLHandler = DBObjectXMLSupport.getInstance().getHandler(string);
        this.m_delegateReadHandlers.add(dBObjectXMLHandler);
    }

    public void write(List<? extends DBObject> list, Writer writer) throws IOException {
        DBObject dBObject = list.get(0);
        if (dBObject instanceof PlSqlSourceObject) {
            Object object;
            Object object2;
            PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)dBObject;
            StringWriter stringWriter = new StringWriter();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            if (plSqlSourceObject.getSource() != null) {
                stringBuilder2.append(plSqlSourceObject.getSource().trim());
                if (!stringBuilder2.toString().endsWith(NEWLINESLASH)) {
                    stringBuilder2.append(NEWLINESLASH);
                }
                stringBuilder2.append(NEWLINE);
            }
            boolean bl = false;
            PlSqlUtil.TypeAndNameInfo typeAndNameInfo = PlSqlUtil.getTypeAndNameFromSource(plSqlSourceObject, this.getDescriptor());
            if (!plSqlSourceObject.getType().equals(typeAndNameInfo.getType()) || !plSqlSourceObject.getName().equals(typeAndNameInfo.getName())) {
                bl = true;
            }
            if (!bl && plSqlSourceObject.getProperties() != null) {
                object2 = plSqlSourceObject.getProperties().keySet().iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (!(object instanceof String)) continue;
                    String string = (String)object;
                    if (plSqlSourceObject instanceof Trigger && "enabled".equals(string) || Metadata.getInstance().isBeanProperty(plSqlSourceObject.getClass(), string) || plSqlSourceObject.getProperty(string) == null) continue;
                    bl = true;
                    break;
                }
            }
            if (bl && this.m_delegateWriteHandler != null) {
                plSqlSourceObject = (PlSqlSourceObject)DBUtil.makeClonedCopy((DBObject)plSqlSourceObject);
                plSqlSourceObject.setSource(null);
                plSqlSourceObject.setID(null);
                plSqlSourceObject.setSchema(null);
                if (plSqlSourceObject instanceof DBObjectPlSqlFragment) {
                    ((DBObjectPlSqlFragment)plSqlSourceObject).setStartOffset(null);
                    ((DBObjectPlSqlFragment)plSqlSourceObject).setEndOffset(null);
                }
                if (plSqlSourceObject instanceof Trigger) {
                    plSqlSourceObject.getProperties().remove("enabled");
                }
                this.m_delegateWriteHandler.write(Collections.singletonList(plSqlSourceObject), (Writer)stringWriter);
                object2 = stringWriter.toString().trim();
                if (((String)object2).length() > 0) {
                    stringBuilder.append(COMMENT);
                    stringBuilder.append(((String)object2).replaceAll(NEWLINE, NEWLINECOMMENT));
                    stringBuilder.append(BLANKLINE);
                    writer.write(stringBuilder.toString());
                }
            }
            writer.write(stringBuilder2.toString());
            if (dBObject instanceof Trigger && !(object2 = (Trigger)dBObject).isEnabled()) {
                object = PlSqlUtilCore.getNameFromSource((String)plSqlSourceObject.getSource());
                writer.write(NEWLINE);
                writer.write("ALTER TRIGGER " + object + " DISABLE");
                writer.write(NEWLINESLASH);
                writer.write(NEWLINE);
            }
            writer.close();
        }
    }

    public boolean canRead(Reader reader, DBObjectProvider dBObjectProvider) throws IOException {
        PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((Reader)reader, (Integer)10);
        TokenPattern.PatternResult patternResult = this.m_typeAndNameSearch.getResult((Token)plSqlToken);
        if (patternResult != null) {
            return true;
        }
        if (plSqlToken != null) {
            return this.getXMLHeader(plSqlToken) != null;
        }
        return false;
    }

    protected List<DBObject> readImpl(Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException {
        return this.readImpl(reader, dBObjectProvider, schema, true);
    }

    protected List<DBObject> readInfoImpl(Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        return this.readImpl(reader, dBObjectProvider, schema, false);
    }

    private List<DBObject> readImpl(Reader reader, DBObjectProvider dBObjectProvider, Schema schema, boolean bl) throws IOException {
        List list;
        String string;
        Object object;
        Object object2;
        String string2;
        DBObject dBObject = null;
        PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((Reader)new EOLFixingReader(reader), null);
        String string3 = this.getXMLHeader(plSqlToken);
        TokenPattern.PatternResult patternResult = this.m_typeAndNameSearch.getResult((Token)plSqlToken);
        if (patternResult != null) {
            string2 = patternResult.getNamedMatch("type").toUpperCase();
            object2 = (PlSqlToken)patternResult.getNamedMatchEndToken("name");
            if (object2.getType() == Token.Type.DOUBLE_QUOTED_STRING) {
                object = object2.getSource();
                string = ((String)object).substring(1, ((String)object).length() - 1);
            } else {
                string = object2.getSource(true);
            }
        } else {
            string2 = null;
            string = null;
        }
        if (string3 != null) {
            object2 = null;
            for (DBObjectHandler dBObjectHandler : this.m_delegateReadHandlers) {
                try {
                    list = dBObjectHandler.read((Reader)new StringReader(string3), dBObjectProvider, schema);
                    if (list == null || list.size() <= 0) continue;
                    dBObject = (DBObject)list.get(0);
                    object2 = null;
                    break;
                }
                catch (IOException iOException) {
                    if (object2 != null) continue;
                    object2 = iOException;
                }
            }
            if (object2 != null) {
                DBLog.getLogger(PlSqlObjectHandler.class).log(Level.WARNING, "Failed to parse XML Header {0} {1}", new Object[]{string2, string});
            }
        }
        if (dBObject == null && string2 != null && string != null) {
            dBObject = Metadata.getInstance().newDBObject(string2, string);
        }
        if (dBObject == null) {
            throw new IOException("Failed to create PL/SQL object");
        }
        if (dBObject.getName() == null) {
            dBObject.setName(string);
        }
        object2 = null;
        object = new NameBasedID(dBObject, (DBObjectID)object2);
        object.setSchema(schema);
        object.setProvider(dBObjectProvider);
        dBObject.setID((DBObjectID)object);
        if (bl) {
            DBObjectHandler dBObjectHandler;
            dBObjectHandler = plSqlToken;
            while (((PlSqlToken)dBObjectHandler.getNextToken()).getType() != Token.Type.END_MARKER) {
                if (dBObjectHandler.matches("/")) {
                    list = (PlSqlToken)dBObjectHandler.getPrevToken();
                    PlSqlToken plSqlToken2 = (PlSqlToken)dBObjectHandler.getNextToken();
                    if (list.getType() == Token.Type.WHITESPACE && plSqlToken2.getType() == Token.Type.WHITESPACE) {
                        String string4 = list.getSource(false);
                        String string5 = plSqlToken2.getSource(false);
                        if (string4.endsWith(NEWLINE) && string5.contains(NEWLINE)) break;
                    }
                }
                dBObjectHandler = (PlSqlToken)dBObjectHandler.getNextToken();
            }
            if (dBObjectHandler.matches("/")) {
                for (dBObjectHandler = (PlSqlToken)dBObjectHandler.getPrevToken(); dBObjectHandler != null && !dBObjectHandler.isCode(); dBObjectHandler = (PlSqlToken)dBObjectHandler.getPrevToken()) {
                }
            }
            ((PlSqlSourceObject)dBObject).setSource(plSqlToken.getSource(false, (Token)dBObjectHandler));
            if (dBObject instanceof Trigger && (list = this.m_disabledTriggerSearch.getResult((Token)(dBObjectHandler = (PlSqlToken)dBObjectHandler.getNextCodeToken()))) != null) {
                ((Trigger)dBObject).setEnabled(false);
            }
            if (dBObjectProvider != null) {
                dBObjectProvider.getObjectFactory().ensureID(dBObject, true, true);
            }
        }
        return Collections.singletonList(dBObject);
    }

    private String getXMLHeader(PlSqlToken plSqlToken) {
        String string;
        PlSqlToken plSqlToken2 = plSqlToken;
        if (plSqlToken2.getPrevToken() != null) {
            while (((PlSqlToken)plSqlToken2.getPrevToken()).getType() != Token.Type.END_MARKER) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevToken();
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (plSqlToken2.getType() == Token.Type.SINGLE_LINE_COMMENT && (string = plSqlToken2.getSource().substring(2).trim()).startsWith("<?xml")) {
            while (!plSqlToken2.isCode()) {
                String string2;
                if (plSqlToken2.getType() == Token.Type.SINGLE_LINE_COMMENT) {
                    string = plSqlToken2.getSource().substring(2).trim();
                    stringBuilder.append(string);
                }
                if ((plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken()).getType() != Token.Type.WHITESPACE || !(string2 = plSqlToken2.getSource(false)).contains(BLANKLINE)) continue;
                break;
            }
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private DatabaseDescriptor getDescriptor() {
        if (this.m_ora11gR2Descriptor == null) {
            this.m_ora11gR2Descriptor = DatabaseFactory.getDatabaseDescriptor(Oracle11gR2.class);
        }
        return this.m_ora11gR2Descriptor;
    }

    private static class EOLFixingReader
    extends Reader {
        private final Reader m_delegate;

        public EOLFixingReader(Reader reader) {
            this.m_delegate = reader;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            char[] cArray2 = new char[cArray.length];
            if ((n2 = this.m_delegate.read(cArray2, n, n2)) > -1) {
                String string = new String(cArray2, n, n2);
                string = string.replaceAll(PlSqlObjectHandler.CRNEWLINE, PlSqlObjectHandler.NEWLINE);
                string = string.replaceAll(PlSqlObjectHandler.CR, PlSqlObjectHandler.NEWLINE);
                n2 = string.length();
                StringReader stringReader = new StringReader(string);
                stringReader.read(cArray, n, n2);
            }
            return n2;
        }

        @Override
        public void close() throws IOException {
            this.m_delegate.close();
        }
    }
}

