/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.marshal.BaseSAXHelper;
import oracle.javatools.db.marshal.DBObject2XML;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DBObjectRefsSAXHelper
extends BaseSAXHelper<BaseObjectID> {
    private final DBObjectHandler.UnmarshalledIDs m_ids;
    private final Collection<String> m_patterns;
    private final Collection<String> m_parseProps;
    private final List<String> m_xmlPath = new ArrayList<String>();
    private final Map<String, String> m_elemToTypeMap = new HashMap<String, String>();
    private String m_rootElem;
    private final MultiMap<String, String> m_nameMap = new MultiMap();
    private final MultiMap<String, DBObjectID> m_idMap = new MultiMap();
    private String m_openingName;
    private DBObjectID m_lastID;

    DBObjectRefsSAXHelper(String string, DBObjectHandler.UnmarshalledIDs unmarshalledIDs, Collection<String> collection, Collection<String> collection2) {
        super(string);
        this.m_ids = unmarshalledIDs;
        this.m_patterns = collection;
        this.m_parseProps = collection2;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_rootElem == null) {
            this.checkNamespace(string);
            this.m_rootElem = string2;
        } else {
            this.m_xmlPath.add(string2);
        }
        this.clearChars();
        Class<? extends BaseObjectID> clazz = this.getIDClass(string2, attributes);
        if (clazz != null) {
            if (!"parent".equals(string2)) {
                if (this.getStackSize() > 0) {
                    throw new SAXException(new IllegalStateException("current but not parent"));
                }
                this.m_openingName = string2;
            }
            try {
                BaseObjectID baseObjectID = clazz.newInstance();
                this.push(baseObjectID, string2);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        } else if (!"name".equals(string2)) {
            this.m_lastID = null;
        }
    }

    private boolean isSupportedIDClass(String string) {
        for (String string2 : this.m_patterns) {
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    private Class<? extends BaseObjectID> getIDClass(String string, Attributes attributes) {
        Class<?> clazz = null;
        String string2 = attributes.getValue("class");
        if (ModelUtil.hasLength((String)string2) && this.isSupportedIDClass(string2)) {
            try {
                Class<?> clazz2 = this.findClassLoader().loadClass(string2);
                if (BaseObjectID.class.isAssignableFrom(clazz2)) {
                    clazz = clazz2;
                }
            }
            catch (Exception exception) {
                this.getLogger().warning("Couldn't load id class " + string2);
            }
        }
        return clazz;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        BaseObjectID baseObjectID;
        Object object;
        int n;
        if (!this.m_xmlPath.isEmpty() || !ModelUtil.areEqual((Object)string2, (Object)this.m_rootElem)) {
            n = this.m_xmlPath.size() - 1;
            if (n < 0 || ModelUtil.areDifferent((Object)string2, (Object)this.m_xmlPath.get(n))) {
                throw new SAXException(new IllegalStateException("path is broken: " + this.m_xmlPath));
            }
            this.m_xmlPath.remove(n);
        }
        if (this.hasChars() && this.m_parseProps.contains(string2)) {
            String string4 = this.getChars();
            object = SQLFragmentUtils.getReferenceIDs((String)string4, (DBObjectProvider)this.getProvider());
            baseObjectID = object.iterator();
            while (baseObjectID.hasNext()) {
                DBObjectID dBObjectID = (DBObjectID)baseObjectID.next();
                this.m_ids.addReferenceID(dBObjectID);
            }
        }
        if ((n = this.getStackSize()) > 1 && "parent".equals(string2)) {
            object = (BaseObjectID)this.pop(string2);
            baseObjectID = (BaseObjectID)this.getCurrentObject();
            baseObjectID.setParent((DBObjectID)object);
            this.m_ids.addReferenceID((DBObjectID)object);
        } else if (n > 0) {
            if (this.hasChars()) {
                object = this.getChars();
                baseObjectID = (BaseObjectID)this.getCurrentObject();
                if ("name".equals(string2)) {
                    baseObjectID.setName((String)object);
                } else if ("identifier".equals(string2) && baseObjectID instanceof IdentifierBasedID) {
                    ((IdentifierBasedID)baseObjectID).setIdentifier(object);
                } else if ("type".equals(string2)) {
                    baseObjectID.setType((String)object);
                } else if ("schemaName".equals(string2)) {
                    baseObjectID.setSchemaName((String)object);
                } else if ("databaseName".equals(string2)) {
                    baseObjectID.setDatabaseName((String)object);
                }
            }
            if (n == 1 && ModelUtil.areEqual((Object)this.m_openingName, (Object)string2)) {
                object = (BaseObjectID)this.pop(string2);
                if ("ID".equals(string2)) {
                    this.m_idMap.add((Object)this.getCurrentXMLPath(), object);
                } else {
                    this.m_ids.addReferenceID((DBObjectID)object);
                }
                this.m_openingName = null;
                this.m_lastID = object;
            }
        } else if (n == 0 && "name".equals(string2) && this.hasChars()) {
            object = this.getCurrentXMLPath();
            if (!this.m_idMap.containsKey(object)) {
                this.m_nameMap.add(object, (Object)this.getChars());
            } else if (this.m_lastID instanceof BaseObjectID && ((BaseObjectID)this.m_lastID).getName() == null) {
                ((BaseObjectID)this.m_lastID).setName(this.getChars());
            }
        }
        this.clearChars();
    }

    @Override
    public void endDocument() throws SAXException {
        String string;
        String string2;
        NameBasedID nameBasedID = null;
        for (Map.Entry entry : this.m_nameMap.entrySet()) {
            string2 = (String)entry.getKey();
            string = this.getObjectType(string2);
            if (string == null) continue;
            for (String string3 : (Collection)entry.getValue()) {
                NameBasedID nameBasedID2 = new NameBasedID();
                nameBasedID2.setName(string3);
                nameBasedID2.setType(string);
                if (!ModelUtil.hasLength((String)string2)) {
                    nameBasedID = nameBasedID2;
                } else {
                    nameBasedID2.setParent((DBObjectID)nameBasedID);
                }
                this.m_ids.addObjectID((DBObjectID)nameBasedID2);
            }
        }
        for (Map.Entry entry : this.m_idMap.entrySet()) {
            string2 = (String)entry.getKey();
            string = this.getObjectType(string2);
            for (String string3 : (Collection)entry.getValue()) {
                if (string3 instanceof BaseObjectID && string3.getType() == null) {
                    ((BaseObjectID)string3).setType(string);
                }
                this.m_ids.addObjectID((DBObjectID)string3);
            }
        }
    }

    private String getCurrentXMLPath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.m_xmlPath) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String getObjectType(String string) throws SAXException {
        String string2 = this.m_elemToTypeMap.get(string);
        if (string2 == null) {
            if (ModelUtil.hasLength((String)string)) {
                Class clazz;
                String string3 = this.getObjectType(null);
                PropertyInfo propertyInfo = null;
                String string4 = Property.stripProperties((String)string);
                String[] stringArray = Property.getProperties((String)string4);
                if (stringArray.length > 1 && stringArray[stringArray.length - 2].startsWith(stringArray[stringArray.length - 1])) {
                    propertyInfo = PropertyHelper.findPropertyInfo((String)string3, (String)Property.getParentProperty((String)string4), null);
                }
                if (propertyInfo == null) {
                    propertyInfo = PropertyHelper.findPropertyInfo((String)string3, (String)string4, null);
                }
                if (propertyInfo != null && DBObject.class.isAssignableFrom(clazz = DBUtil.decodeArrayClass((Class)propertyInfo.getPropertyClass()))) {
                    string2 = Metadata.getType((Class)clazz);
                }
            } else {
                for (String string5 : Metadata.getInstance().getDBObjectClasses().keySet()) {
                    if (!DBObject2XML.convertType(string5).equals(this.m_rootElem)) continue;
                    string2 = string5;
                    break;
                }
                if (string2 == null) {
                    throw new SAXException(new IllegalStateException("No object type found for root element " + string));
                }
            }
            this.m_elemToTypeMap.put(string, string2);
        }
        return string2;
    }
}

