/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.marshal.DBObjectXMLSupport;
import oracle.javatools.db.marshal.InvalidNamespaceException;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

abstract class BaseSAXHelper<T>
extends DefaultHandler {
    private final String m_namespace;
    private ClassLoader m_clzLoader;
    private List<T> m_stack;
    private StringBuilder m_chars;
    private DBObjectProvider m_pro;

    BaseSAXHelper(String string) {
        this.m_namespace = string;
    }

    void setProvider(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected final void push(T t, String string) {
        this.m_stack.add(t);
    }

    protected final T pop(String string) {
        if (this.m_stack.size() > 0) {
            return this.m_stack.remove(this.m_stack.size() - 1);
        }
        return null;
    }

    protected final T getCurrentObject() {
        return this.m_stack.get(this.m_stack.size() - 1);
    }

    protected final T getCurrentParent() {
        return this.m_stack.get(this.m_stack.size() - 2);
    }

    protected final int getStackSize() {
        return this.m_stack.size();
    }

    protected final T getObject(int n) {
        return this.m_stack.get(n);
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_stack = new ArrayList<T>();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_chars == null) {
            this.m_chars = new StringBuilder();
        }
        this.m_chars.append(cArray, n, n2);
    }

    protected final void clearChars() {
        this.m_chars = null;
    }

    protected final boolean hasChars() {
        return this.m_chars != null;
    }

    protected final String getChars() {
        return this.m_chars.toString();
    }

    protected final void checkNamespace(String string) throws InvalidNamespaceException {
        if (ModelUtil.hasLength((String)this.m_namespace) && ModelUtil.areDifferent((Object)this.m_namespace, (Object)string)) {
            throw new InvalidNamespaceException(string, this.m_namespace);
        }
    }

    protected final Class getAttributeClass(Attributes attributes) throws SAXNotRecognizedException {
        String string = attributes.getValue("class");
        if (ModelUtil.hasLength((String)string)) {
            try {
                return Class.forName(string, true, this.findClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SAXNotRecognizedException(classNotFoundException.getMessage());
            }
        }
        return null;
    }

    protected final ClassLoader findClassLoader() {
        if (this.m_clzLoader == null) {
            this.m_clzLoader = DBObjectXMLSupport.getInstance().getClassLoader(this.m_namespace);
        }
        return this.m_clzLoader;
    }

    protected final Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }
}

