/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeMap;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.jdbc.JdbcRelationBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;

public class JdbcTableBuilder<T extends Table>
extends JdbcRelationBuilder<T> {
    public JdbcTableBuilder(JdbcDatabase jdbcDatabase, String string) {
        super(jdbcDatabase, string, "TABLE");
    }

    public T createObject(String string, Schema schema, DBObjectID dBObjectID) {
        Table table = (Table)super.createObject(string, schema, dBObjectID);
        table.setProperty("TableType", (Object)Table.TableType.NORMAL);
        return (T)table;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"indexes"}, depends={"constraints", "columns"})
    public final void fillInIndexes(T t) throws DBException {
        this.loadAndBuildIndexes(t);
    }

    protected void loadAndBuildIndexes(T t) throws DBException {
        String string = this.isUseSchema() && t.getSchema() != null ? t.getSchema().getName() : null;
        ResultSet resultSet = null;
        try {
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            String string2 = this.getNameForDriver(t.getName());
            resultSet = databaseMetaData.getIndexInfo(null, this.getNameForDriver(string), string2, false, false);
            this.processIndexes(resultSet, t);
        }
        catch (SQLException sQLException) {
            this.checkUnsupportedOperation((DBObject)t, sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processIndexes(ResultSet resultSet, T t) throws DBException {
        Object object;
        TreeMap<String, Index> treeMap = new TreeMap<String, Index>();
        try {
            object = this.getNameForDriver(t.getName());
            while (resultSet != null && resultSet.next()) {
                if (object == null && !resultSet.getString(3).equals(t.getName())) continue;
                boolean bl = !resultSet.getBoolean(4);
                String string = resultSet.getString(6);
                if (resultSet.getInt(7) == 0 || t.getConstraint(string) != null) continue;
                String string2 = resultSet.getString(9);
                String string3 = resultSet.getString(10);
                Index index = (Index)treeMap.get(string);
                if (index == null) {
                    index = new Index(string, t);
                    index.setID((DBObjectID)new NameBasedID((DBObject)index, t.getID()));
                    treeMap.put(string, index);
                }
                index.setIndexType(bl ? Index.IndexType.UNIQUE : Index.IndexType.NORMAL);
                Column column = t.getColumn(string2);
                if (column == null) continue;
                IndexObject.OrderType orderType = null;
                if (string3 != null) {
                    orderType = string3.equals("A") ? IndexObject.OrderType.ASC : IndexObject.OrderType.DESC;
                }
                ColumnUsage columnUsage = new ColumnUsage(column.getID());
                columnUsage.setProvider((DBObjectProvider)this.getProvider());
                IndexObject indexObject = new IndexObject((SQLFragment)columnUsage, orderType);
                index.addColumnExpression(indexObject);
            }
        }
        catch (SQLException sQLException) {
            this.checkUnsupportedOperation((DBObject)t, sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
                resultSet = null;
            }
        }
        object = treeMap.values();
        Index[] indexArray = object.toArray(new Index[object.size()]);
        t.setIndexes(indexArray);
    }
}

