/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;

public abstract class DMDBuilder<T extends AbstractBuildableObject>
extends AbstractDBObjectBuilder<T> {
    private String m_catalog;

    protected DMDBuilder(JdbcDatabase jdbcDatabase, String string, String string2) {
        super((AbstractDBObjectProvider)jdbcDatabase, string2);
        this.m_catalog = string;
    }

    public JdbcDatabase getDatabase() {
        return (JdbcDatabase)this.getProvider();
    }

    public Connection getConnection() {
        return this.getDatabase().getConnection();
    }

    public boolean isUseSchema() {
        return this.getDatabase().isUseSchema();
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    protected String[] getCatalogAndSchema(Schema schema) {
        String string;
        String string2;
        if (schema != null) {
            try {
                schema = this.getDatabase().getSchema(schema.getName());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        String string3 = string2 = schema == null ? null : (String)schema.getProperty("DMD_CATALOG_NAME");
        if (string2 == null) {
            string2 = this.getCatalog();
        }
        String string4 = string = schema == null ? null : (String)schema.getProperty("DMD_SCHEMA_NAME");
        if (string == null && this.isUseSchema()) {
            String string5 = string = schema != null ? schema.getName() : null;
        }
        if ("<null>".equals(string)) {
            string = null;
        }
        return new String[]{string2, this.getNameForDriver(string)};
    }

    protected String getNameForDriver(String string) {
        return this.getDatabase().getNameForDriver(string);
    }

    protected final void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void checkUnsupportedOperation(DBObject dBObject, SQLException sQLException) throws DBException {
        if (!((AbstractDatabase)this.getProvider()).isUnsupportedOperation(sQLException)) {
            throw new DBException(dBObject, (Throwable)sQLException);
        }
    }
}

