/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDynamicServer11;
import oracle.javatools.db.informix.InformixDynamicServer11Descriptor;
import oracle.javatools.db.informix.InformixDynamicServer11Impl;
import oracle.javatools.db.informix.InformixDynamicServerDescriptor;
import oracle.javatools.db.informix.InformixDynamicServerImpl;

public class InformixDynamicServerFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String string, String string2, Connection connection) {
        int n = this.getInformixConnectionType(connection);
        switch (n) {
            case 100: {
                return new InformixDynamicServerImpl(string, string2, connection);
            }
            case 115: {
                return new InformixDynamicServer11Impl(string, string2, connection);
            }
        }
        return null;
    }

    protected int getInformixConnectionType(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDriverName();
                if (string.indexOf("Informix") > -1 || string.indexOf("iclit09b") > -1) {
                    int n = databaseMetaData.getDatabaseMajorVersion();
                    if (n >= 9) {
                        return 115;
                    }
                    return 100;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        InformixDynamicServerDescriptor informixDynamicServerDescriptor = null;
        if (InformixDynamicServer11.class.isAssignableFrom(clazz)) {
            informixDynamicServerDescriptor = new InformixDynamicServer11Descriptor(clazz);
        } else if (InformixDatabase.class.isAssignableFrom(clazz)) {
            informixDynamicServerDescriptor = new InformixDynamicServerDescriptor(clazz);
        }
        return informixDynamicServerDescriptor;
    }
}

