/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.util.Collection;
import java.util.regex.Pattern;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.hive.HivePropertyMetadata;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.hive.resource.HiveBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class HiveStoragePropertiesValidator
extends AbstractChildDBObjectValidator<HiveStorageProperties> {
    private Pattern m_javaPattern;

    public HiveStoragePropertiesValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("hdfsLocation");
        collection.add("predefinedFileFormat");
        for (String string : HivePropertyMetadata.getDelimitedProperties()) {
            collection.add(string);
        }
        return collection;
    }

    @DBObjectValidator.PropertyValidator(value={"inputFormatClass"}, level=ValidationLevel.FULL)
    public void validateInputFormat(HiveStorageProperties hiveStorageProperties, HiveStorageProperties hiveStorageProperties2) throws ValidationException {
        this.validateClassName(hiveStorageProperties2, hiveStorageProperties2.getInputFormatClass());
    }

    @DBObjectValidator.PropertyValidator(value={"outputFormatClass"}, level=ValidationLevel.FULL)
    public void validateOutputtFormat(HiveStorageProperties hiveStorageProperties, HiveStorageProperties hiveStorageProperties2) throws ValidationException {
        this.validateClassName(hiveStorageProperties2, hiveStorageProperties2.getOutputFormatClass());
    }

    @DBObjectValidator.PropertyValidator(value={"serDeClass"}, level=ValidationLevel.FULL)
    public void validateSerDe(HiveStorageProperties hiveStorageProperties, HiveStorageProperties hiveStorageProperties2) throws ValidationException {
        this.validateClassName(hiveStorageProperties2, hiveStorageProperties2.getSerDeClass());
    }

    @DBObjectValidator.PropertyValidator(value={"storageHandlerClass"}, level=ValidationLevel.FULL)
    public void validateStorageHandler(HiveStorageProperties hiveStorageProperties, HiveStorageProperties hiveStorageProperties2) throws ValidationException {
        this.validateClassName(hiveStorageProperties2, hiveStorageProperties2.getStorageHandlerClass());
    }

    private void validateClassName(HiveStorageProperties hiveStorageProperties, String string) throws ValidationException {
        if (ModelUtil.hasLength((String)string)) {
            Pattern pattern = this.m_javaPattern;
            if (pattern == null) {
                this.m_javaPattern = pattern = Pattern.compile("([\\p{L}_\\p{Sc}][\\p{L}\\p{N}_\\p{Sc}]*\\.)*[\\p{L}_\\p{Sc}][\\p{L}\\p{N}_\\p{Sc}]*");
            }
            if (!pattern.matcher(string).matches()) {
                throw new ValidationException((DBObject)hiveStorageProperties, HiveBundle.format("INVALID_CLASS_NAME", string));
            }
        }
    }
}

