/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.hive.HiveDatabase;
import oracle.javatools.db.hive.HiveTableBuilder;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.resource.APIBundle;

public class HiveDatabaseImpl
extends JdbcDDLDatabase
implements HiveDatabase {
    private static final String DEFAULT = "default";

    public HiveDatabaseImpl(String string, String string2, Connection connection, int n) {
        super(string, string2, connection, "Hive", n);
    }

    @Override
    protected void registerBuilders() {
        this.registerBuilder("TABLE", (DBObjectBuilder)new HiveTableBuilder(this));
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    protected String queryCurrentSchemaName() throws DBException {
        ConnectionWrapper connectionWrapper = new ConnectionWrapper((Database)this, APIBundle.get((String)"GET_CURR_SCHEMA"));
        String string = null;
        try {
            string = (String)connectionWrapper.call((ConnectionWrapper.SQLCallable)new ConnectionWrapper.SQLCallable<String>(connectionWrapper){

                public String call() throws SQLException {
                    String string = this.getConnection().getMetaData().getURL();
                    return HiveDatabaseImpl.getDatabaseName(string);
                }
            });
        }
        catch (DBException dBException) {
            string = super.queryCurrentSchemaName();
        }
        return string;
    }

    <T extends AbstractBuildableObject> void setHiveBuilder(T t, DBObjectBuilder<T> dBObjectBuilder) {
        this.markForLazyInit(t, dBObjectBuilder);
    }

    static String getDatabaseName(String string) {
        Pattern pattern = Pattern.compile("jdbc:hive[2]*://[^\\s]+/([^;\\s]+).*");
        Matcher matcher = pattern.matcher(string);
        String string2 = matcher.find() ? matcher.group(1) : DEFAULT;
        return string2;
    }
}

