/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveBucketProperties;
import oracle.javatools.db.hive.resource.HiveBundle;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class HiveBucketPropertiesValidator
extends AbstractChildDBObjectValidator<HiveBucketProperties> {
    public HiveBucketPropertiesValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    @DBObjectValidator.PropertyValidator(value={"bucketColumns"}, level=ValidationLevel.FULL)
    public void validateBucketColumns(HiveBucketProperties hiveBucketProperties, HiveBucketProperties hiveBucketProperties2) throws ValidationException {
        HiveBucketPropertiesValidator.validateColumnsExist(hiveBucketProperties2.getBucketColumns(), (DBObject)hiveBucketProperties2);
    }

    @DBObjectValidator.PropertyValidator(value={"numberOfBuckets"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"bucketColumns"})
    public void validateBucketNum(HiveBucketProperties hiveBucketProperties, HiveBucketProperties hiveBucketProperties2) throws ValidationException {
        Integer n;
        DBObjectID[] dBObjectIDArray = hiveBucketProperties2.getBucketColumns();
        if (dBObjectIDArray != null && dBObjectIDArray.length > 0 && ((n = hiveBucketProperties2.getNumberOfBuckets()) == null || n <= 0)) {
            throw new ValidationException((DBObject)hiveBucketProperties2, HiveBundle.get("INVALID_BUCKET_NUM_MISSING"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"bucketSortColumns"}, level=ValidationLevel.FULL)
    public void validateBucketSortColumns(HiveBucketProperties hiveBucketProperties, HiveBucketProperties hiveBucketProperties2) throws ValidationException {
        IndexObject[] indexObjectArray;
        for (IndexObject indexObject : indexObjectArray = hiveBucketProperties2.getBucketSortColumns()) {
            boolean bl;
            String string = indexObject.getExpressionSource();
            if (ModelUtil.hasLength((String)string)) {
                Object var10_10 = null;
                try {
                    this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)indexObject);
                    DBUtil.ensureObjectBuilt((DBObject)indexObject, (String[])new String[]{"expression"});
                    bl = true;
                }
                catch (DBException dBException) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl) continue;
            throw new ValidationException((DBObject)hiveBucketProperties2, HiveBundle.format("INVALID_BUCKET_SORT", string));
        }
    }

    static void validateColumnsExist(DBObjectID[] dBObjectIDArray, DBObject dBObject) throws ValidationException {
        Table table;
        if (dBObjectIDArray != null && dBObjectIDArray.length > 0 && (table = (Table)DBUtil.findParentOfType((DBObject)dBObject, Table.class)) != null) {
            for (DBObjectID dBObjectID : dBObjectIDArray) {
                Column column = (Column)table.findOwnedObject(dBObjectID);
                if (column != null) continue;
                throw new ValidationException(dBObject, HiveBundle.format("INVALID_COL", DBUtil.getDBObjectName((DBObjectID)dBObjectID)));
            }
        }
    }
}

