/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SQLServer.SQLServerDatabaseImpl;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcTableBuilder;

public class SQLServerTableBuilder
extends JdbcTableBuilder<Table> {
    public SQLServerTableBuilder(SQLServerDatabaseImpl sQLServerDatabaseImpl) {
        super(sQLServerDatabaseImpl, null);
    }

    @Override
    protected void buildCCs(final Table table) throws DBException {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), "select c.name,\n       c.definition\nfrom sys.check_constraints c,\n     sys.objects t\nwhere c.parent_object_id = t.object_id\n  and SCHEMA_NAME(t.schema_id) = ?\n  and t.name like (?)\n", new Object[]{table.getSchema(), table.getName()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        CheckConstraint checkConstraint = (CheckConstraint)SQLServerTableBuilder.this.getProvider().getObjectFactory().newObject(CheckConstraint.class, (DBObject)table);
                        String string = resultSet.getString(1);
                        checkConstraint.setName(string);
                        String string2 = resultSet.getString(2);
                        int n = string2.indexOf(40) + 1;
                        int n2 = string2.lastIndexOf(41);
                        String string3 = string2.substring(n, n2).replaceAll("[\\[\\]]", "");
                        checkConstraint.setCheckCondition(string3);
                        checkConstraint.setID((DBObjectID)new NameBasedID("CONSTRAINT", string, table.getID()));
                        table.addConstraint((Constraint)checkConstraint);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)table, sQLException);
                }
            }
        });
    }

    @Override
    protected void buildUKs(final Table table) throws DBException {
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getDatabase(), "select i.name,\n       c.name\nfrom sys.objects t,\n     sys.indexes i,\n     sys.index_columns ic,\n     sys.columns c\nwhere i.object_id = t.object_id\n  and ic.object_id = i.object_id\n  and i.index_id = ic.index_id\n  and c.object_id = t.object_id\n  and ic.column_id = c.column_id\n  and i.is_unique_constraint = 'true'\n  and SCHEMA_NAME(t.schema_id) = ?\n  and t.name like (?)\n", new Object[]{table.getSchema(), table.getName()});
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                HashMap<String, UniqueConstraint> hashMap = new HashMap<String, UniqueConstraint>();
                try {
                    while (resultSet.next()) {
                        Column column;
                        String string = resultSet.getString(1);
                        UniqueConstraint uniqueConstraint = (UniqueConstraint)hashMap.get(string);
                        if (uniqueConstraint == null) {
                            uniqueConstraint = (UniqueConstraint)SQLServerTableBuilder.this.getProvider().getObjectFactory().newObject(UniqueConstraint.class, (DBObject)table);
                            uniqueConstraint.setName(string);
                            uniqueConstraint.setID((DBObjectID)new NameBasedID("CONSTRAINT", string, table.getID()));
                            table.addConstraint((Constraint)uniqueConstraint);
                            hashMap.put(string, uniqueConstraint);
                        }
                        if ((column = table.getColumn(resultSet.getString(2))) == null) continue;
                        uniqueConstraint.addColumn(column);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)table, sQLException);
                }
            }
        });
    }
}

