/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.Database;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.SQLServer.SQLServerSynonymBuilder;
import oracle.javatools.db.SQLServer.SQLServerTableBuilder;
import oracle.javatools.db.SQLServer.SQLServerViewBuilder;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;

public class SQLServerDatabaseImpl
extends JdbcDDLDatabase
implements SQLServerDatabase {
    public SQLServerDatabaseImpl(String string, String string2, Connection connection) {
        super(string, string2, connection);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    protected void registerBuilders() {
        this.registerBuilder("SYNONYM", (DBObjectBuilder)new SQLServerSynonymBuilder(this));
        this.registerBuilder("TABLE", (DBObjectBuilder)new SQLServerTableBuilder(this));
        this.registerBuilder("VIEW", (DBObjectBuilder)new SQLServerViewBuilder(this));
    }

    @Override
    public String normaliseDataTypeName(String string) {
        return string.trim().toUpperCase().replaceAll(" IDENTITY", "").replaceAll("\\(\\)", "");
    }

    @Override
    public String normaliseDefaultValue(DataType dataType, String string) {
        string = string.replaceAll("\\(", "");
        string = string.replaceAll("\\)", "");
        return string;
    }

    protected void processDeleteException(DBException dBException, SystemObject systemObject) throws DBException {
        int n;
        Throwable throwable = dBException.getCause();
        if (throwable instanceof SQLException && (n = ((SQLException)throwable).getErrorCode()) == 3726) {
            throw new CascadeRequiredException((DBObject)systemObject, ((SQLException)throwable).getMessage());
        }
        throw dBException;
    }

    @Override
    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        final Collection<T> collection = super.listObjectsImpl(dBObjectCriteria);
        if (dBObjectCriteria.isAllowedType("SYNONYM")) {
            DBObjectBuilder dBObjectBuilder = this.getBuilderForType("SYNONYM");
            final Schema schema = this.findSchema(dBObjectCriteria.getSchemaName());
            if (dBObjectBuilder != null) {
                final QueryWrapper queryWrapper = new QueryWrapper((Database)this, " SELECT sy.name  FROM sys.synonyms sy, sys.schemas sc  WHERE sy.schema_id = sc.schema_id AND sc.name = ? AND sy.name LIKE( ? ) ", new Object[]{schema, dBObjectCriteria.getNameLike()});
                queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            while (resultSet.next()) {
                                String string = resultSet.getString(1);
                                SystemObject systemObject = SQLServerDatabaseImpl.this.findOrCreateObject("SYNONYM", null, schema, string, null);
                                collection.add(systemObject);
                            }
                        }
                        catch (SQLException sQLException) {
                            queryWrapper.throwDBException(sQLException);
                        }
                    }
                });
            }
        }
        return collection;
    }
}

