/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.SQLServer.SQLServer2005;
import oracle.javatools.db.SQLServer.SQLServer2008;
import oracle.javatools.db.SQLServer.SQLServer2012;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.SQLServer.SQLServerDatabaseDescriptor;
import oracle.javatools.db.SQLServer.SQLServerDatabaseImpl;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.util.Holder;
import oracle.javatools.util.Version;

public class SQLServerDatabaseFactory
extends BaseDatabaseCreator {
    protected Database createDatabaseImpl(String string, String string2, Connection connection) {
        SQLServerDatabaseImpl sQLServerDatabaseImpl = null;
        int n = this.getSQLServerConnectionVersion(string2, connection);
        if (n == 110) {
            sQLServerDatabaseImpl = new SQLServer2012(string, string2, connection);
        } else if (n == 100) {
            sQLServerDatabaseImpl = new SQLServer2008(string, string2, connection);
        } else if (n == 90) {
            sQLServerDatabaseImpl = new SQLServer2005(string, string2, connection);
        } else if (n == 80) {
            sQLServerDatabaseImpl = new SQLServerDatabaseImpl(string, string2, connection);
        }
        return sQLServerDatabaseImpl;
    }

    private int getSQLServerConnectionVersion(String string, Connection connection) {
        int n;
        block15: {
            n = -1;
            if (connection != null) {
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String string2 = databaseMetaData.getDatabaseProductName();
                    if (string2.indexOf("Microsoft SQL Server") <= -1) break block15;
                    try {
                        n = databaseMetaData.getDatabaseMajorVersion();
                    }
                    catch (Throwable throwable) {
                        final Holder holder = new Holder();
                        final QueryWrapper queryWrapper = new QueryWrapper(string, connection, "select SERVERPROPERTY('ProductVersion')", new Object[0]);
                        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                            public void processResultSet(ResultSet resultSet) throws DBException {
                                block5: {
                                    try {
                                        if (!resultSet.next()) break block5;
                                        try {
                                            Version version = new Version(resultSet.getString(1));
                                            int[] nArray = version.toIntArray();
                                            if (nArray != null) {
                                                holder.set((Object)nArray[0]);
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            DBLog.getLogger((Object)this).fine(numberFormatException.getMessage());
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        queryWrapper.throwDBException(sQLException);
                                    }
                                }
                            }
                        };
                        try {
                            queryWrapper.executeQuery(queryRunnable);
                            Integer n2 = (Integer)holder.get();
                            if (n2 != null) {
                                n = n2;
                            }
                        }
                        catch (DBException dBException) {}
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        int n3 = -1;
        if (n >= 11) {
            n3 = 110;
        } else if (n == 10) {
            n3 = 100;
        } else if (n == 9) {
            n3 = 90;
        } else if (n >= 0) {
            n3 = 80;
        }
        return n3;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class clazz) {
        SQLServerDatabaseDescriptor sQLServerDatabaseDescriptor = null;
        if (SQLServerDatabase.class.isAssignableFrom(clazz)) {
            sQLServerDatabaseDescriptor = new SQLServerDatabaseDescriptor(clazz);
        }
        return sQLServerDatabaseDescriptor;
    }
}

