/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFactory;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.plsql.CascadeTriggerLister;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.refactoring.CascadeProcessor;
import oracle.javatools.db.refactoring.DBObjectTransaction;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

public final class DummyDBObjectProvider
extends AbstractDBObjectProvider {
    public static final String PROVIDER_TYPE = "dummy";
    private final String m_name;
    private final DatabaseDescriptor m_desc;
    private final boolean m_useIdentifierBasedIDs;
    private final String[] m_types;
    private String m_defSchema;
    private Map<String, DBObject> m_templates;
    private Collection<String> m_builtInSchemaNames;
    private boolean m_sleepOnList = false;

    public DummyDBObjectProvider(String string, DatabaseDescriptor databaseDescriptor) {
        this(string, databaseDescriptor, true);
    }

    public DummyDBObjectProvider(String string, String string2, int n) {
        this(string, DatabaseRegistry.getInstance().getDatabaseDescriptor(string2, n), true);
    }

    public DummyDBObjectProvider(String string, DatabaseDescriptor databaseDescriptor, boolean bl) {
        String string2;
        this.m_name = string;
        this.m_desc = new DummyDescriptor(databaseDescriptor);
        this.m_useIdentifierBasedIDs = bl;
        TreeSet<String> treeSet = new TreeSet<String>();
        Map map = this.m_desc.getValidators((DBObjectProvider)this);
        for (Map.Entry object2 : map.entrySet()) {
            string2 = (String)object2.getKey();
            this.registerValidator(string2, (DBObjectValidator)object2.getValue());
            if (!Metadata.getInstance().isTypeOf(SystemObject.class, string2)) continue;
            treeSet.add(string2);
        }
        this.m_types = treeSet.toArray(new String[treeSet.size()]);
        this.m_builtInSchemaNames = new ArrayList<String>();
        Collection collection = this.m_desc.listBuiltInObjects(new DBObjectCriteria(Schema.class, new String[0]));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string2 = (Schema)iterator.next();
            try {
                string2 = (Schema)string2.copyTo(null, false);
                this.createSchema((Schema)string2, false);
                Collection dBException = this.m_desc.listBuiltInObjects(DBObjectCriteria.createCriteria((String)"TYPE", (Schema)string2, null));
                DBObjectTransaction dBObjectTransaction = new DBObjectTransaction((DBObjectProvider)this);
                for (SystemObject systemObject : dBException) {
                    dBObjectTransaction.includeUpdate(null, (SystemObject)systemObject.copyTo(null, false));
                }
                this.commitTransaction(dBObjectTransaction);
                this.m_builtInSchemaNames.add(string2.getName());
            }
            catch (DBException dBException) {
                DBLog.getLogger((Object)((Object)this)).log(Level.WARNING, "Couldn't setup built in objects", dBException);
            }
        }
    }

    public String getProviderType() {
        return PROVIDER_TYPE;
    }

    public Object getProviderIdentifier() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public DatabaseDescriptor getDescriptor() {
        return this.m_desc;
    }

    public DiffEngine getDiffEngine() {
        return GenericDiffEngine.getDiffEngine((boolean)true);
    }

    public String[] listObjectTypes() {
        return Arrays.copyOf(this.m_types, this.m_types.length);
    }

    public boolean canCreate(SystemObject systemObject, boolean bl) {
        if (!bl) {
            try {
                return DBUtil.getProviderDefinition((DBObject)systemObject, (DBObjectProvider)this) == null;
            }
            catch (DBException dBException) {
                this.getLogger().log(Level.WARNING, "Couldn't check create permissions:  " + dBException.getMessage());
            }
        }
        return true;
    }

    public void createObjects(SystemObject[] systemObjectArray, boolean bl) throws DBException {
        this.updateObjects(this.getDiffEngine().difference((Object)new SystemObject[systemObjectArray.length], (Object)systemObjectArray), bl, false);
    }

    private void replaceReferenceIDs(DBObject dBObject, Map<DBObjectID, DBObjectID> map) {
        dBObject.replaceReferenceIDs(map);
        for (DBObjectID dBObjectID : dBObject.getReferenceIDs()) {
            if (!(dBObjectID instanceof TemporaryObjectID)) continue;
            DBObjectID dBObjectID2 = TemporaryObjectID.findOriginalID((TemporaryObjectID)((TemporaryObjectID)dBObjectID));
            if (dBObjectID2 == null) {
                try {
                    DBObject dBObject2;
                    DBObject dBObject3 = dBObjectID.resolveID();
                    if (dBObject3 != null && (dBObject2 = DBUtil.getProviderDefinition((DBObject)dBObject3, (DBObjectProvider)this)) != null) {
                        dBObjectID2 = dBObject2.getID();
                    }
                }
                catch (DBException dBException) {
                    this.getLogger().warning("Couldn't lookup original object: " + dBException.getMessage());
                }
            }
            if (dBObjectID2 == null) continue;
            dBObject.replaceReferenceIDs(Collections.singletonMap(dBObjectID, dBObjectID2));
            map.put(dBObjectID, dBObjectID2);
        }
        for (DBObjectID dBObjectID : dBObject.getOwnedObjects()) {
            this.replaceReferenceIDs((DBObject)dBObjectID, map);
        }
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        DBObjectSet dBObjectSet = new DBObjectSet();
        Collection collection = dBObjectCriteria.getTypes();
        this.sleepForList();
        boolean bl = dBObjectCriteria.isUserOnly() && dBObjectCriteria.isAllowedType("SCHEMA");
        for (SystemObject systemObject : this.listObjectsFromCache(dBObjectCriteria)) {
            CancelledException.checkInterrupt();
            if (bl && systemObject instanceof Schema && this.m_builtInSchemaNames.contains(systemObject.getName())) continue;
            dBObjectSet.add(systemObject);
        }
        return dBObjectSet;
    }

    public void deleteObjects(SystemObject[] systemObjectArray, boolean bl) throws DBException {
        this.updateObjects(this.getDiffEngine().difference((Object)systemObjectArray, (Object)new SystemObject[systemObjectArray.length]), false, bl);
    }

    public void undeleteObject(SchemaObject schemaObject) throws DBException {
        throw new UnsupportedOperationException("undelete not supported");
    }

    public void undeleteObjects(SchemaObject[] schemaObjectArray) throws DBException {
        throw new UnsupportedOperationException("undelete not supported");
    }

    public boolean canDelete(SystemObject systemObject, boolean bl) {
        return true;
    }

    public boolean canDelete(Schema schema, boolean bl) {
        return true;
    }

    protected Collection<DBObjectChange> commitTransaction(DBObjectTransaction dBObjectTransaction, Difference difference) throws DBException {
        ArrayList<DBObjectChange> arrayList = new ArrayList<DBObjectChange>();
        if (difference.getOriginalObject() instanceof SystemObject[]) {
            SystemObject systemObject;
            SystemObject systemObject2;
            DBObjectSet dBObjectSet = new DBObjectSet();
            DBObjectSet dBObjectSet2 = new DBObjectSet();
            DBObjectSet dBObjectSet3 = new DBObjectSet();
            DBObjectIDSet dBObjectIDSet = new DBObjectIDSet(true);
            ArrayList<Difference> arrayList2 = new ArrayList<Difference>();
            for (Difference difference2 : difference.getChildren()) {
                systemObject2 = (SystemObject)difference2.getOriginalObject();
                systemObject = (SystemObject)difference2.getUpdatedObject();
                if (systemObject == null) {
                    if (systemObject2 == null) continue;
                    dBObjectSet3.add(systemObject2);
                    continue;
                }
                if (systemObject2 == null) {
                    SystemObject systemObject3 = (SystemObject)DBUtil.getProviderDefinition((DBObject)systemObject, (DBObjectProvider)this);
                    if (systemObject3 != null) {
                        if (dBObjectTransaction.isReplace()) {
                            this.uncacheObject(systemObject3);
                        } else {
                            throw new NameInUseException((DBObject)systemObject);
                        }
                    }
                    if (systemObject instanceof SchemaObject) {
                        Schema schema;
                        Schema schema2 = ((SchemaObject)systemObject).getSchema();
                        Schema schema3 = schema = schema2 == null ? null : this.getSchema(schema2.getName());
                        if (schema2 == null && schema2 instanceof SchemaObject) {
                            throw new ValidationException((DBObject)systemObject, "Object must have a Schema");
                        }
                        if (schema2 != null && schema == null) {
                            throw new ValidationException((DBObject)systemObject, "Schema does not exist");
                        }
                    }
                    dBObjectSet.add(systemObject);
                    dBObjectSet2.add(systemObject);
                    continue;
                }
                arrayList2.add(difference2);
            }
            for (SystemObject systemObject4 : dBObjectSet3) {
                this.uncacheObject(systemObject4);
            }
            for (Difference difference2 : arrayList2) {
                systemObject2 = (SystemObject)difference2.getOriginalObject();
                this.uncacheObject(systemObject2);
                systemObject = new DifferenceApplier((DBObjectProvider)this);
                systemObject.apply(difference2);
                dBObjectSet.add(systemObject2);
                for (Schema schema2 : systemObject.getEvents()) {
                    arrayList.add((DBObjectChange)schema2);
                }
            }
            this.getObjectFactory().ensureIDs((Collection)dBObjectSet, difference);
            for (SystemObject systemObject5 : dBObjectSet) {
                this.cacheObject(systemObject5, false);
            }
            this.fireObjectsAdded((Collection)dBObjectSet2);
            for (DBObjectChange dBObjectChange : arrayList) {
                this.fireObjectUpdated(dBObjectChange);
            }
        }
        return arrayList;
    }

    protected void cacheObject(SystemObject systemObject, boolean bl) {
        super.cacheObject(systemObject, bl);
        if (systemObject instanceof Table && this.supportsObjectType("INDEX")) {
            for (Index index : ((Table)systemObject).getIndexes()) {
                super.cacheObject((SystemObject)index, bl);
            }
        }
    }

    public Schema getDefaultSchema() throws DBException {
        Schema[] schemaArray;
        Schema schema = null;
        if (ModelUtil.hasLength((String)this.m_defSchema)) {
            schema = this.getSchema(this.m_defSchema);
        }
        if (schema == null && (schemaArray = this.listSchemas(false)) != null && schemaArray.length > 0) {
            schema = schemaArray[0];
        }
        return schema;
    }

    public void setDefaultSchema(String string) {
        this.m_defSchema = string;
    }

    public void createSchema(Schema schema, boolean bl) throws DBException {
        this.createObject((SystemObject)schema, bl);
        if (this.m_builtInSchemaNames.contains(schema.getName())) {
            this.m_builtInSchemaNames.remove(schema.getName());
        }
        this.fireObjectsAdded(Collections.singleton(schema));
    }

    public void updateSchema(Schema schema, Schema schema2) throws DBException {
        String string = schema2.getName();
        Schema schema3 = this.getSchema(string);
        if (schema3 == null) {
            throw new DBException((DBObject)schema2, "Schema " + string + " doesn't exist to update.");
        }
        Difference difference = this.getDiffEngine().difference((Object)schema3, (Object)schema2);
        if (!difference.isSame()) {
            DifferenceApplier differenceApplier = new DifferenceApplier((DBObjectProvider)this);
            differenceApplier.apply(difference);
            for (DBObjectChange dBObjectChange : differenceApplier.getEvents()) {
                this.fireObjectUpdated(dBObjectChange);
            }
        }
    }

    public void deleteSchema(Schema schema, boolean bl) throws DBException {
        String string = schema.getName();
        if (this.getSchema(string) == null) {
            throw new DBException((DBObject)schema, "Schema " + string + " doesn't exist to delete.");
        }
        this.deleteObject((SystemObject)schema, bl);
        this.fireObjectsRemoved(Collections.singleton(schema));
    }

    protected DBObject resolveID(DBObjectID dBObjectID) throws DBException {
        DBObject dBObject = super.resolveID(dBObjectID);
        if (dBObject == null) {
            if (dBObjectID instanceof NameBasedID) {
                dBObject = this.getObject(((NameBasedID)dBObjectID).getType(), new Schema(((NameBasedID)dBObjectID).getSchemaName()), ((NameBasedID)dBObjectID).getName());
            } else if (dBObjectID instanceof IdentifierBasedID && "INDEX".equals(dBObjectID.getType())) {
                dBObject = ((IdentifierBasedID)dBObjectID).resolveFromParent();
            }
        }
        return dBObject;
    }

    public void setDefaultTemplateForType(String string, DBObject dBObject) {
        if (dBObject == null) {
            if (this.m_templates != null) {
                this.m_templates.remove(string);
            }
        } else {
            Class clazz = Metadata.getInstance().getObjectClass(string);
            if (clazz == null || !clazz.isAssignableFrom(dBObject.getClass())) {
                throw new IllegalArgumentException("Invalid template for type " + string);
            }
            this.m_templates = new TreeMap<String, DBObject>();
            this.m_templates.put(string, dBObject);
        }
    }

    public DBObject getDefaultTemplateForType(String string) {
        return this.m_templates == null ? null : this.m_templates.get(string);
    }

    protected DBObjectFactory createObjectFactory() {
        return new DummyObjectFactory(this);
    }

    public void setSleepOnList(boolean bl) {
        this.m_sleepOnList = bl;
    }

    private void sleepForList() throws CancelledException {
        if (this.m_sleepOnList) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new CancelledException();
            }
        }
    }

    private class DummyDescriptor
    extends DatabaseDescriptor {
        public DummyDescriptor(DatabaseDescriptor databaseDescriptor) {
            super(databaseDescriptor);
        }

        public void validateName(String string, String string2) throws InvalidNameException {
            this.getBaseDescriptor().validateName(string, string2);
        }

        public Map getValidators(DBObjectProvider dBObjectProvider) {
            return this.getBaseDescriptor().getValidators(dBObjectProvider);
        }

        public int getMaxNameLength(String string) {
            return this.getBaseDescriptor().getMaxNameLength(string);
        }

        public String getIdentifierQuoteString() {
            return this.getBaseDescriptor().getIdentifierQuoteString();
        }

        public int getDatabaseVersion() {
            return this.getBaseDescriptor().getDatabaseVersion();
        }

        public String getDatabaseType() {
            return this.getBaseDescriptor().getDatabaseType();
        }

        public int getCasePolicy() {
            return this.getBaseDescriptor().getCasePolicy();
        }

        public Collection<String> getReservedWords() {
            return this.getBaseDescriptor().getReservedWords();
        }

        public List<UpdateProcessor> getUpdateProcessors() {
            List list = this.getBaseDescriptor().getUpdateProcessors();
            list.add(new CascadeProcessor());
            return list;
        }

        public DBObjectLister getTriggerLister(DBObjectProvider dBObjectProvider) {
            return dBObjectProvider.supportsObjectType("TRIGGER") ? new CascadeTriggerLister(dBObjectProvider) : null;
        }
    }

    private class DummyObjectFactory
    extends DBObjectFactory {
        DummyObjectFactory(DummyDBObjectProvider dummyDBObjectProvider2) {
            super((DBObjectProvider)dummyDBObjectProvider2);
        }

        protected boolean useIdentifierBasedIDs(DBObject dBObject) {
            return DummyDBObjectProvider.this.m_useIdentifierBasedIDs;
        }
    }
}

