/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ojc.interfaces.Storage;

abstract class AbstractStorage
implements Storage {
    protected final File file;
    private String canonicalPath = null;
    private HashMap properties = null;

    AbstractStorage(AbstractStorage storage, String name) {
        this.file = storage != null ? new File(storage.file, name) : null;
    }

    AbstractStorage(File file) {
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file != null ? this.file.getName() : null;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isInJar() {
        return false;
    }

    @Override
    public String getPath() {
        return this.file != null ? this.file.getPath() : null;
    }

    @Override
    public String getCanonicalPath() {
        if (this.canonicalPath == null && this.file != null) {
            try {
                this.canonicalPath = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.canonicalPath;
    }

    @Override
    public long modDate() {
        if (this.file != null) {
            return this.file.lastModified();
        }
        return 0L;
    }

    @Override
    public Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    @Override
    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public Storage open(String name) {
        return null;
    }

    @Override
    public Storage create(String name) throws IOException {
        assert (false);
        return null;
    }

    @Override
    public Storage createDir(String name) throws IOException {
        assert (false);
        return null;
    }

    @Override
    public int size() throws IOException {
        assert (false);
        return 0;
    }

    @Override
    public byte[] read() throws IOException {
        assert (false);
        return null;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        assert (false);
        return 0;
    }

    @Override
    public String[] list() {
        ArrayList al = this.listStorage();
        if (al == null) {
            return null;
        }
        int size = al.size();
        String[] sa = new String[size];
        for (int i = 0; i < size; ++i) {
            Storage storage = (Storage)al.get(i);
            sa[i] = storage.getName();
        }
        return sa;
    }

    @Override
    public ArrayList listStorage() {
        System.out.println("Error:  invalid internal call to 'AbstractStorage.listStorage()'.");
        System.out.println("Path: " + this.getPath());
        System.out.println("Class: " + this.getClass());
        assert (false);
        return null;
    }

    @Override
    public void write(byte[] buf, int start, int len) throws IOException {
        assert (false);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getPath();
    }
}

