/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.util.ModelUtil;

public class WeightedList<E>
implements Collection<E> {
    private ArrayList<Entry<E>> _storage;

    public WeightedList() {
        this._storage = new ArrayList();
    }

    public WeightedList(int initialCapacity) {
        this._storage = new ArrayList(initialCapacity);
    }

    public void add(E e, double weight) {
        this.addLast(e, weight);
    }

    public void addFirst(E e, double weight) {
        Entry<E> entry = new Entry<E>(e, weight);
        for (int i = 0; i < this._storage.size(); ++i) {
            Entry<E> entry_i = this._storage.get(i);
            if (!(weight <= entry_i._weight)) continue;
            this._storage.add(i, entry);
            return;
        }
        this._storage.add(entry);
    }

    public void addLast(E e, double weight) {
        Entry<E> entry = new Entry<E>(e, weight);
        for (int i = 0; i < this._storage.size(); ++i) {
            Entry<E> entry_i = this._storage.get(i);
            if (!(weight < entry_i._weight)) continue;
            this._storage.add(i, entry);
            return;
        }
        this._storage.add(entry);
    }

    @Override
    public boolean remove(Object object) {
        for (int i = 0; i < this._storage.size(); ++i) {
            Entry<E> entry = this._storage.get(i);
            if (!ModelUtil.areEqual(entry._object, object)) continue;
            this._storage.remove(i);
            return true;
        }
        return false;
    }

    public boolean remove(Object object, double weight) {
        for (int i = 0; i < this._storage.size(); ++i) {
            Entry<E> entry = this._storage.get(i);
            if (!ModelUtil.areEqual(entry._object, object) || weight != entry._weight) continue;
            this._storage.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        ArrayList arrayList = new ArrayList(this._storage.size());
        for (Entry<E> entry : this._storage) {
            Object e = entry._object;
            arrayList.add(e);
        }
        return arrayList.iterator();
    }

    public E get(int index) {
        return this._storage.get((int)index)._object;
    }

    @Override
    public int size() {
        return this._storage.size();
    }

    @Override
    public void clear() {
        this._storage.clear();
    }

    @Override
    public boolean isEmpty() {
        return this._storage.isEmpty();
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.size()];
        for (int i = 0; i < this._storage.size(); ++i) {
            Entry<E> entry = this._storage.get(i);
            ret[i] = entry._object;
        }
        return ret;
    }

    @Override
    public boolean add(E e) {
        this.add(e, 0.0);
        return true;
    }

    public int indexOf(Object e) {
        if (e != null) {
            for (int i = 0; i < this._storage.size(); ++i) {
                Entry<E> entry = this._storage.get(i);
                if (!e.equals(entry._object)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._storage.size(); ++i) {
                Entry<E> entry = this._storage.get(i);
                if (entry._object != null) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            if (this.add(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(WeightedList<E> sourceList) {
        for (Entry<E> entry : sourceList._storage) {
            this.add(entry._object, entry._weight);
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean ret = false;
        for (int i = this._storage.size() - 1; i >= 0; --i) {
            Entry<E> entry = this._storage.get(i);
            if (c.contains(entry._object)) continue;
            this._storage.remove(i);
            ret = true;
        }
        return ret;
    }

    @Override
    public Object[] toArray(Object[] a) {
        int i;
        int size = this.size();
        Object[] ret = a == null || a.length < size ? new Object[size] : a;
        for (i = 0; i < this._storage.size(); ++i) {
            Entry<E> entry = this._storage.get(i);
            ret[i] = entry._object;
        }
        while (i < this._storage.size()) {
            ret[i] = null;
            ++i;
        }
        return ret;
    }

    public double getWeight(int index) {
        return this._storage.get((int)index)._weight;
    }

    private static class Entry<E> {
        E _object;
        double _weight;

        public Entry(E e, double weight) {
            this._object = e;
            this._weight = weight;
        }
    }
}

