/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.Iterator;

public class IterablesIterator<T>
implements Iterator<T> {
    private Iterator<? extends T> iterator;
    private Iterable<? extends T>[] iterables;
    private int next;

    public IterablesIterator(Iterable<? extends T> iterable, Iterable<? extends T> ... iterables) {
        this.iterables = iterables;
        this.iterator = iterable.iterator();
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        T value = this.iterator.next();
        this.advance();
        return value;
    }

    private void advance() {
        if (this.iterator.hasNext()) {
            return;
        }
        while (this.next < this.iterables.length) {
            this.iterator = this.iterables[this.next++].iterator();
            if (!this.iterator.hasNext()) continue;
            break;
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

