/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import oracle.javatools.util.ArrayIterator;

public class CopyOnWriteList {
    private final Class itemType;
    private Object[] items;
    private static final Object[] NO_OBJECTS = new Object[0];

    public CopyOnWriteList() {
        this(Object.class);
    }

    public CopyOnWriteList(Class itemType) {
        if (itemType == null) {
            throw new IllegalArgumentException();
        }
        this.itemType = itemType;
        this.items = this.newArray(0);
    }

    public synchronized boolean add(Object item) {
        if (item == null) {
            throw new IllegalArgumentException("item == null");
        }
        return this.addImpl(this.items.length, item);
    }

    public synchronized boolean add(int index, Object item) {
        if (item == null) {
            throw new IllegalArgumentException("item == null");
        }
        return this.addImpl(index, item);
    }

    public synchronized boolean addIfAbsent(Object item) {
        if (item == null) {
            throw new IllegalArgumentException("item == null");
        }
        int i = this.items.length;
        while (i-- > 0) {
            if (!this.equals(item, this.items[i])) continue;
            return false;
        }
        return this.addImpl(this.items.length, item);
    }

    private boolean addImpl(int index, Object item) {
        int length = this.items.length;
        Object[] temporary = this.newArray(length + 1);
        if (index >= length) {
            System.arraycopy(this.items, 0, temporary, 0, length);
            temporary[length] = item;
        } else if (index <= 0) {
            temporary[0] = item;
            System.arraycopy(this.items, 0, temporary, 1, length);
        } else {
            System.arraycopy(this.items, 0, temporary, 0, index);
            temporary[index] = item;
            System.arraycopy(this.items, index, temporary, index + 1, length - index);
        }
        this.items = temporary;
        return true;
    }

    public synchronized void clear() {
        this.items = this.newArray(0);
    }

    public synchronized boolean remove(Object item) {
        if (item != null) {
            int i = this.items.length;
            while (i-- > 0) {
                if (!this.equals(item, this.items[i])) continue;
                if (this.items.length == 1) {
                    this.items = this.newArray(0);
                } else {
                    Object[] temporary = this.newArray(this.items.length - 1);
                    System.arraycopy(this.items, 0, temporary, 0, i);
                    if (i < temporary.length) {
                        System.arraycopy(this.items, i + 1, temporary, i, temporary.length - i);
                    }
                    this.items = temporary;
                }
                return true;
            }
        }
        return false;
    }

    public synchronized Object remove(int index) {
        Object item = this.items[index];
        if (this.items.length == 1) {
            this.items = this.newArray(0);
        } else {
            Object[] temporary = this.newArray(this.items.length - 1);
            System.arraycopy(this.items, 0, temporary, 0, index);
            if (index < temporary.length) {
                System.arraycopy(this.items, index + 1, temporary, index, temporary.length - index);
            }
            this.items = temporary;
        }
        return item;
    }

    public synchronized int size() {
        return this.items.length;
    }

    public boolean contains(Object item) {
        Object[] items = this.items;
        for (int i = 0; i < items.length; ++i) {
            if (!this.equals(item, items[i])) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isEmpty() {
        return this.items.length == 0;
    }

    public Iterator iterator() {
        return new ArrayIterator<Object>(this.items);
    }

    public synchronized Object[] getItems() {
        return this.items;
    }

    public String toString() {
        Object[] list = this.items;
        StringBuffer buffer = new StringBuffer("CopyOnWriteList {");
        if (list.length > 0) {
            buffer.append(list[0]);
            for (int i = 1; i < list.length; ++i) {
                buffer.append(' ');
                buffer.append(list[i]);
            }
        }
        buffer.append("}");
        return buffer.toString();
    }

    private Object[] newArray(int size) {
        return size == 0 && this.itemType == Object.class ? NO_OBJECTS : (Object[])Array.newInstance(this.itemType, size);
    }

    protected boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

