/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.util.CommandParser;

public class CommandModel {
    private CommandParser parser;
    private Map values = new HashMap();

    public CommandParser getParser() {
        return this.parser;
    }

    public Object getValue(String name) {
        if (!this.parser.isDefined(name)) {
            throw new IllegalArgumentException(name + " not defined");
        }
        Object value = this.values.get(name);
        if (value instanceof List) {
            List list = (List)value;
            Class<?> type = this.parser.getType(name).getComponentType();
            return list.toArray((Object[])Array.newInstance(type, list.size()));
        }
        return value;
    }

    public <T> T getValue(String name, T defaultValue) {
        Object value = this.getValue(name);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public int getValue(String name, int defaultValue) {
        Number value = (Number)this.getValue(name);
        if (value == null) {
            return defaultValue;
        }
        return value.intValue();
    }

    public String getValue(String name, String defaultValue) {
        String value = (String)this.getValue(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean isAbsent(String name) {
        if (!this.parser.isDefined(name)) {
            throw new IllegalArgumentException(name + " not defined");
        }
        return !this.values.containsKey(name);
    }

    public boolean isPresent(String name) {
        if (!this.parser.isDefined(name)) {
            throw new IllegalArgumentException(name + " not defined");
        }
        return this.values.containsKey(name);
    }

    CommandModel(CommandParser description) {
        this.parser = description;
    }

    void addValue(String name, Object value) {
        ArrayList<Object> list = (ArrayList<Object>)this.values.get(name);
        if (list == null) {
            list = new ArrayList<Object>();
            this.values.put(name, list);
        }
        list.add(value);
    }

    void setValue(String name, Object value) {
        this.values.put(name, value);
    }

    void remove(String name) {
        this.values.remove(name);
    }
}

