/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.patch.PatchStreamContributor;

public class PatchIndexStream {
    private PatchStreamContributor _stream;
    private TextBuffer _textBuffer;
    private String _charsetName;

    public PatchIndexStream(PatchStreamContributor is) {
        this._stream = is;
    }

    String getCharsetName() {
        return this._charsetName;
    }

    protected TextBuffer getTextBuffer() throws IOException {
        if (this._textBuffer != null) {
            return this._textBuffer;
        }
        this._textBuffer = TextBufferFactory.createTextBuffer();
        if (this._stream != null) {
            try (InputStreamReader reader = null;){
                if (this._charsetName != null) {
                    reader = new InputStreamReader(this._stream.getStream(), this._charsetName);
                    this._textBuffer.read(reader);
                } else {
                    reader = new InputStreamReader(this._stream.getStream());
                    this._textBuffer.read(reader);
                }
            }
        }
        return this._textBuffer;
    }

    protected byte[] getBytes() throws IOException {
        if (this._textBuffer == null) {
            throw new IllegalStateException();
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (this._charsetName != null) {
            this._textBuffer.write(new OutputStreamWriter((OutputStream)output, this._charsetName));
        } else {
            this._textBuffer.write(new OutputStreamWriter(output));
        }
        return output.toByteArray();
    }
}

