/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.model;

import java.util.Collection;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;

public interface JavaHasAnnotations
extends JavaElement {
    public Collection<JavaAnnotation> getDeclaredAnnotations();

    public Collection<JavaAnnotation> getAnnotations();

    public JavaAnnotation getDeclaredAnnotation(JavaType var1);

    public JavaAnnotation getAnnotation(JavaType var1);

    default public boolean hasDeclaredAnnotation(String annotationName) {
        if (annotationName == null || annotationName.isEmpty()) {
            return false;
        }
        Collection<JavaAnnotation> annotations = this.getDeclaredAnnotations();
        if (annotations.isEmpty()) {
            return false;
        }
        int dotIndex = annotationName.lastIndexOf(46);
        boolean qualified = false;
        if (dotIndex >= 0) {
            if (dotIndex == 9 && annotationName.substring(0, dotIndex).equals("java.lang")) {
                annotationName = annotationName.substring(dotIndex + 1);
            } else {
                qualified = true;
            }
        }
        for (JavaAnnotation annotation : annotations) {
            String thisAnnotationName = annotation.getUnresolvedType().toString();
            if (!qualified) {
                dotIndex = thisAnnotationName.lastIndexOf(46);
                if (dotIndex >= 0) {
                    thisAnnotationName = thisAnnotationName.substring(dotIndex + 1);
                }
                if (!annotationName.equals(thisAnnotationName)) continue;
                return true;
            }
            if (annotationName.equals(thisAnnotationName)) {
                return true;
            }
            JavaType javaType = annotation.getResolvedType();
            if (javaType == null || !javaType.getRawName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasAnnotation(String annotationName) {
        if (annotationName == null || annotationName.isEmpty()) {
            return false;
        }
        Collection<JavaAnnotation> annotations = this.getAnnotations();
        if (annotations.isEmpty()) {
            return false;
        }
        int dotIndex = annotationName.lastIndexOf(46);
        boolean qualified = false;
        if (dotIndex >= 0) {
            if (dotIndex == 9 && annotationName.substring(0, dotIndex).equals("java.lang")) {
                annotationName = annotationName.substring(dotIndex + 1);
            } else {
                qualified = true;
            }
        }
        for (JavaAnnotation annotation : annotations) {
            String thisAnnotationName = annotation.getUnresolvedType().toString();
            if (!qualified) {
                dotIndex = thisAnnotationName.lastIndexOf(46);
                if (dotIndex >= 0) {
                    thisAnnotationName = thisAnnotationName.substring(dotIndex + 1);
                }
                if (!annotationName.equals(thisAnnotationName)) continue;
                return true;
            }
            if (annotationName.equals(thisAnnotationName)) {
                return true;
            }
            JavaType javaType = annotation.getResolvedType();
            if (javaType == null || !javaType.getRawName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }
}

