/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.util;

import java.util.ArrayList;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.symbol.CommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceHasDocComment;

public class DocCommentHelper
implements InternalConstants {
    private final FileSym fileSym;
    private ArrayList<CommentSym> possibleDocComments = new ArrayList();

    public DocCommentHelper(FileSym fileSym) {
        this.fileSym = fileSym;
    }

    public void process() {
        FindPossibleDocComments st = new FindPossibleDocComments();
        this.fileSym.traverseSelf(st);
        if (this.possibleDocComments.isEmpty()) {
            return;
        }
        SymFactory factory = this.fileSym.getSymFactory();
        int count = this.possibleDocComments.size();
        for (int i = count - 1; i >= 0; --i) {
            SourceHasDocComment element;
            Sym siblingAfter;
            CommentSym commentSym = this.possibleDocComments.get(i);
            for (siblingAfter = commentSym.getSiblingSymAfter(65536); siblingAfter != null && siblingAfter.symKind == 90; siblingAfter = siblingAfter.getSiblingSymAfter(65536)) {
            }
            if (siblingAfter == null || !(siblingAfter instanceof SourceHasDocComment) || (element = (SourceHasDocComment)((Object)siblingAfter)).getDocComment() != null) continue;
            String text = commentSym.getText();
            SourceDocComment docCommentSym = factory.createDocCommentFromText(text);
            element.setDocComment(docCommentSym);
            commentSym.removeSelf();
        }
        this.possibleDocComments.clear();
    }

    private class FindPossibleDocComments
    extends Sym.SymTraversal {
        private FindPossibleDocComments() {
        }

        @Override
        protected boolean enter(Sym sym) {
            if (sym.symKind == 89) {
                CommentSym commentSym = (CommentSym)sym;
                if (commentSym.tokenValue == 26) {
                    DocCommentHelper.this.possibleDocComments.add(commentSym);
                }
            }
            return true;
        }
    }
}

