/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.stmt;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TryResourcesListSym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.FinallyStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.Stmt;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesElement;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesList;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;

public final class TryStmt
extends Stmt
implements SourceTryStatement {
    public TryStmt() {
        this.symFlags = (byte)(this.symFlags | 1);
    }

    @Override
    public short getStatementToken() {
        return 140;
    }

    @Override
    public SourceTryResourcesList getResourceVariablesList() {
        return this.getTryResourcesListSym();
    }

    @Override
    public SourceTryResourcesList getTryResourcesList() {
        return this.getTryResourcesListSym();
    }

    public TryResourcesListSym getTryResourcesListSym() {
        return (TryResourcesListSym)this.getChildOrCreateSkeleton((byte)30);
    }

    @Override
    public List<SourceLocalVariableDeclaration> getResourceVariables() {
        return this.getTryResourcesListSym().getResourceVariables();
    }

    @Override
    public List<SourceTryResourcesElement> getTryResourcesElements() {
        return this.getTryResourcesListSym().getTryResourcesElements();
    }

    @Override
    public boolean hasResourceVariables() {
        return this.hasTryResourcesElements();
    }

    @Override
    public boolean hasTryResourcesElements() {
        TryResourcesListSym list = (TryResourcesListSym)this.getChild((byte)30);
        return list != null && !list.testSymFlag((byte)4);
    }

    @Override
    public List<SourceCatchClause> getCatchClauses() {
        return this.getChildrenList(47);
    }

    @Override
    public SourceFinallyClause getFinallyClause() {
        return this.getFinallyClauseSym();
    }

    public FinallyStmt getFinallyClauseSym() {
        return (FinallyStmt)this.getChild((byte)53);
    }

    @Override
    public SourceStatement getEndClause() {
        return this.getFinallyClause();
    }

    @Override
    public List<JavaType> getCaughtExceptions() {
        ArrayList<JavaType> exceptions = new ArrayList<JavaType>();
        for (CatchStmt catchStmt : this.getCatchClauses()) {
            SourceVariable variableSym = catchStmt.getCatchVariable();
            if (!(variableSym instanceof SourceCatchParameter)) continue;
            List<SourceTypeReference> typeRefs = ((SourceCatchParameter)variableSym).getSourceTypes();
            for (SourceTypeReference typeRef : typeRefs) {
                JavaType caughtType = typeRef.getResolvedType();
                if (caughtType == null) continue;
                exceptions.add(caughtType);
            }
        }
        return exceptions;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 30: 
            case 45: 
            case 47: 
            case 53: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (compiler.skipCompilations()) {
            return super.compileImpl(compiler);
        }
        boolean inTryStmt = true;
        compiler.startStatementFlowAnalysis(this);
        try {
            List<Sym> children = this.getTreeChildren(null);
            for (Sym child : children) {
                if (child.symKind == 53 && inTryStmt) {
                    inTryStmt = false;
                    compiler.endStatementFlowAnalysis(this);
                }
                child.compile(compiler);
            }
            JavaElement javaElement = compiler.compile(this);
            return javaElement;
        }
        finally {
            if (inTryStmt) {
                compiler.endStatementFlowAnalysis(this);
            }
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

