/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import java.util.Collection;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchLabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AssignExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public class SimpleNameExpr
extends Expr
implements SourceSimpleNameExpression {
    @Override
    public Object getConstantValue() {
        JavaHasType result = this.getResolvedObject();
        if (result == null || result.getElementKind() != 5 && result.getElementKind() != 7) {
            return null;
        }
        JavaVariable thing = (JavaVariable)result;
        return thing.getConstantValue();
    }

    @Override
    public Sym getScope() {
        Sym sym;
        for (sym = this.getParentSym(); sym != null && sym.symKind == 65; sym = sym.getParentSym()) {
        }
        if (sym != null && sym.symKind == 23) {
            SwitchLabelSym switchLabel = (SwitchLabelSym)sym;
            return switchLabel.getOwningSwitchSym();
        }
        return super.getScope();
    }

    @Override
    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        JavaType annotationType;
        JavaHasType result;
        Sym grandParentSym;
        JavaAnnotation annotationSym = null;
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 64 && ((AssignExpr)parentSym).exprOptcode == 6 && ((AssignExpr)parentSym).getNthOperandSym(0) == this) {
            Sym greatGrandParentSym;
            grandParentSym = parentSym.getParentSym();
            if (grandParentSym != null && grandParentSym.symKind == 67 && (greatGrandParentSym = grandParentSym.getParentSym()) != null && greatGrandParentSym.symKind == 1) {
                annotationSym = (SourceAnnotation)((Object)greatGrandParentSym);
            }
        } else if (parentSym != null && parentSym.symKind == 67 && (grandParentSym = parentSym.getParentSym()) != null && grandParentSym.symKind == 1) {
            annotationSym = (SourceAnnotation)((Object)grandParentSym);
        }
        if (annotationSym != null) {
            JavaType annotationType2 = annotationSym.getAnnotationType();
            if (annotationType2 == null) {
                return null;
            }
            JavaMethod method = annotationType2.getMethod(this.getName(), null);
            if (method != null) {
                QuickComponent qc = QuickComponent.createComponent(method);
                qc.setOwner(annotationSym);
                return qc;
            }
            if (parentSym.symKind != 67) {
                return null;
            }
        }
        if ((result = compiler.resolve(this)) == null && annotationSym != null && (annotationType = annotationSym.getAnnotationType()) != null) {
            boolean allDefaultMethods = true;
            boolean valueFound = false;
            Collection<JavaMethod> methods = annotationType.getDeclaredMethods();
            for (JavaMethod method : methods) {
                if ("value".equals(method.getName())) {
                    valueFound = true;
                    continue;
                }
                if (method.getDefaultValue() != null) continue;
                allDefaultMethods = false;
                break;
            }
            if (!allDefaultMethods || !valueFound) {
                compiler.error(this, (short)111, this.getName());
            }
        }
        return result;
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        JavaElement result = super.compileImpl(compiler);
        if (!compiler.skipCompilations() && result instanceof Sym) {
            switch (((Sym)result).symKind) {
                case 17: {
                    compiler.localVariableUsedFlowAnalysis((SourceLocalVariable)result, this);
                    break;
                }
                case 13: {
                    compiler.parameterUsedFlowAnalysis((SourceFormalParameter)result, this);
                    break;
                }
                case 28: {
                    compiler.catchParameterUsedFlowAnalysis((SourceCatchParameter)result, this);
                    break;
                }
                case 31: {
                    compiler.lambdaParameterUsedFlowAnalysis((SourceLambdaParameter)result, this);
                    break;
                }
                case 10: {
                    compiler.fieldUsedFlowAnalysis((SourceFieldVariable)result, this);
                }
            }
        }
        return result;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 20: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    private String qualifySelfImpl() {
        JavaType resolvedType;
        JavaHasType resolvedObject = this.getResolvedObject();
        if (resolvedObject instanceof JavaType && (resolvedType = (JavaType)resolvedObject) != null && !resolvedType.isPrimitive() && resolvedType instanceof JavaClass && resolvedType.isExported()) {
            JavaClass javaClass = (JavaClass)resolvedType;
            return javaClass.getQualifiedName();
        }
        return null;
    }

    @Override
    public final void qualifySelf() {
        String qualifiedName = this.qualifySelfImpl();
        if (qualifiedName == null) {
            return;
        }
        SourceFactory factory = this.symFile.getFactory();
        Sym sym = (Sym)((Object)factory.createExpressionFromText(qualifiedName));
        sym.symFormat = (char)(sym.symFormat | 0x10);
        this.replaceSelf(sym);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        String qualifiedName;
        SourcePreferences preferences = this.symFile.getPreferences();
        if (preferences.getBoolean(107) && (qualifiedName = this.qualifySelfImpl()) != null) {
            SourceFactory factory = targetFile.getFactory();
            return (Sym)((Object)factory.createExpressionFromText(qualifiedName));
        }
        return super.cloneSelf(targetFile);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

