/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.parser.ParserDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlanklineSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.CatchParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.CommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldDeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.InitializerSym;
import oracle.javatools.parser.java.v2.internal.symbol.InterfacesSym;
import oracle.javatools.parser.java.v2.internal.symbol.LabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.LambdaParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVardeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModifierSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleExportsSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleExportsToSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleOpensSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleOpensToSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleProvidesSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleProvidesWithSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleRequiresSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleSym;
import oracle.javatools.parser.java.v2.internal.symbol.ModuleUsesSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.internal.symbol.PlaceholderSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.SqljSym;
import oracle.javatools.parser.java.v2.internal.symbol.SuperclassSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchLabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.ThrowsClauseSym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TryResourcesListSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentListSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VersionSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocBlockTagSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocDescriptionSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocInlineTagSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocTagNameSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocTextFragmentSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AnnotateExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayAccessExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AssignExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InfixExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.IntersectionTypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LambdaExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LiteralExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodReferenceExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.QuestionExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypecastExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.UnaryExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.WrapperExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.AssertStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.BlockStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.BreakStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ContinueStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.DoStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ElseStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.EmptyStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ExpressionStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.FinallyStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.IfStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ReturnStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SwitchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SynchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ThrowStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.TryStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.WhileStmt;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceBlockElement;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLexicalBlankline;
import oracle.javatools.parser.java.v2.model.SourceLexicalComment;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceModifier;
import oracle.javatools.parser.java.v2.model.SourceModule;
import oracle.javatools.parser.java.v2.model.SourceModuleBody;
import oracle.javatools.parser.java.v2.model.SourceModuleExports;
import oracle.javatools.parser.java.v2.model.SourceModuleExportsTo;
import oracle.javatools.parser.java.v2.model.SourceModuleOpens;
import oracle.javatools.parser.java.v2.model.SourceModuleOpensTo;
import oracle.javatools.parser.java.v2.model.SourceModuleProvides;
import oracle.javatools.parser.java.v2.model.SourceModuleProvidesWith;
import oracle.javatools.parser.java.v2.model.SourceModuleRequires;
import oracle.javatools.parser.java.v2.model.SourceModuleUses;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesElement;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesList;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeArgumentList;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVersion;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocInlineTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTagName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceAnnotationExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceArrayAccessExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceIntersectionTypeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodReferenceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewArrayExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceWrapperExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceAssertStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceBlockStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceBreakStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceContinueStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceDoStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceElseClause;
import oracle.javatools.parser.java.v2.model.statement.SourceEmptyStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatementLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSynchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceThrowStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceWhileStatement;
import oracle.javatools.parser.java.v2.scanner.LexerLiteral;

public final class SymFactory
extends SourceFactory
implements InternalConstants {
    private static final String nullOrIllegalArgument = "Null or illegal argument";
    private static final String typesNotTheSame = "Types are not all the same";
    private static final String accessNotTheSame = "Access is not all the same";
    private final FileSym symFile;

    public static FileSym createFile() {
        FileSym fileSym = new FileSym();
        fileSym.symKind = (byte)11;
        return fileSym;
    }

    @Override
    public SourceElement createSourceElement(int kind) {
        Sym sym = SymFactory.createNode(this.symFile, kind);
        sym.symFormat = (char)(sym.symFormat | 2);
        return sym;
    }

    @Override
    public SourceExpression createExpression(int code) {
        Expr e = SymFactory.createExpr(this.symFile, (byte)code);
        return e;
    }

    @Override
    public SourceFile getSourceFile() {
        return this.symFile;
    }

    @Override
    public SourceName createName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        return this.createNameSym(name);
    }

    @Override
    public SourceVersion createVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        VersionSym versionSym = (VersionSym)SymFactory.createNode(this.symFile, 42);
        versionSym.versionString = version;
        versionSym.symFormat = (char)(versionSym.symFormat | 2);
        return versionSym;
    }

    @Override
    public SourceModifier createModifier(char modifier) {
        if (modifier == '\u0000') {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModifierSym modifierSym = (ModifierSym)SymFactory.createNode(this.symFile, 43);
        modifierSym.setModifier(modifier);
        modifierSym.symFormat = (char)(modifierSym.symFormat | 2);
        return modifierSym;
    }

    private NameSym createSimpleNameSym(String name, boolean allowThisSuper) {
        if (!(CommonUtilities.isValidIdentifier(name) || allowThisSuper && ("this".equals(name) || "super".equals(name)))) {
            this.throwIllegalArgumentException("Not a valid simple name: ", name);
        }
        return this.createNameSymImpl(name);
    }

    private void throwIllegalArgumentException(String message, String name) {
        StringBuilder buf = new StringBuilder();
        buf.append(message);
        buf.append("'");
        if (name != null) {
            buf.append(name);
        }
        buf.append("'");
        throw new IllegalArgumentException(buf.toString());
    }

    private NameSym createNameSym(String name) {
        this.checkValidQualifiedName(name);
        return this.createNameSymImpl(name);
    }

    private NameSym createNameSymImpl(String name) {
        NameSym nameSym = (NameSym)SymFactory.createNode(this.symFile, 20);
        nameSym.nameString = name;
        nameSym.symFormat = (char)(nameSym.symFormat | 2);
        return nameSym;
    }

    private void checkValidQualifiedName(String name) {
        if (!CommonUtilities.isValidQualifiedName(name)) {
            this.throwIllegalArgumentException("Not a valid qualified name: ", name);
        }
    }

    @Override
    public final SourceTypeReference createType(String name, int dimensions) {
        if (name == null || name.indexOf(60) < 0 && !CommonUtilities.isValidTypeName(name)) {
            throw new IllegalArgumentException("Not a valid name: " + name);
        }
        if (dimensions < 0) {
            throw new IllegalArgumentException("Not a valid dimension: " + dimensions);
        }
        SourceTypeReference type = this.createTypeFromText(name);
        if (type == null) {
            throw new IllegalArgumentException("Not a valid type name: " + name);
        }
        ((TypeSym)type).typeBaseDimension = (short)dimensions;
        return type;
    }

    @Override
    public SourceTypeArgument createTypeArgument(int bound, SourceTypeReference type) {
        if (type == null && bound != 3) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        TypeArgumentSym sym = (TypeArgumentSym)SymFactory.createNode(this.symFile, 25);
        if (type != null) {
            sym.treeChildren = new Sym[]{(Sym)((Object)type)};
        }
        sym.argBound = (byte)bound;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceTypeArgument createTypeArgumentFromText(String text) {
        try {
            if (text == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            return (SourceTypeArgument)((Object)this.createFromText(text, (byte)10));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public SourceTypeArgumentList createTypeArgumentList(SourceTypeArgument[] typeArguments) {
        TypeArgumentListSym sym = (TypeArgumentListSym)SymFactory.createNode(this.symFile, 29);
        if (typeArguments != null && typeArguments.length > 0) {
            sym.treeChildren = new Sym[typeArguments.length];
            for (int i = 0; i < typeArguments.length; ++i) {
                if (typeArguments[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                sym.treeChildren[i] = (Sym)((Object)typeArguments[i]);
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceTryResourcesList createTryResourcesList(SourceLocalVariableDeclaration[] variables) {
        return this.createTryResourcesList((SourceTryResourcesElement[])variables);
    }

    @Override
    public SourceTryResourcesList createTryResourcesList(SourceTryResourcesElement[] elements) {
        TryResourcesListSym sym = (TryResourcesListSym)SymFactory.createNode(this.symFile, 30);
        if (elements != null && elements.length > 0) {
            sym.treeChildren = new Sym[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                sym.treeChildren[i] = (Sym)((Object)elements[i]);
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceLexicalComment createComment(String text) {
        if (text == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        CommentSym sym = (CommentSym)SymFactory.createNode(this.symFile, 89);
        if (text.startsWith("/**")) {
            sym.tokenValue = (short)26;
        } else if (text.startsWith("/*")) {
            sym.tokenValue = (short)25;
        } else if (text.startsWith("//")) {
            sym.tokenValue = (short)24;
        } else {
            throw new IllegalArgumentException(text);
        }
        sym.symFlags = (byte)(sym.symFlags | 0x40);
        sym.tokenText = text;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceLexicalBlankline createBlankline() {
        BlanklineSym sym = (BlanklineSym)SymFactory.createNode(this.symFile, 90);
        SymFactory.finishSym(sym);
        return sym;
    }

    private final Sym createFromText(String text, byte inputKind) {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        textBuffer.insert(0, text.toCharArray());
        try {
            ParserDriver parser = new ParserDriver();
            parser.setTextBuffer(textBuffer);
            Sym sym = parser.parseIsolated(this.symFile, 0, inputKind);
            if (sym != null) {
                sym.symFormat = (char)(sym.symFormat | 2);
            }
            return sym;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Override
    public final SourceAnnotation createAnnotationFromText(String text) {
        if (text == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        try {
            return (SourceAnnotation)((Object)this.createFromText(text, (byte)1));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public SourceExpression createAnnotationArgumentFromText(String text) {
        if (text == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        try {
            return (SourceExpression)((Object)this.createFromText(text, (byte)11));
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    @Override
    public final SourceBlock createBlockFromText(String text) {
        try {
            if (text == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            return (SourceBlock)((Object)this.createFromText(text, (byte)2));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceBlockElement createBlockElementFromText(String text) {
        try {
            if (text == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            return (SourceBlockElement)((Object)this.createFromText(text, (byte)3));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceClass createClassFromText(String text) {
        try {
            if (text == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            return (SourceClass)((Object)this.createFromText(text, (byte)4));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceDocBlockTag createDocBlockTagFromText(String text) {
        if (text == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        if (!text.startsWith("@")) {
            throw new IllegalArgumentException("Doesn't start with '@'.");
        }
        String commentText = "/** " + text + " */";
        SourceDocComment comment = this.createDocCommentFromText(commentText);
        if (comment == null) {
            return null;
        }
        List<SourceDocBlockTag> tags = comment.getBlockTags();
        if (tags.size() == 0) {
            return null;
        }
        try {
            SourceDocBlockTag tag = tags.get(0);
            tag.removeSelf();
            return tag;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceDocComment createDocCommentFromText(String text) {
        try {
            if (text == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            return (SourceDocComment)((Object)this.createFromText(text, (byte)6));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceDocInlineTag createDocInlineTagFromText(String text) {
        if (text == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        if (!text.startsWith("{") || !text.endsWith("}")) {
            throw new IllegalArgumentException("Doesn't start with '{' or end with '}.");
        }
        String commentText = "/** " + text + " */";
        SourceDocComment comment = this.createDocCommentFromText(commentText);
        if (comment == null) {
            return null;
        }
        SourceDocDescription description = comment.getDescription();
        if (description == null) {
            return null;
        }
        Collection<SourceDocInlineTag> tags = description.getInlineTags();
        if (tags.size() == 0) {
            return null;
        }
        try {
            SourceDocInlineTag tag = tags.iterator().next();
            tag.removeSelf();
            return tag;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceExpression createExpressionFromText(String text) {
        try {
            if (text == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            return (SourceExpression)((Object)this.createFromText(text, (byte)5));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceMember createMemberFromText(String text) {
        try {
            if (text == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            return (SourceMember)((Object)this.createFromText(text, (byte)7));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceStatement createStatementFromText(String text) {
        try {
            if (text == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            return (SourceStatement)((Object)this.createFromText(text, (byte)8));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceTypeReference createTypeFromText(String text) {
        try {
            if (text == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            if (text != null && text.indexOf("...") >= 0) {
                return null;
            }
            if (CommonUtilities.containsClassThisSuper(text)) {
                this.throwIllegalArgumentException("Not a valid type name: ", text);
            }
            return (SourceTypeReference)((Object)this.createFromText(text, (byte)9));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public final SourceDocReference createDocMemberReferenceFromText(String text) {
        if (text == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        String actualText = "/**\n * @see " + text + "\n */";
        SourceDocComment comment = this.createDocCommentFromText(actualText);
        if (comment != null) {
            try {
                SourceDocBlockTag seeTag;
                SourceDocReference reference;
                List<SourceDocBlockTag> tags = comment.getBlockTags();
                if (tags.size() > 0 && (reference = (seeTag = tags.get(0)).getReference()) != null) {
                    reference.removeSelf();
                    return reference;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public SourceAnnotation createAnnotation(SourceTypeReference type, SourceListExpression arguments) {
        if (type == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        AnnotateSym sym = (AnnotateSym)SymFactory.createNode(this.symFile, 1);
        sym.treeChildren = arguments != null ? new Sym[]{(Sym)((Object)type), (Sym)((Object)arguments)} : new Sym[]{(Sym)((Object)type)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceAnnotation createAnnotation(String name, SourceListExpression arguments) {
        if (name == null || !CommonUtilities.isValidPackageName(name)) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        SourceTypeReference type = this.createType(name);
        if (type == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        return this.createAnnotation(type, arguments);
    }

    @Override
    public SourceTypeParameter createTypeParameter(String name, SourceTypeReference[] bounds) {
        if (name == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        TypeParameterSym sym = (TypeParameterSym)SymFactory.createNode(this.symFile, 26);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createSimpleNameSym(name, false));
        if (bounds != null) {
            int count = bounds.length;
            for (int i = 0; i < count; ++i) {
                if (bounds[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                data.addKid((Sym)((Object)bounds[i]));
            }
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourcePackage createPackageDeclaration(String name) {
        if (name == null || !CommonUtilities.isValidPackageName(name)) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        PackageSym sym = (PackageSym)SymFactory.createNode(this.symFile, 21);
        sym.treeChildren = new Sym[]{this.createNameSym(name)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceImport createImportDeclaration(int modifiers, String name) {
        if (name == null || !CommonUtilities.isValidImportName(name)) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ImportSym sym = (ImportSym)SymFactory.createNode(this.symFile, 14);
        sym.symAccess = (char)modifiers;
        NameSym nameSym = this.createNameSymImpl(name);
        sym.treeChildren = new Sym[]{nameSym};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceClass createClass(int tyKind, String name, SourceTypeParameter[] tyParameters, SourceSuperclassClause superclassClause, SourceInterfacesClause interfacesClause, SourceClassBody body) {
        if (name == null || tyKind <= -1 || tyKind >= 5) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ClassSym sym = (ClassSym)SymFactory.createNode(this.symFile, 3);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createSimpleNameSym(name, false));
        if (tyParameters == null) {
            tyParameters = SourceTypeParameter.EMPTY_ARRAY;
        }
        int tyParameterCount = tyParameters.length;
        for (int i = 0; i < tyParameterCount; ++i) {
            if (tyParameters[i] == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            data.addKid((Sym)((Object)tyParameters[i]));
        }
        if (superclassClause != null) {
            data.addKid((Sym)((Object)superclassClause));
        }
        if (interfacesClause != null) {
            data.addKid((Sym)((Object)interfacesClause));
        }
        if (body == null) {
            body = this.createClassBody();
        }
        data.addKid((Sym)((Object)body));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        sym.setTypeKind(tyKind);
        return sym;
    }

    @Override
    public SourceMethod createConstructor(SourceTypeParameter[] typeParameters, SourceFormalParameterList parameters, SourceThrowsClause throwsClause, SourceBlock block) {
        MethodSym sym = (MethodSym)SymFactory.createNode(this.symFile, 6);
        SyntaxData data = new SyntaxData();
        if (typeParameters != null) {
            for (SourceTypeParameter typeParam : typeParameters) {
                if (typeParam == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                data.addKid((Sym)((Object)typeParam));
            }
        }
        Sym nameSym = (Sym)((Object)this.createName("Constructor"));
        data.addKid(nameSym);
        if (parameters == null) {
            parameters = this.createFormalParameterList();
        }
        data.addKid((Sym)((Object)parameters));
        if (throwsClause != null) {
            data.addKid((Sym)((Object)throwsClause));
        }
        if (block == null) {
            block = this.createBlock();
        }
        data.addKid((Sym)((Object)block));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceMethod createMethod(SourceTypeParameter[] tyParameters, SourceTypeReference returnType, String methodName, SourceFormalParameterList parameters, SourceThrowsClause throwsClause, SourceBlock block) {
        if (methodName == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        MethodSym sym = (MethodSym)SymFactory.createNode(this.symFile, 19);
        SyntaxData data = new SyntaxData();
        if (tyParameters != null) {
            for (SourceTypeParameter typeParam : tyParameters) {
                if (typeParam == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                data.addKid((Sym)((Object)typeParam));
            }
        }
        if (returnType == null) {
            returnType = this.createType((byte)9);
        }
        data.addKid((Sym)((Object)returnType));
        data.addKid(this.createSimpleNameSym(methodName, false));
        if (parameters == null) {
            parameters = this.createFormalParameterList();
        }
        data.addKid((Sym)((Object)parameters));
        if (throwsClause != null) {
            data.addKid((Sym)((Object)throwsClause));
        }
        if (block != null) {
            data.addKid((Sym)((Object)block));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceEnumConstant createEnumConstant(String name, SourceListExpression arguments, SourceClassBody body) {
        if (name == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        EnumConstantSym sym = (EnumConstantSym)SymFactory.createNode(this.symFile, 7);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createSimpleNameSym(name, false));
        if (arguments != null) {
            data.addKid((Sym)((Object)arguments));
        }
        if (body != null) {
            data.addKid((Sym)((Object)body));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceClassInitializer createClassInitializer(int modifiers, SourceBlock block) {
        if (modifiers != 0 && modifiers != 8) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        InitializerSym sym = (InitializerSym)SymFactory.createNode(this.symFile, 5);
        sym.symAccess = (char)modifiers;
        if (block == null) {
            block = this.createBlock();
        }
        sym.treeChildren = new Sym[]{(Sym)((Object)block)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceFieldVariable createFieldVariable(int modifiers, SourceTypeReference type, String name, int xdimensions, SourceExpression initializer) {
        if (name == null || type == null || xdimensions < 0) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        FieldSym sym = (FieldSym)SymFactory.createNode(this.symFile, 10);
        sym.treeChildren = initializer == null ? new Sym[]{(Sym)((Object)type), this.createSimpleNameSym(name, false)} : new Sym[]{(Sym)((Object)type), this.createSimpleNameSym(name, false), (Sym)((Object)initializer)};
        sym.varXDimension = (short)xdimensions;
        sym.symAccess = (char)modifiers;
        sym.symFormat = (char)(sym.symFormat | 2);
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceFieldVariable createFieldVariable(SourceLocalVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        LocalVariableSym varSym = (LocalVariableSym)variable;
        SourceTypeReference type = (SourceTypeReference)varSym.getSourceType().cloneSelf(this.symFile);
        SourceExpression init = varSym.getInitializer();
        if (init != null) {
            init = (SourceExpression)init.cloneSelf(this.symFile);
        }
        return this.createFieldVariable(varSym.getModifiers(), type, varSym.getName(), init);
    }

    @Override
    public SourceFieldDeclaration createFieldDeclaration(SourceFieldVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        return this.createFieldDeclaration(new SourceFieldVariable[]{variable});
    }

    @Override
    public SourceFieldDeclaration createFieldDeclaration(SourceFieldVariable[] variables) {
        if (variables == null || variables.length == 0 || variables[0] == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        Sym[] variableSyms = new Sym[variables.length];
        SourceTypeReference type = variables[0].getSourceType();
        String typeName = type.getName();
        variableSyms[0] = (Sym)((Object)variables[0]);
        char symAccess = variableSyms[0].symAccess;
        for (int x = 1; x < variables.length; ++x) {
            if (variables[x] == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            if (!typeName.equals(variables[x].getSourceType().getName())) {
                throw new IllegalArgumentException(typesNotTheSame);
            }
            variableSyms[x] = (Sym)((Object)variables[x]);
            if (variableSyms[x].symAccess == symAccess) continue;
            throw new IllegalArgumentException(accessNotTheSame);
        }
        FieldDeclSym sym = (FieldDeclSym)SymFactory.createNode(this.symFile, 9);
        sym.treeChildren = variableSyms;
        sym.symAccess = symAccess;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceFieldDeclaration createFieldDeclaration(SourceLocalVariableDeclaration locals) {
        if (locals == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        List<SourceVariable> localVariables = locals.getVariables();
        SourceFieldVariable[] fields = new SourceFieldVariable[localVariables.size()];
        for (int x = 0; x < localVariables.size(); ++x) {
            fields[x] = this.createFieldVariable((SourceLocalVariable)localVariables.get(x));
        }
        return this.createFieldDeclaration(fields);
    }

    @Override
    public SourceSuperclassClause createSuperclassClause(SourceTypeReference superclass) {
        if (superclass == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        SuperclassSym sym = (SuperclassSym)SymFactory.createNode(this.symFile, 22);
        sym.treeChildren = new Sym[]{(Sym)((Object)superclass)};
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceInterfacesClause createInterfacesClause(SourceTypeReference[] interfaces) {
        if (interfaces == null || interfaces.length == 0) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        InterfacesSym sym = (InterfacesSym)SymFactory.createNode(this.symFile, 15);
        SyntaxData data = new SyntaxData();
        int interfaceCount = interfaces.length;
        for (int i = 0; i < interfaceCount; ++i) {
            if (interfaces[i] == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            data.addKid((Sym)((Object)interfaces[i]));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceClassBody createClassBody(SourceMember[] members) {
        int count;
        ClassBodySym sym = (ClassBodySym)SymFactory.createNode(this.symFile, 4);
        int n = count = members == null ? 0 : members.length;
        if (count > 0) {
            sym.treeChildren = new Sym[count];
            for (int i = 0; i < count; ++i) {
                if (members[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                sym.treeChildren[i] = (Sym)((Object)members[i]);
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceFormalParameter createFormalParameter(SourceLocalVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        LocalVariableSym varSym = (LocalVariableSym)variable;
        if ((varSym.symFormat & 2) == 0) {
            throw new IllegalArgumentException("Only accepts newly created variables");
        }
        FormalParameterSym sym = (FormalParameterSym)SymFactory.createNode(this.symFile, 13);
        sym.treeChildren = varSym.treeChildren;
        int count = sym.treeChildren.length;
        for (int i = 0; i < count; ++i) {
            sym.treeChildren[i].symParent = null;
        }
        varSym.treeChildren = Sym.EMPTY_ARRAY;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceCatchParameter createCatchParameter(SourceTypeReference type, String name) {
        ArrayList<SourceTypeReference> types = new ArrayList<SourceTypeReference>();
        types.add(type);
        return this.createCatchParameter(types, name);
    }

    @Override
    public SourceCatchParameter createCatchParameter(List<SourceTypeReference> types, String name) {
        if (name == null || types == null || types.isEmpty()) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        CatchParameterSym sym = (CatchParameterSym)SymFactory.createNode(this.symFile, 28);
        int typeCount = types.size();
        Sym[] children = new Sym[1 + typeCount];
        int count = 0;
        for (SourceTypeReference type : types) {
            if (type == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            children[count++] = (Sym)((Object)type);
        }
        children[count] = this.createSimpleNameSym(name, false);
        sym.treeChildren = children;
        SymFactory.finishSym(sym);
        return sym;
    }

    private SourceCatchParameter createCatchParameter(SourceFormalParameter formalParameter) {
        if (formalParameter == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        FormalParameterSym formalSym = (FormalParameterSym)formalParameter;
        if ((formalSym.symFormat & 2) == 0) {
            throw new UnsupportedOperationException("Only accepts newly created formal parameters");
        }
        TypeSym type = (TypeSym)formalSym.getChild((byte)27);
        TypeSym clone = (TypeSym)(type == null ? null : type.cloneSelf(type.symFile));
        String name = formalSym.getName();
        if (name == null) {
            throw new UnsupportedOperationException("Only accepts formal parameters with a name");
        }
        formalSym.treeChildren = Sym.EMPTY_ARRAY;
        ArrayList<SourceTypeReference> types = new ArrayList<SourceTypeReference>();
        if (clone != null) {
            types.add(clone);
        }
        SourceCatchParameter sym = this.createCatchParameter(types, name);
        SymFactory.finishSym((CatchParameterSym)sym);
        return sym;
    }

    @Override
    public SourceFormalParameterList createFormalParameterList(SourceFormalParameter[] parameters) {
        int count;
        FormalsSym sym = (FormalsSym)SymFactory.createNode(this.symFile, 12);
        int n = count = parameters == null ? 0 : parameters.length;
        if (count > 0) {
            sym.treeChildren = new Sym[count];
            for (int i = 0; i < count; ++i) {
                if (parameters[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                sym.treeChildren[i] = (Sym)((Object)parameters[i]);
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceThrowsClause createThrowsClause(SourceTypeReference[] exceptions) {
        if (exceptions.length == 0 || exceptions.length == 0) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ThrowsClauseSym sym = (ThrowsClauseSym)SymFactory.createNode(this.symFile, 24);
        int count = exceptions.length;
        sym.treeChildren = new Sym[count];
        for (int i = 0; i < count; ++i) {
            if (exceptions[i] == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            sym.treeChildren[i] = (Sym)((Object)exceptions[i]);
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceLocalVariable createLocalVariable(int modifiers, SourceTypeReference type, String name, int xdimensions, SourceExpression e) {
        if (name == null || type == null || e == null && "super".equals(name) || xdimensions < 0) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        LocalVariableSym sym = (LocalVariableSym)SymFactory.createNode(this.symFile, 17);
        sym.treeChildren = e != null ? new Sym[]{(Sym)((Object)type), this.createSimpleNameSym(name, false), (Sym)((Object)e)} : new Sym[]{(Sym)((Object)type), this.createSimpleNameSym(name, true)};
        sym.varXDimension = (short)xdimensions;
        sym.symAccess = (char)(modifiers &= 0x10);
        sym.symFormat = (char)(sym.symFormat | 2);
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceLocalVariableDeclaration createLocalVariableDeclaration(SourceLocalVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        return this.createLocalVariableDeclaration(new SourceLocalVariable[]{variable});
    }

    @Override
    public SourceLocalVariableDeclaration createLocalVariableDeclaration(SourceLocalVariable[] variables) {
        if (variables == null || variables.length == 0 || variables[0] == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        Sym[] variableSyms = new Sym[variables.length];
        SourceTypeReference type = variables[0].getSourceType();
        String typeName = type.getName();
        variableSyms[0] = (Sym)((Object)variables[0]);
        char symAccess = variableSyms[0].symAccess;
        for (int x = 1; x < variables.length; ++x) {
            if (variables[x] == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            if (!typeName.equals(variables[x].getSourceType().getName())) {
                throw new IllegalArgumentException(typesNotTheSame);
            }
            variableSyms[x] = (Sym)((Object)variables[x]);
            if (variableSyms[x].symAccess == symAccess) continue;
            throw new IllegalArgumentException(accessNotTheSame);
        }
        LocalVardeclSym sym = (LocalVardeclSym)SymFactory.createNode(this.symFile, 18);
        sym.treeChildren = variableSyms;
        sym.symAccess = symAccess;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceBlock createBlock(SourceElement[] elements) {
        int elementCount;
        BlockSym sym = (BlockSym)SymFactory.createNode(this.symFile, 2);
        int n = elementCount = elements == null ? 0 : elements.length;
        if (elementCount > 0) {
            sym.treeChildren = new Sym[elementCount];
            for (int i = 0; i < elementCount; ++i) {
                if (elements[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                sym.treeChildren[i] = (Sym)elements[i];
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModule createModule(String name, SourceModuleBody body) {
        if (name == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModuleSym sym = (ModuleSym)SymFactory.createNode(this.symFile, 32);
        sym.symAccess = Sym.ty2access((byte)4);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createNameSym(name));
        if (body == null) {
            body = this.createModuleBody(null, null, null, null, null);
        }
        data.addKid((Sym)((Object)body));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModuleBody createModuleBody(List<SourceModuleRequires> requires, List<SourceModuleExports> exports, List<SourceModuleOpens> opens, List<SourceModuleUses> uses, List<SourceModuleProvides> provides) {
        ModuleBodySym sym = (ModuleBodySym)SymFactory.createNode(this.symFile, 33);
        SyntaxData data = new SyntaxData();
        if (requires != null) {
            for (SourceModuleRequires require : requires) {
                data.addKid((Sym)((Object)require));
            }
        }
        if (exports != null) {
            for (SourceModuleExports export : exports) {
                data.addKid((Sym)((Object)export));
            }
        }
        if (opens != null) {
            for (SourceModuleOpens open : opens) {
                data.addKid((Sym)((Object)open));
            }
        }
        if (uses != null) {
            for (SourceModuleUses use : uses) {
                data.addKid((Sym)((Object)use));
            }
        }
        if (provides != null) {
            for (SourceModuleProvides provide : provides) {
                data.addKid((Sym)((Object)provide));
            }
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModuleRequires createModuleRequires(String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModuleRequiresSym sym = (ModuleRequiresSym)SymFactory.createNode(this.symFile, 34);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createNameSym(moduleName));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModuleExports createModuleExports(String packageName, SourceModuleExportsTo exportsToClause) {
        if (packageName == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModuleExportsSym sym = (ModuleExportsSym)SymFactory.createNode(this.symFile, 35);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createNameSym(packageName));
        if (exportsToClause != null) {
            data.addKid((Sym)((Object)exportsToClause));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModuleExportsTo createModuleExportsTo(List<String> moduleNames) {
        if (moduleNames == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModuleExportsToSym sym = (ModuleExportsToSym)SymFactory.createNode(this.symFile, 36);
        SyntaxData data = new SyntaxData();
        for (String moduleName : moduleNames) {
            data.addKid(this.createNameSym(moduleName));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModuleOpens createModuleOpens(String packageName, SourceModuleOpensTo opensToClause) {
        if (packageName == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModuleOpensSym sym = (ModuleOpensSym)SymFactory.createNode(this.symFile, 40);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createNameSym(packageName));
        if (opensToClause != null) {
            data.addKid((Sym)((Object)opensToClause));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModuleOpensTo createModuleOpensTo(List<String> moduleNames) {
        if (moduleNames == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModuleOpensToSym sym = (ModuleOpensToSym)SymFactory.createNode(this.symFile, 41);
        SyntaxData data = new SyntaxData();
        for (String moduleName : moduleNames) {
            data.addKid(this.createNameSym(moduleName));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModuleUses createModuleUses(String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModuleUsesSym sym = (ModuleUsesSym)SymFactory.createNode(this.symFile, 37);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createNameSym(moduleName));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModuleProvides createModuleProvides(String interfaceName, SourceModuleProvidesWith providesWithClause) {
        if (interfaceName == null || providesWithClause == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModuleProvidesSym sym = (ModuleProvidesSym)SymFactory.createNode(this.symFile, 38);
        SyntaxData data = new SyntaxData();
        data.addKid(this.createNameSym(interfaceName));
        data.addKid((Sym)((Object)providesWithClause));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceModuleProvidesWith createModuleProvidesWith(List<String> interfaceImplementations) {
        if (interfaceImplementations == null || interfaceImplementations.isEmpty()) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ModuleProvidesWithSym sym = (ModuleProvidesWithSym)SymFactory.createNode(this.symFile, 39);
        SyntaxData data = new SyntaxData();
        for (String interfaceImplementation : interfaceImplementations) {
            data.addKid(this.createNameSym(interfaceImplementation));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceAssertStatement createAssertStatement(SourceExpression condition, SourceExpression output) {
        if (condition == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        AssertStmt sym = (AssertStmt)SymFactory.createNode(this.symFile, 44);
        sym.treeChildren = output != null ? new Sym[]{(Sym)((Object)condition), (Sym)((Object)output)} : new Sym[]{(Sym)((Object)condition)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceBlockStatement createBlockStatement(SourceBlock block) {
        BlockStmt sym = (BlockStmt)SymFactory.createNode(this.symFile, 45);
        if (block == null) {
            block = this.createBlock(SourceElement.EMPTY_ARRAY);
        }
        sym.treeChildren = new Sym[]{(Sym)((Object)block)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceBreakStatement createBreakStatement(String target) {
        if (target != null && !CommonUtilities.isValidIdentifier(target)) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        BreakStmt sym = (BreakStmt)SymFactory.createNode(this.symFile, 46);
        if (target != null) {
            sym.treeChildren = new Sym[]{this.createSimpleNameSym(target, false)};
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    @Deprecated
    public SourceCatchClause createCatchClause(SourceFormalParameterList parameters, SourceBlockStatement block) {
        if (parameters == null || parameters.getSourceParameters().size() != 1) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        List<SourceVariable> vars = parameters.getSourceParameters();
        SourceVariable var = vars.get(0);
        if (var == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        if (var.getSymbolKind() == 13) {
            FormalsSym formals = (FormalsSym)parameters;
            if ((formals.symFormat & 2) == 0) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            var = this.createCatchParameter((SourceFormalParameter)var);
            formals.treeChildren = Sym.EMPTY_ARRAY;
        } else if (var.getSymbolKind() != 28) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        return this.createCatchClause((SourceCatchParameter)var, block);
    }

    @Override
    public SourceCatchClause createCatchClause(SourceCatchParameter parameter, SourceBlockStatement block) {
        if (parameter == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        FormalsSym parameters = (FormalsSym)this.createFormalParameterList(new SourceFormalParameter[]{parameter});
        CatchStmt sym = (CatchStmt)SymFactory.createNode(this.symFile, 47);
        Sym one = (Sym)((Object)this.createClause(block));
        sym.treeChildren = new Sym[]{parameters, one};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceContinueStatement createContinueStatement(String target) {
        if (target != null && !CommonUtilities.isValidIdentifier(target)) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ContinueStmt sym = (ContinueStmt)SymFactory.createNode(this.symFile, 48);
        if (target != null) {
            sym.treeChildren = new Sym[]{this.createSimpleNameSym(target, false)};
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceDoStatement createDoStatement(SourceExpression e, SourceStatement child) {
        if (e == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        DoStmt sym = (DoStmt)SymFactory.createNode(this.symFile, 49);
        if (e.getSymbolKind() != 77) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{one, (Sym)((Object)e)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceElseClause createElseClause(SourceStatement child) {
        ElseStmt sym = (ElseStmt)SymFactory.createNode(this.symFile, 50);
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{one};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceEmptyStatement createEmptyStatement() {
        EmptyStmt sym = (EmptyStmt)SymFactory.createNode(this.symFile, 51);
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceExpressionStatement createExpressionStatement(SourceExpression e) {
        if (e == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ExpressionStmt sym = (ExpressionStmt)SymFactory.createNode(this.symFile, 52);
        sym.treeChildren = new Sym[]{(Sym)((Object)e)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceFinallyClause createFinallyClause(SourceBlockStatement child) {
        FinallyStmt sym = (FinallyStmt)SymFactory.createNode(this.symFile, 53);
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{one};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceForStatement createForStatement(SourceListExpression inits, SourceExpression condition, SourceListExpression updates, SourceStatement child) {
        ForStmt sym = (ForStmt)SymFactory.createNode(this.symFile, 54);
        sym.forType = 0;
        if (inits == null) {
            inits = this.createExpressionList();
        }
        if (inits.getOperandCount() > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0x20);
        }
        if (condition != null) {
            sym.symFlags = (byte)(sym.symFlags | 0x40);
        }
        if (updates == null) {
            updates = this.createExpressionList();
        }
        if (updates.getOperandCount() > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0xFFFFFF80);
        }
        SyntaxData data = new SyntaxData();
        data.addKid((Sym)((Object)inits));
        data.addKid((Sym)((Object)condition));
        data.addKid((Sym)((Object)updates));
        data.addKid((Sym)((Object)this.createClause(child)));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceForStatement createForVariableStatement(SourceLocalVariableDeclaration variables, SourceExpression condition, SourceListExpression updates, SourceStatement child) {
        if (variables == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ForStmt sym = (ForStmt)SymFactory.createNode(this.symFile, 54);
        sym.forType = 1;
        if (condition != null) {
            sym.symFlags = (byte)(sym.symFlags | 0x40);
        }
        if (updates == null) {
            updates = this.createExpressionList();
        }
        if (updates.getOperandCount() > 0) {
            sym.symFlags = (byte)(sym.symFlags | 0xFFFFFF80);
        }
        SyntaxData data = new SyntaxData();
        data.addKid((Sym)((Object)variables));
        data.addKid((Sym)((Object)condition));
        data.addKid((Sym)((Object)updates));
        data.addKid((Sym)((Object)this.createClause(child)));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceForStatement createForEnhancedStatement(SourceLocalVariableDeclaration d, SourceExpression collection, SourceStatement child) {
        if (d == null || collection == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ForStmt sym = (ForStmt)SymFactory.createNode(this.symFile, 54);
        sym.forType = (byte)2;
        SourceStatement last = this.createClause(child);
        sym.treeChildren = new Sym[]{(Sym)((Object)d), (Sym)((Object)collection), (Sym)((Object)last)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceIfStatement createIfStatement(SourceExpression e, SourceStatement child) {
        if (e == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        IfStmt sym = (IfStmt)SymFactory.createNode(this.symFile, 55);
        if (e.getSymbolKind() != 77) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{(Sym)((Object)e), one};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceIfStatement createIfStatement(SourceExpression e, SourceStatement child, SourceElseClause clause) {
        if (e == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        IfStmt sym = (IfStmt)SymFactory.createNode(this.symFile, 55);
        if (e.getSymbolKind() != 77) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = clause == null ? new Sym[]{(Sym)((Object)e), one} : new Sym[]{(Sym)((Object)e), one, (Sym)((Object)clause)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceReturnStatement createReturnStatement(SourceExpression e) {
        ReturnStmt sym = (ReturnStmt)SymFactory.createNode(this.symFile, 56);
        if (e != null) {
            sym.treeChildren = new Sym[]{(Sym)((Object)e)};
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceSwitchStatement createSwitchStatement(SourceExpression e, SourceBlockStatement child) {
        if (e == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        SwitchStmt sym = (SwitchStmt)SymFactory.createNode(this.symFile, 57);
        if (e.getSymbolKind() != 77) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{(Sym)((Object)e), one};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceSynchStatement createSynchronizedStatement(SourceExpression e, SourceBlockStatement child) {
        if (e == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        SynchStmt sym = (SynchStmt)SymFactory.createNode(this.symFile, 58);
        if (e.getSymbolKind() != 77) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{(Sym)((Object)e), one};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceThrowStatement createThrowStatement(SourceExpression e) {
        if (e == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ThrowStmt sym = (ThrowStmt)SymFactory.createNode(this.symFile, 59);
        sym.treeChildren = new Sym[]{(Sym)((Object)e)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceTryStatement createTryStatement(SourceBlockStatement tryClause, SourceCatchClause[] catchClauses, SourceFinallyClause finallyClause) {
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 60);
        SyntaxData data = new SyntaxData();
        data.addKid((Sym)((Object)this.createClause(tryClause)));
        int catchCount = catchClauses == null ? 0 : catchClauses.length;
        for (int i = 0; i < catchCount; ++i) {
            if (catchClauses[i] == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            data.addKid((Sym)((Object)catchClauses[i]));
        }
        if (finallyClause != null) {
            data.addKid((Sym)((Object)finallyClause));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    @Deprecated
    public SourceTryStatement createTryCatchStatement(SourceBlockStatement tryClause, SourceFormalParameterList parameters, SourceBlockStatement catchClause) {
        if (parameters == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 60);
        Sym one = (Sym)((Object)this.createClause(tryClause));
        Sym two = (Sym)((Object)this.createCatchClause(parameters, catchClause));
        sym.treeChildren = new Sym[]{one, two};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceTryStatement createTryCatchStatement(SourceBlockStatement tryClause, SourceCatchParameter parameter, SourceBlockStatement catchClause) {
        if (parameter == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 60);
        Sym one = (Sym)((Object)this.createClause(tryClause));
        Sym two = (Sym)((Object)this.createCatchClause(parameter, catchClause));
        sym.treeChildren = new Sym[]{one, two};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    @Deprecated
    public SourceTryStatement createTryCatchFinallyStatement(SourceBlockStatement tryClause, SourceFormalParameterList parameters, SourceBlockStatement catchClause, SourceBlockStatement finallyClause) {
        if (parameters == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 60);
        Sym one = (Sym)((Object)this.createClause(tryClause));
        Sym two = (Sym)((Object)this.createCatchClause(parameters, catchClause));
        Sym three = (Sym)((Object)this.createFinallyClause(finallyClause));
        sym.treeChildren = new Sym[]{one, two, three};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceTryStatement createTryCatchFinallyStatement(SourceBlockStatement tryClause, SourceCatchParameter parameter, SourceBlockStatement catchClause, SourceBlockStatement finallyClause) {
        if (parameter == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 60);
        Sym one = (Sym)((Object)this.createClause(tryClause));
        Sym two = (Sym)((Object)this.createCatchClause(parameter, catchClause));
        Sym three = (Sym)((Object)this.createFinallyClause(finallyClause));
        sym.treeChildren = new Sym[]{one, two, three};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceTryStatement createTryFinallyStatement(SourceBlockStatement tryClause, SourceBlockStatement finallyClause) {
        TryStmt sym = (TryStmt)SymFactory.createNode(this.symFile, 60);
        Sym one = (Sym)((Object)this.createClause(tryClause));
        Sym two = (Sym)((Object)this.createFinallyClause(finallyClause));
        sym.treeChildren = new Sym[]{one, two};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceWhileStatement createWhileStatement(SourceExpression e, SourceStatement child) {
        if (e == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        WhileStmt sym = (WhileStmt)SymFactory.createNode(this.symFile, 61);
        if (e.getSymbolKind() != 77) {
            e = this.createWrapperExpression(e);
        }
        Sym one = (Sym)((Object)this.createClause(child));
        sym.treeChildren = new Sym[]{(Sym)((Object)e), one};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceStatementLabel createStatementLabel(String name) {
        if (name == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        LabelSym sym = (LabelSym)SymFactory.createNode(this.symFile, 16);
        NameSym nameSym = this.createSimpleNameSym(name, false);
        sym.treeChildren = new Sym[]{nameSym};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceSwitchLabel createSwitchCaseLabel(SourceExpression e) {
        SwitchLabelSym sym = (SwitchLabelSym)SymFactory.createNode(this.symFile, 23);
        if (e != null) {
            sym.treeChildren = new Sym[]{(Sym)((Object)e)};
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceSwitchLabel createSwitchDefaultLabel() {
        SwitchLabelSym sym = (SwitchLabelSym)SymFactory.createNode(this.symFile, 23);
        SymFactory.finishSym(sym);
        return sym;
    }

    private SourceStatement createClause(SourceStatement statement) {
        if (statement != null) {
            return statement;
        }
        return this.createEmptyStatement();
    }

    private SourceBlockStatement createClause(SourceBlockStatement statement) {
        if (statement != null) {
            return statement;
        }
        return this.createBlockStatement(null);
    }

    @Override
    public SourceAnnotationExpression createAnnotationExpression(SourceAnnotation a) {
        if (a == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        AnnotateExpr sym = (AnnotateExpr)SymFactory.createExpr(this.symFile, (byte)4);
        sym.treeChildren = new Sym[]{(Sym)((Object)a)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceArrayAccessExpression createArrayAccess(SourceExpression lhs, SourceListExpression dereferences) {
        if (lhs == null || dereferences == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ArrayAccessExpr sym = (ArrayAccessExpr)SymFactory.createExpr(this.symFile, (byte)16);
        sym.treeChildren = new Sym[]{(Sym)((Object)lhs), (Sym)((Object)dereferences)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceListExpression createArrayConstant(SourceExpression[] operands) {
        if (operands == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ListExpr sym = (ListExpr)SymFactory.createExpr(this.symFile, (byte)5);
        int operandCount = operands.length;
        if (operandCount > 0) {
            sym.treeChildren = new Sym[operandCount];
            for (int i = 0; i < operandCount; ++i) {
                if (operands[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                sym.treeChildren[i] = (Sym)((Object)operands[i]);
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceAssignmentExpression createAssignment(int code, SourceExpression lhs, SourceExpression rhs) {
        AssignExpr sym;
        if (lhs == null || rhs == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        try {
            sym = (AssignExpr)SymFactory.createExpr(this.symFile, (byte)code);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(cce);
        }
        sym.treeChildren = new Sym[]{(Sym)((Object)lhs), (Sym)((Object)rhs)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    protected SourceNewArrayExpression createNewArrayExpressionImpl(SourceTypeReference type, SourceListExpression list, int requiredListCode) {
        if (type == null || list == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        int listCode = list.getExpressionCode();
        if (listCode != requiredListCode) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ArrayCreatorExpr sym = (ArrayCreatorExpr)SymFactory.createExpr(this.symFile, (byte)39);
        sym.treeChildren = new Sym[]{(Sym)((Object)type), (Sym)((Object)list)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceNewClassExpression createNewClassExpression(SourceExpression lhs, SourceTypeReference type, SourceListExpression arguments, SourceClassBody body) {
        if (type == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        ClassCreatorExpr sym = (ClassCreatorExpr)SymFactory.createExpr(this.symFile, (byte)40);
        SyntaxData data = new SyntaxData();
        if (lhs != null) {
            data.addKid((Sym)((Object)lhs));
        }
        data.addKid((Sym)((Object)type));
        if (arguments == null) {
            arguments = this.createArgumentList(SourceExpression.EMPTY_ARRAY);
        }
        data.addKid((Sym)((Object)arguments));
        if (body != null) {
            SourceClass anonymousClass = this.createAnonymousClass(type, body);
            data.addKid((Sym)((Object)anonymousClass));
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public boolean addAnonymousClass(SourceNewClassExpression expr, SourceClassBody body) {
        if (expr == null || body == null || expr.getAnonymousClass() != null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        SourceTypeReference originalType = expr.getSourceType();
        if (originalType == null) {
            return false;
        }
        SourceTypeReference clonedType = this.createType(originalType.getName());
        this.createAnonymousClass(clonedType, body).addSelf(expr);
        return true;
    }

    private SourceClass createAnonymousClass(SourceTypeReference type, SourceClassBody body) {
        ClassSym sym = (ClassSym)SymFactory.createNode(this.symFile, 3);
        sym.symFlags = (byte)(sym.symFlags | 0xFFFFFF80);
        sym.tySuper = (TypeSym)type;
        SyntaxData data = new SyntaxData();
        data.addKid((Sym)((Object)body));
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        sym.setTypeKind(0);
        return sym;
    }

    @Override
    public SourceDotExpression createDotReference(SourceExpression lhs, String name) {
        if (lhs == null || name == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        DotExpr sym = (DotExpr)SymFactory.createExpr(this.symFile, (byte)19);
        sym.treeChildren = new Sym[]{(Sym)((Object)lhs), this.createSimpleNameSym(name, true)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceListExpression createExpressionList(SourceExpression[] arguments) {
        int argumentCount;
        ListExpr sym = (ListExpr)SymFactory.createExpr(this.symFile, (byte)26);
        if (arguments != null && (argumentCount = arguments.length) > 0) {
            sym.treeChildren = new Sym[argumentCount];
            for (int i = 0; i < argumentCount; ++i) {
                if (arguments[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                sym.treeChildren[i] = (Sym)((Object)arguments[i]);
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceInfixExpression createInfixExpression(int code, SourceExpression lhs, SourceExpression rhs) {
        InfixExpr sym;
        if (lhs == null || rhs == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        try {
            sym = (InfixExpr)SymFactory.createExpr(this.symFile, (byte)code);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(cce);
        }
        sym.treeChildren = new Sym[]{(Sym)((Object)lhs), (Sym)((Object)rhs)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceInfixExpression createInfixExpression(int code, SourceExpression[] operands) {
        InfixExpr sym;
        if (operands == null || operands.length < 2) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        try {
            sym = (InfixExpr)SymFactory.createExpr(this.symFile, (byte)code);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(cce);
        }
        int operandCount = operands.length;
        sym.treeChildren = new Sym[operandCount];
        for (int i = 0; i < operandCount; ++i) {
            if (operands[i] == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            sym.treeChildren[i] = (Sym)((Object)operands[i]);
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceMethodCallExpression createMethodCall(SourceExpression lhs, SourceTypeArgument[] typeArguments, String name, SourceListExpression arguments) {
        if (name == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        MethodCallExpr sym = (MethodCallExpr)SymFactory.createExpr(this.symFile, (byte)24);
        int childCount = 2;
        if (lhs != null) {
            ++childCount;
        }
        SourceTypeArgumentList typeArgList = null;
        if (typeArguments != null) {
            typeArgList = this.createTypeArgumentList(typeArguments);
            ++childCount;
        }
        if (arguments == null) {
            arguments = this.createArgumentList(SourceExpression.EMPTY_ARRAY);
        }
        sym.treeChildren = new Sym[childCount];
        int addedCount = 0;
        if (lhs != null) {
            sym.treeChildren[addedCount++] = (Sym)((Object)lhs);
        }
        sym.treeChildren[addedCount++] = this.createSimpleNameSym(name, true);
        sym.treeChildren[addedCount++] = (Sym)((Object)arguments);
        if (typeArgList != null) {
            sym.treeChildren[addedCount++] = (Sym)((Object)typeArgList);
        }
        assert (addedCount == childCount);
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceQuestionExpression createQuestionExpression(SourceExpression one, SourceExpression two, SourceExpression three) {
        if (one == null || two == null || three == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        QuestionExpr sym = (QuestionExpr)SymFactory.createExpr(this.symFile, (byte)15);
        sym.treeChildren = new Sym[]{(Sym)((Object)one), (Sym)((Object)two), (Sym)((Object)three)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceSimpleNameExpression createSimpleNameExpression(String name) {
        if (name == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        NameSym nameSym = this.createSimpleNameSym(name, true);
        SimpleNameExpr sym = (SimpleNameExpr)SymFactory.createExpr(this.symFile, (byte)53);
        sym.treeChildren = new Sym[]{nameSym};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceTypeExpression createTypeExpression(SourceTypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        TypeExpr sym = (TypeExpr)SymFactory.createExpr(this.symFile, (byte)54);
        sym.treeChildren = new Sym[]{(Sym)((Object)type)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceIntersectionTypeExpression createIntersectionTypeExpression(SourceTypeReference[] types) {
        if (types == null || types.length < 2) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        IntersectionTypeExpr sym = (IntersectionTypeExpr)SymFactory.createExpr(this.symFile, (byte)60);
        sym.treeChildren = new Sym[types.length];
        for (int x = 0; x < types.length; ++x) {
            sym.treeChildren[x] = (Sym)((Object)this.createTypeExpression(types[x]));
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceTypecastExpression createTypecast(SourceTypeReference type, SourceExpression operand) {
        if (type == null || operand == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        TypecastExpr sym = (TypecastExpr)SymFactory.createExpr(this.symFile, (byte)55);
        TypeExpr typeExpr = (TypeExpr)this.createTypeExpression(type);
        sym.treeChildren = new Sym[]{typeExpr, (Sym)((Object)operand)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceTypecastExpression createTypecast(SourceTypeReference[] types, SourceExpression operand) {
        if (types == null || types.length < 2 || operand == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        TypecastExpr sym = (TypecastExpr)SymFactory.createExpr(this.symFile, (byte)55);
        IntersectionTypeExpr typeCast = (IntersectionTypeExpr)this.createIntersectionTypeExpression(types);
        sym.treeChildren = new Sym[]{typeCast, (Sym)((Object)operand)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceUnaryExpression createUnaryExpression(int code, SourceExpression operand) {
        UnaryExpr sym;
        if (operand == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        try {
            sym = (UnaryExpr)SymFactory.createExpr(this.symFile, (byte)code);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(cce);
        }
        sym.treeChildren = new Sym[]{(Sym)((Object)operand)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceWrapperExpression createWrapperExpression(SourceExpression operand) {
        if (operand == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        WrapperExpr sym = (WrapperExpr)SymFactory.createExpr(this.symFile, (byte)38);
        sym.treeChildren = new Sym[]{(Sym)((Object)operand)};
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceMethodReferenceExpression createMethodReferenceExpression(SourceExpression lhs, SourceTypeArgument[] typeArguments, String methodName) {
        if (lhs == null || methodName == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        SourceTypeArgumentList typeArgList = null;
        if (typeArguments != null) {
            typeArgList = this.createTypeArgumentList(typeArguments);
        }
        MethodReferenceExpr sym = (MethodReferenceExpr)SymFactory.createExpr(this.symFile, (byte)58);
        int childLength = 2 + (typeArgList != null ? 1 : 0);
        sym.treeChildren = new Sym[childLength];
        sym.treeChildren[0] = (Sym)((Object)lhs);
        if (typeArgList != null) {
            sym.treeChildren[1] = (Sym)((Object)typeArgList);
        }
        sym.treeChildren[childLength - 1] = this.createSimpleNameSym(methodName, false);
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceLambdaParameter createLambdaParameter(int modifiers, SourceTypeReference type, String name) {
        if (name == null || !CommonUtilities.isValidIdentifier(name)) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        LambdaParameterSym sym = (LambdaParameterSym)SymFactory.createNode(this.symFile, 31);
        if (type == null) {
            sym.setInferredFormalParamater(true);
            sym.treeChildren = new Sym[]{this.createSimpleNameSym(name, false)};
        } else {
            sym.treeChildren = new Sym[]{(Sym)((Object)type), this.createNameSym(name)};
        }
        sym.symAccess = (char)modifiers;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceLambdaExpression createLambdaExpression(SourceLambdaParameter[] parameters, SourceElement body) {
        SourceFormalParameterList parameterList = parameters == null || parameters.length == 0 ? this.createFormalParameterList() : this.createFormalParameterList(parameters);
        return this.createLambdaExpression(parameterList, true, body);
    }

    @Override
    public SourceLambdaExpression createLambdaExpression(String[] inferredParameterNames, boolean parenthesizeParameters, SourceElement body) {
        SourceFormalParameterList parametersSym;
        boolean addParentheses = true;
        if (inferredParameterNames == null || inferredParameterNames.length == 0) {
            parametersSym = this.createFormalParameterList();
        } else {
            SourceFormalParameter[] parameters = new LambdaParameterSym[inferredParameterNames.length];
            for (int x = 0; x < inferredParameterNames.length; ++x) {
                parameters[x] = (LambdaParameterSym)SymFactory.createNode(this.symFile, 31);
                ((LambdaParameterSym)parameters[x]).setInferredFormalParamater(true);
                ((LambdaParameterSym)parameters[x]).treeChildren = new Sym[]{this.createSimpleNameSym(inferredParameterNames[x], false)};
                SymFactory.finishSym((TreeSym)((Object)parameters[x]));
            }
            parametersSym = this.createFormalParameterList(parameters);
            addParentheses = inferredParameterNames.length > 1 || parenthesizeParameters;
        }
        return this.createLambdaExpression(parametersSym, addParentheses, body);
    }

    private SourceLambdaExpression createLambdaExpression(SourceFormalParameterList parameters, boolean parenthesizeParameters, SourceElement body) {
        if (body == null || body.getSymbolKind() != 2 && !((Sym)body).isFilter((byte)102)) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        LambdaExpr sym = (LambdaExpr)SymFactory.createExpr(this.symFile, (byte)59);
        sym.setParenthesizedParameters(parenthesizeParameters);
        int childLength = 2;
        sym.treeChildren = new Sym[childLength];
        sym.treeChildren[0] = (Sym)((Object)parameters);
        sym.treeChildren[1] = (Sym)body;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceLiteralExpression createLiteralExpression(Object object) {
        LexerLiteral literal = LexerLiteral.createConstant(object);
        if (literal == null) {
            return null;
        }
        LiteralExpr expr = (LiteralExpr)this.createExpression(27);
        expr.literal = literal;
        switch (literal.literalToken) {
            case 15: {
                expr.literalString = "null";
                break;
            }
            case 13: {
                expr.literalString = "'" + object.toString() + "'";
                break;
            }
            case 14: {
                expr.literalString = "\"" + object.toString() + "\"";
                break;
            }
            default: {
                expr.literalString = object.toString();
            }
        }
        SymFactory.finishSym(expr);
        return expr;
    }

    @Override
    public SourceExpression createClassLiteralExpression(String fullyQualifiedTypeName) {
        SourceTypeReference typeRef = this.createType(fullyQualifiedTypeName);
        if (typeRef != null) {
            return this.createUnaryExpression(14, this.createTypeExpression(typeRef));
        }
        return null;
    }

    @Override
    public SourceDocComment createDocComment(SourceDocDescription description, SourceDocBlockTag[] tags) {
        DocCommentSym sym = (DocCommentSym)SymFactory.createNode(this.symFile, 83);
        SyntaxData data = new SyntaxData();
        if (description != null) {
            data.addKid((Sym)((Object)description));
        }
        if (tags != null && tags.length > 0) {
            int tagCount = tags.length;
            for (int i = 0; i < tagCount; ++i) {
                if (tags[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                data.addKid((Sym)((Object)tags[i]));
            }
        }
        sym.symData = data;
        sym.buildSelf();
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceDocTextFragment createDocTextFragment(String text) {
        if (text == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        DocTextFragmentSym sym = (DocTextFragmentSym)SymFactory.createDocElement(null, 88);
        sym.symFile = this.symFile;
        sym.textString = text;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceDocDescription createDocDescription(SourceDocTextFragment[] lines) {
        DocDescriptionSym sym = (DocDescriptionSym)SymFactory.createDocElement(null, 84);
        sym.symFile = this.symFile;
        if (lines != null && lines.length > 0) {
            SyntaxData data = new SyntaxData();
            int count = lines.length;
            for (int i = 0; i < count; ++i) {
                String text;
                if (lines[i] == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                DocTextFragmentSym textSym = (DocTextFragmentSym)lines[i];
                if (i != count - 1 && !(text = textSym.textString).endsWith("\n") && !text.endsWith("\r")) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                data.addKid((Sym)((Object)lines[i]));
            }
            sym.symData = data;
            sym.buildSelf();
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public final SourceDocTagName createDocTagName(short tag) {
        if (tag < 202 || tag >= 222) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        return this.createDocTagName(TAG_words[tag - 202]);
    }

    @Override
    public SourceDocTagName createDocTagName(String name) {
        if (name == null || !name.startsWith("@")) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        DocTagNameSym sym = (DocTagNameSym)SymFactory.createDocElement(null, 87);
        sym.symFile = this.symFile;
        sym.tagCode = DocTagNameSym.lookupTag(name);
        sym.tagName = name;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceDocReference createDocParameterReference(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        DocReferenceSym sym = (DocReferenceSym)SymFactory.createDocElement(null, 86);
        sym.symFile = this.symFile;
        sym.refParameterName = parameterName;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceDocReference createDocReference(String classString, String memberName, String[] parameterTypes) {
        if (classString == null && memberName == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        DocReferenceSym sym = (DocReferenceSym)SymFactory.createDocElement(null, 86);
        sym.symFile = this.symFile;
        sym.refClassName = classString;
        sym.refMemberName = memberName;
        if (parameterTypes != null) {
            sym.refMethodParameters = new ArrayList<String>(parameterTypes.length);
            for (String parameterType : parameterTypes) {
                if (parameterType == null) {
                    throw new IllegalArgumentException(nullOrIllegalArgument);
                }
                sym.refMethodParameters.add(parameterType);
            }
        }
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceDocBlockTag createDocBlockTag(SourceDocTagName name, SourceDocReference[] references, SourceDocDescription description) {
        if (name == null || references == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        DocBlockTagSym sym = (DocBlockTagSym)SymFactory.createDocElement(null, 82);
        sym.symFile = this.symFile;
        DocTagNameSym tagNameSym = (DocTagNameSym)name;
        SyntaxData data = new SyntaxData();
        data.addKid(tagNameSym);
        int referenceCount = references.length;
        for (int i = 0; i < referenceCount; ++i) {
            if (references[i] == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            data.addKid((Sym)((Object)references[i]));
        }
        if (description != null) {
            data.addKid((Sym)((Object)description));
        }
        sym.symData = data;
        sym.buildSelf();
        sym.tagCode = tagNameSym.tagCode;
        SymFactory.finishSym(sym);
        return sym;
    }

    @Override
    public SourceDocInlineTag createDocInlineTag(SourceDocTagName name, SourceDocReference[] references, SourceDocDescription description) {
        if (name == null || references == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        DocInlineTagSym sym = (DocInlineTagSym)SymFactory.createDocElement(null, 85);
        sym.symFile = this.symFile;
        DocTagNameSym tagNameSym = (DocTagNameSym)name;
        SyntaxData data = new SyntaxData();
        data.addKid(tagNameSym);
        int referenceCount = references.length;
        for (int i = 0; i < referenceCount; ++i) {
            if (references[i] == null) {
                throw new IllegalArgumentException(nullOrIllegalArgument);
            }
            data.addKid((Sym)((Object)references[i]));
        }
        if (description != null) {
            data.addKid((Sym)((Object)description));
        }
        sym.symData = data;
        sym.buildSelf();
        sym.tagCode = tagNameSym.tagCode;
        SymFactory.finishSym(sym);
        return sym;
    }

    private static void finishSym(Sym sym) {
        sym.symFormat = (char)(sym.symFormat | 2);
    }

    private static void finishSym(TreeSym sym) {
        sym.symFormat = (char)(sym.symFormat | 2);
        sym.hookupChildren();
        sym.setupSkeleton();
    }

    public SymFactory(SourceFile file) {
        this((FileSym)file);
    }

    public SymFactory(FileSym fileSym) {
        this.symFile = fileSym;
        if (fileSym == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
    }

    public static Sym createNode(FileSym fileSym, int sy) {
        Sym sym;
        if (fileSym == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        switch (sy) {
            case 89: {
                sym = new CommentSym();
                break;
            }
            case 90: {
                sym = new BlanklineSym();
                break;
            }
            case 91: {
                sym = new SqljSym();
                break;
            }
            case 20: {
                sym = new NameSym();
                break;
            }
            case 42: {
                sym = new VersionSym();
                break;
            }
            case 43: {
                sym = new ModifierSym();
                break;
            }
            case 27: {
                sym = new TypeSym();
                break;
            }
            case 44: {
                sym = new AssertStmt();
                break;
            }
            case 45: {
                sym = new BlockStmt();
                break;
            }
            case 46: {
                sym = new BreakStmt();
                break;
            }
            case 47: {
                sym = new CatchStmt();
                break;
            }
            case 48: {
                sym = new ContinueStmt();
                break;
            }
            case 49: {
                sym = new DoStmt();
                break;
            }
            case 50: {
                sym = new ElseStmt();
                break;
            }
            case 51: {
                sym = new EmptyStmt();
                break;
            }
            case 52: {
                sym = new ExpressionStmt();
                break;
            }
            case 53: {
                sym = new FinallyStmt();
                break;
            }
            case 54: {
                sym = new ForStmt();
                break;
            }
            case 55: {
                sym = new IfStmt();
                break;
            }
            case 56: {
                sym = new ReturnStmt();
                break;
            }
            case 57: {
                sym = new SwitchStmt();
                break;
            }
            case 58: {
                sym = new SynchStmt();
                break;
            }
            case 59: {
                sym = new ThrowStmt();
                break;
            }
            case 60: {
                sym = new TryStmt();
                break;
            }
            case 61: {
                sym = new WhileStmt();
                break;
            }
            case 2: {
                sym = new BlockSym();
                break;
            }
            case 16: {
                sym = new LabelSym();
                break;
            }
            case 23: {
                sym = new SwitchLabelSym();
                break;
            }
            case 18: {
                sym = new LocalVardeclSym();
                break;
            }
            case 13: {
                sym = new FormalParameterSym();
                break;
            }
            case 17: {
                sym = new LocalVariableSym();
                break;
            }
            case 28: {
                sym = new CatchParameterSym();
                break;
            }
            case 31: {
                sym = new LambdaParameterSym();
                break;
            }
            case 9: {
                sym = new FieldDeclSym();
                break;
            }
            case 10: {
                sym = new FieldSym();
                break;
            }
            case 6: 
            case 19: {
                sym = new MethodSym();
                break;
            }
            case 5: {
                sym = new InitializerSym();
                break;
            }
            case 7: {
                sym = new EnumConstantSym();
                break;
            }
            case 12: {
                sym = new FormalsSym();
                break;
            }
            case 3: {
                sym = new ClassSym();
                break;
            }
            case 4: {
                sym = new ClassBodySym();
                break;
            }
            case 1: {
                sym = new AnnotateSym();
                break;
            }
            case 83: {
                sym = new DocCommentSym();
                break;
            }
            case 22: {
                sym = new SuperclassSym();
                break;
            }
            case 15: {
                sym = new InterfacesSym();
                break;
            }
            case 24: {
                sym = new ThrowsClauseSym();
                break;
            }
            case 26: {
                sym = new TypeParameterSym();
                break;
            }
            case 25: {
                sym = new TypeArgumentSym();
                break;
            }
            case 29: {
                sym = new TypeArgumentListSym();
                break;
            }
            case 8: {
                sym = new ErrorSym();
                break;
            }
            case 14: {
                sym = new ImportSym();
                break;
            }
            case 21: {
                sym = new PackageSym();
                break;
            }
            case 92: {
                sym = new RootSym();
                break;
            }
            case 93: {
                sym = new TreeSym();
                break;
            }
            case 30: {
                sym = new TryResourcesListSym();
                break;
            }
            case 32: {
                sym = new ModuleSym();
                break;
            }
            case 33: {
                sym = new ModuleBodySym();
                break;
            }
            case 34: {
                sym = new ModuleRequiresSym();
                break;
            }
            case 35: {
                sym = new ModuleExportsSym();
                break;
            }
            case 36: {
                sym = new ModuleExportsToSym();
                break;
            }
            case 40: {
                sym = new ModuleOpensSym();
                break;
            }
            case 41: {
                sym = new ModuleOpensToSym();
                break;
            }
            case 37: {
                sym = new ModuleUsesSym();
                break;
            }
            case 38: {
                sym = new ModuleProvidesSym();
                break;
            }
            case 39: {
                sym = new ModuleProvidesWithSym();
                break;
            }
            default: {
                sym = new PlaceholderSym();
            }
        }
        sym.symKind = (byte)sy;
        sym.symFile = fileSym;
        return sym;
    }

    public static Expr createExpr(FileSym fileSym, byte opt) {
        if (fileSym == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        if (1 <= opt && opt < 62) {
            Expr sym;
            byte type = opt2srcTable[opt - 1];
            switch (type) {
                case 62: {
                    sym = new AnnotateExpr();
                    break;
                }
                case 63: {
                    sym = new ArrayAccessExpr();
                    break;
                }
                case 64: {
                    sym = new AssignExpr();
                    break;
                }
                case 65: {
                    sym = new DotExpr();
                    break;
                }
                case 66: {
                    sym = new InfixExpr();
                    break;
                }
                case 80: {
                    sym = new IntersectionTypeExpr();
                    break;
                }
                case 67: {
                    sym = new ListExpr();
                    break;
                }
                case 68: {
                    sym = new LiteralExpr();
                    break;
                }
                case 69: {
                    sym = new MethodCallExpr();
                    break;
                }
                case 70: {
                    sym = new ArrayCreatorExpr();
                    break;
                }
                case 71: {
                    sym = new ClassCreatorExpr();
                    break;
                }
                case 73: {
                    sym = new SimpleNameExpr();
                    break;
                }
                case 72: {
                    sym = new QuestionExpr();
                    break;
                }
                case 74: {
                    sym = new TypeExpr();
                    break;
                }
                case 75: {
                    sym = new TypecastExpr();
                    break;
                }
                case 76: {
                    sym = new UnaryExpr();
                    break;
                }
                case 77: {
                    sym = new WrapperExpr();
                    break;
                }
                case 78: {
                    sym = new MethodReferenceExpr();
                    break;
                }
                case 79: {
                    sym = new LambdaExpr();
                    break;
                }
                default: {
                    sym = null;
                }
            }
            if (sym != null) {
                sym.symKind = type;
                sym.symFile = fileSym;
                sym.exprOptcode = opt;
                return sym;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + opt);
    }

    public static DocSym createDocElement(DocCommentSym owningSym, int sy) {
        DocSym sym;
        switch (sy) {
            case 82: {
                sym = new DocBlockTagSym();
                break;
            }
            case 84: {
                sym = new DocDescriptionSym();
                break;
            }
            case 85: {
                sym = new DocInlineTagSym();
                break;
            }
            case 86: {
                sym = new DocReferenceSym();
                break;
            }
            case 88: {
                sym = new DocTextFragmentSym();
                break;
            }
            case 87: {
                sym = new DocTagNameSym();
                break;
            }
            default: {
                CommonUtilities.panic("" + sy);
                return null;
            }
        }
        sym.symKind = (byte)sy;
        sym.docOwning = owningSym;
        if (owningSym != null) {
            sym.symFile = owningSym.symFile;
        }
        return sym;
    }

    protected static void setupSynthetic(Sym sym, Sym parent, int index) {
        if (sym == null) {
            throw new IllegalArgumentException(nullOrIllegalArgument);
        }
        sym.symParent = parent;
        sym.symAccess = (char)(sym.symAccess | 0x1000);
        sym.symStart = index;
        sym.symEnd = index;
    }

    public static String describe(byte symKind) {
        if (0 < symKind && symKind < 92) {
            return SRC_words[symKind - 1];
        }
        if (92 <= symKind && symKind < 98) {
            return SRCX_words[symKind - 92];
        }
        return "SRC_invalid";
    }
}

