/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceModuleOpens;
import oracle.javatools.parser.java.v2.model.SourceModuleOpensTo;
import oracle.javatools.parser.java.v2.model.SourceName;

public class ModuleOpensSym
extends TreeSym
implements SourceModuleOpens {
    private char opensFlags;

    public boolean equals(Object o) {
        if (o instanceof ModuleOpensSym) {
            ModuleOpensSym other = (ModuleOpensSym)o;
            if (this.getName().equals(other.getName()) && this.hasSourceModuleOpensTo() == other.hasSourceModuleOpensTo()) {
                if (!this.hasSourceModuleOpensTo()) {
                    return true;
                }
                return this.getSourceModuleOpensTo().equals(other.getSourceModuleOpensTo());
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        hashCode = hashCode * 31 + this.opensFlags;
        if (this.hasSourceModuleOpensTo()) {
            hashCode = 31 * hashCode + this.getSourceModuleOpensTo().hashCode();
        }
        return hashCode;
    }

    @Override
    public int getElementKind() {
        return 18;
    }

    @Override
    public String getPackageName() {
        return this.getName();
    }

    @Override
    public void setPackageName(String packageName) {
        this.setName(packageName);
    }

    @Override
    public boolean hasSourceModuleOpensTo() {
        return this.getChild((byte)41) != null;
    }

    @Override
    public SourceModuleOpensTo getSourceModuleOpensTo() {
        return (SourceModuleOpensTo)((Object)this.getChildOrCreateSkeleton((byte)41));
    }

    @Override
    public Collection<String> getModuleNames() {
        if (this.hasSourceModuleOpensTo()) {
            List<SourceName> moduleNames = this.getSourceModuleOpensTo().getSourceModuleNames();
            ArrayList<String> names = new ArrayList<String>(moduleNames.size());
            for (SourceName moduleName : moduleNames) {
                names.add(moduleName.getName());
            }
            return names;
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        if (symKind == 20 || symKind == 41) {
            return true;
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 20: {
                return 0;
            }
            case 41: {
                return this.getChild((byte)20) != null ? 1 : 0;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        buffer.append(' ');
        buffer.append(this.getPackageName());
        Collection<String> moduleNames = this.getModuleNames();
        if (!moduleNames.isEmpty()) {
            buffer.append(" to ");
            boolean printComma = false;
            for (String moduleName : moduleNames) {
                if (printComma) {
                    buffer.append(",");
                } else {
                    printComma = true;
                }
                buffer.append(moduleName);
            }
        }
    }
}

