/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.BreakStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.DoStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.FinallyStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.IfStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.Stmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ThrowStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.TryStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.WhileStmt;
import oracle.javatools.parser.java.v2.model.FlowAnalysisListener;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceWrapperExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatementLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.util.Conversions;

public class FlowAnalysisErrors
implements FlowAnalysisListener {
    private int variableCount;
    private Map<Sym, Integer> variableToIndex = new HashMap<Sym, Integer>();
    private Stack<Context> contextStack = new Stack();
    private CompilerDriver compiler;
    private Map<SourceMethod, FixedBitSet> finishedConstructorAssigned = new HashMap<SourceMethod, FixedBitSet>();
    private BitSet definitelyAssignedFinals = new BitSet();
    private FixedBitSet assignedVariables = new FixedBitSet(0);
    private FixedBitSet multipleAssignedVariables = new FixedBitSet(0);
    private Stack<Set<JavaType>> thrownExceptionsStack = new Stack();
    private Set<JavaType> thrownExceptions;
    private Set<SourceElement> catchesThatCaughtExceptions;
    private Map<SourceElement, FixedBitSet> possiblyAssigneds;
    private Map<SourceElement, FixedBitSet> possiblyMultipleAssigneds;
    private Stack<Context> cachedContexts = new Stack();
    private Stack<ChildContext> cachedChildContexts = new Stack();
    private boolean isJdk8OrAbove;
    private boolean checkCorrectPopContext = System.getProperty("flow.analysis.context.check") != null;

    public FlowAnalysisErrors(CompilerDriver compiler) {
        this.compiler = compiler;
        this.isJdk8OrAbove = compiler.jdkVersion.isJdk8OrAbove();
    }

    @Override
    public void clear() {
        this.variableToIndex.clear();
        this.contextStack.clear();
        this.compiler = null;
        this.finishedConstructorAssigned.clear();
        if (this.thrownExceptions != null) {
            this.thrownExceptions.clear();
        }
        if (this.catchesThatCaughtExceptions != null) {
            this.catchesThatCaughtExceptions.clear();
        }
        if (this.possiblyAssigneds != null) {
            this.possiblyAssigneds.clear();
        }
        if (this.possiblyMultipleAssigneds != null) {
            this.possiblyMultipleAssigneds.clear();
        }
        this.cachedContexts.clear();
        this.cachedChildContexts.clear();
    }

    private void addPossiblyAssigned(SourceElement sourceElement, FixedBitSet assigned) {
        FixedBitSet possiblyAssigned;
        if (this.possiblyAssigneds == null) {
            this.possiblyAssigneds = new HashMap<SourceElement, FixedBitSet>();
        }
        if ((possiblyAssigned = this.possiblyAssigneds.get(sourceElement)) == null) {
            this.possiblyAssigneds.put(sourceElement, new FixedBitSet(assigned));
        } else {
            possiblyAssigned.or(assigned);
        }
    }

    private void addPossiblyMultipleAssigned(SourceElement sourceElement, FixedBitSet multipleAssigned) {
        FixedBitSet possiblyMultipleAssigned;
        if (this.possiblyMultipleAssigneds == null) {
            this.possiblyMultipleAssigneds = new HashMap<SourceElement, FixedBitSet>();
        }
        if ((possiblyMultipleAssigned = this.possiblyMultipleAssigneds.get(sourceElement)) == null) {
            this.possiblyMultipleAssigneds.put(sourceElement, new FixedBitSet(multipleAssigned));
        } else {
            possiblyMultipleAssigned.or(multipleAssigned);
        }
    }

    private void addCatchThatCaughtExceptions(SourceElement sourceElement) {
        if (this.catchesThatCaughtExceptions == null) {
            this.catchesThatCaughtExceptions = new HashSet<SourceElement>();
        }
        this.catchesThatCaughtExceptions.add(sourceElement);
    }

    private void addThrownException(JavaType exception) {
        if (this.thrownExceptions == null) {
            this.thrownExceptions = new HashSet<JavaType>();
        }
        this.thrownExceptions.add(exception);
    }

    @Override
    public boolean startClass(SourceClass sym) {
        Collection<SourceFieldVariable> fieldVariables = sym.getSourceFieldVariables();
        for (SourceFieldVariable fieldVariable : fieldVariables) {
            if (!fieldVariable.isFinal()) continue;
            this.variableToIndex.put((Sym)((Object)fieldVariable), this.variableCount);
            ++this.variableCount;
        }
        this.pushContext(ContextKind.CLASS, (Sym)((Object)sym));
        return true;
    }

    @Override
    public boolean endClass(SourceClass sym) {
        Collection<SourceFieldVariable> fieldVariables = sym.getSourceFieldVariables();
        for (SourceFieldVariable fieldVariable : fieldVariables) {
            Integer index;
            if (!fieldVariable.isFinal() || (index = this.variableToIndex.remove(fieldVariable)) == null) continue;
            this.definitelyAssignedFinals.clear(index);
            --this.variableCount;
        }
        return this.popContext(ContextKind.CLASS) != null;
    }

    @Override
    public boolean startStaticInitializers(SourceClass sym) {
        return true;
    }

    @Override
    public boolean endStaticInitializers(SourceClass sym) {
        Collection<SourceFieldVariable> fieldVariables = sym.getSourceFieldVariables();
        for (SourceFieldVariable fieldVariable : fieldVariables) {
            Integer index;
            if (!fieldVariable.isFinal() || !fieldVariable.isStatic() || (index = this.variableToIndex.get(fieldVariable)) == null) continue;
            if (!this.assignedVariables.get(index)) {
                this.compiler.error((Sym)((Object)fieldVariable), (short)90, fieldVariable.getName());
            }
            this.assignedVariables.set(index);
            this.definitelyAssignedFinals.set(index);
        }
        return true;
    }

    @Override
    public boolean startInitializer(SourceClassInitializer initializer) {
        this.pushContext(ContextKind.INITIALIZER, (Sym)((Object)initializer));
        return true;
    }

    @Override
    public boolean endInitializer(SourceClassInitializer initializer) {
        return this.popContext(ContextKind.INITIALIZER) != null;
    }

    @Override
    public boolean startConstructors(SourceClass sym) {
        this.pushContext(ContextKind.CONSTRUCTORS, (Sym)((Object)sym));
        return true;
    }

    @Override
    public boolean endConstructors(SourceClass sym) {
        boolean noConstructors = sym.getSourceConstructors().isEmpty();
        Collection<SourceFieldVariable> fieldVariables = sym.getSourceFieldVariables();
        for (SourceFieldVariable fieldVariable : fieldVariables) {
            Integer index;
            if (!fieldVariable.isFinal() || fieldVariable.isStatic() || (index = this.variableToIndex.get(fieldVariable)) == null) continue;
            if (noConstructors && !this.assignedVariables.get(index)) {
                this.compiler.error((Sym)((Object)fieldVariable), (short)90, fieldVariable.getName());
            }
            this.assignedVariables.set(index);
            this.definitelyAssignedFinals.set(index);
        }
        Set<Map.Entry<SourceMethod, FixedBitSet>> entrySet = this.finishedConstructorAssigned.entrySet();
        Iterator<Map.Entry<SourceMethod, FixedBitSet>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<SourceMethod, FixedBitSet> entry = iterator.next();
            if (entry.getKey().getOwningClass() != sym) continue;
            iterator.remove();
        }
        return this.popContext(ContextKind.CONSTRUCTORS) != null;
    }

    @Override
    public boolean startFieldDeclaration(SourceFieldDeclaration sym) {
        List<SourceVariable> list = sym.getVariables();
        for (SourceVariable var : list) {
            if (var.isFinal()) continue;
            this.variableToIndex.put((Sym)((Object)var), this.variableCount);
            ++this.variableCount;
        }
        this.pushContext(ContextKind.FIELD_DECLARATION, (Sym)((Object)sym));
        return true;
    }

    @Override
    public boolean endFieldDeclaration(SourceFieldDeclaration sym) {
        List<SourceVariable> list = sym.getVariables();
        for (SourceVariable var : list) {
            if (var.isFinal() || this.variableToIndex.remove(var) == null) continue;
            ++this.variableCount;
        }
        return this.popContext(ContextKind.FIELD_DECLARATION) != null;
    }

    @Override
    public boolean startMethod(SourceMethod sym) {
        List<SourceVariable> parameters = sym.getSourceParameters();
        for (SourceVariable parameter : parameters) {
            this.variableToIndex.put((Sym)((Object)parameter), this.variableCount);
            ++this.variableCount;
        }
        Context analysisContext = sym.isConstructor() ? this.pushContext(ContextKind.CONSTRUCTOR, (Sym)((Object)sym)) : this.pushContext(ContextKind.METHOD, (Sym)((Object)sym));
        analysisContext.canReachNext = true;
        for (SourceVariable parameter : parameters) {
            this.assignParameter(parameter);
        }
        this.thrownExceptionsStack.push(this.thrownExceptions);
        this.thrownExceptions = null;
        return true;
    }

    @Override
    public boolean endMethod(SourceMethod sym) {
        if (this.thrownExceptionsStack.isEmpty()) {
            return false;
        }
        this.thrownExceptions = this.thrownExceptionsStack.pop();
        if (!this.checkForMissingReturn((MethodSym)sym)) {
            return false;
        }
        List<SourceVariable> parameters = sym.getSourceParameters();
        for (SourceVariable parameter : parameters) {
            Integer index = this.variableToIndex.remove(parameter);
            if (index == null) continue;
            this.definitelyAssignedFinals.clear(index);
            --this.variableCount;
        }
        this.assignedVariables.resize(this.variableCount);
        this.multipleAssignedVariables.resize(this.variableCount);
        if (sym.isConstructor()) {
            ClassSym classSym;
            FixedBitSet constructorAssignedVariables = new FixedBitSet(this.assignedVariables);
            this.finishedConstructorAssigned.put(sym, constructorAssignedVariables);
            Context context = this.popContext(ContextKind.CONSTRUCTOR);
            if (context == null) {
                return false;
            }
            if (context.canReachNext && (classSym = ((Sym)((Object)sym)).getOwningClassSym()) != null) {
                Collection<SourceFieldVariable> fieldVariables = classSym.getSourceFieldVariables();
                for (SourceFieldVariable fieldVariable : fieldVariables) {
                    Integer index;
                    if (!fieldVariable.isFinal() || fieldVariable.isStatic() || (index = this.variableToIndex.get(fieldVariable)) == null || constructorAssignedVariables.get(index)) continue;
                    this.compiler.error((Sym)((Object)sym), (short)90, fieldVariable.getName());
                }
            }
        } else if (this.popContext(ContextKind.METHOD) == null) {
            return false;
        }
        return true;
    }

    @Override
    public boolean startLambdaExpression(SourceLambdaExpression sym) {
        List<SourceLambdaParameter> parameters = sym.getFormalParameters();
        for (SourceLambdaParameter parameter : parameters) {
            this.variableToIndex.put((Sym)((Object)parameter), this.variableCount);
            ++this.variableCount;
        }
        Context analysisContext = this.pushContext(ContextKind.LAMBDA_EXPRESSION, (Sym)((Object)sym));
        analysisContext.canReachNext = true;
        for (SourceLambdaParameter parameter : parameters) {
            this.assignParameter(parameter);
        }
        this.thrownExceptionsStack.push(this.thrownExceptions);
        this.thrownExceptions = null;
        return true;
    }

    @Override
    public boolean endLambdaExpression(SourceLambdaExpression sym) {
        if (this.thrownExceptionsStack.isEmpty()) {
            return false;
        }
        this.thrownExceptions = this.thrownExceptionsStack.pop();
        if (!this.checkForMissingReturn((Sym)((Object)sym))) {
            return false;
        }
        List<SourceLambdaParameter> parameters = sym.getFormalParameters();
        for (SourceLambdaParameter parameter : parameters) {
            Integer index = this.variableToIndex.remove(parameter);
            if (index == null) continue;
            this.definitelyAssignedFinals.clear(index);
            --this.variableCount;
        }
        return this.popContext(ContextKind.LAMBDA_EXPRESSION) != null;
    }

    private boolean checkForMissingReturn(Sym sym) {
        switch (sym.symKind) {
            case 6: {
                return true;
            }
            case 19: {
                if (sym.isAbstract() || sym.isNative()) {
                    return true;
                }
                if (!this.isVoidType(((SourceMethod)((Object)sym)).getSourceReturnType())) break;
                return true;
            }
            case 79: {
                SourceLambdaExpression lambda = (SourceLambdaExpression)((Object)sym);
                JavaType lambdaResolvedType = lambda.getResolvedType();
                if (lambdaResolvedType == null || CompilerUtilities.isVoidType(lambdaResolvedType)) {
                    return true;
                }
                SourceElement body = lambda.getBody();
                if (body != null && body.getSymbolKind() == 2) break;
                return true;
            }
        }
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        if (context.canReachNext) {
            this.compiler.error(sym, (short)87);
        }
        return true;
    }

    private boolean isVoidType(SourceTypeReference type) {
        return type != null && type.isPrimitive() && "void".equals(type.getName());
    }

    @Override
    public boolean startBlock(SourceBlock sym) {
        Collection<SourceLocalVariable> localVariables = sym.getLocalVariables();
        for (SourceLocalVariable local : localVariables) {
            this.variableToIndex.put((Sym)((Object)local), this.variableCount);
            ++this.variableCount;
        }
        this.pushContext(ContextKind.BLOCK, (Sym)((Object)sym));
        return true;
    }

    @Override
    public boolean endBlock(SourceBlock sym) {
        if (this.contextStack.isEmpty()) {
            return false;
        }
        if (this.contextStack.peek().kind == ContextKind.CASE_BODY && this.popContext(ContextKind.CASE_BODY) == null) {
            return false;
        }
        Collection<SourceLocalVariable> localVariables = sym.getLocalVariables();
        for (SourceLocalVariable local : localVariables) {
            Integer index = this.variableToIndex.remove(local);
            if (index == null) continue;
            this.definitelyAssignedFinals.clear(index);
            --this.variableCount;
        }
        return this.popContext(ContextKind.BLOCK) != null;
    }

    @Override
    public boolean declareLocalVariable(SourceLocalVariable sym, SourceExpression initializer) {
        JavaMethod javaMethod;
        JavaType resolvedType;
        SourceElement grandParent;
        this.declareVariable(sym, initializer);
        SourceElement parent = sym.getParent();
        SourceElement sourceElement = grandParent = parent != null ? parent.getParent() : null;
        if (grandParent != null && grandParent.getSymbolKind() == 30 && (resolvedType = sym.getResolvedType()) != null && (javaMethod = resolvedType.getMethod("close", null)) != null) {
            Collection<JavaType> exceptions = javaMethod.getExceptions();
            for (JavaType exception : exceptions) {
                this.addThrownException(exception);
            }
        }
        return true;
    }

    @Override
    public boolean declareField(SourceFieldVariable sym, SourceExpression initializer) {
        this.declareVariable(sym, initializer);
        return true;
    }

    private void declareVariable(SourceVariable sym, SourceExpression initializer) {
        Integer index = this.variableToIndex.get(sym);
        if (index != null && initializer != null) {
            this.assignedVariables.set(index);
        }
    }

    @Override
    public boolean switchLabel(SourceSwitchLabel sym) {
        ChildContext childContext;
        boolean isDefault;
        boolean bl = isDefault = sym.getExpression() == null;
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        if (context.kind == ContextKind.CASE_BODY) {
            childContext = (ChildContext)context;
            if (childContext.canReachNext) {
                int symbolKind;
                childContext.isDefaultCase |= isDefault;
                SourceElement before = sym.getSiblingBefore();
                if (before != null && (symbolKind = before.getSymbolKind()) != 46 && symbolKind != 23) {
                    this.compiler.error((Sym)((Object)sym), (short)118);
                }
                return true;
            }
            if (this.popContext(ContextKind.CASE_BODY) == null) {
                return false;
            }
        }
        childContext = (ChildContext)this.pushContext(ContextKind.CASE_BODY, (Sym)((Object)sym));
        childContext.isDefaultCase = isDefault;
        return true;
    }

    @Override
    public boolean statementLabel(SourceStatementLabel sym) {
        return true;
    }

    @Override
    public boolean localVariableUsed(SourceLocalVariable local, SourceSimpleNameExpression context) {
        return this.sourceVariableUsed(local, context);
    }

    private boolean sourceVariableUsed(SourceVariable variable, SourceExpression context) {
        SourceElement parent = context.getParent();
        if (parent != null) {
            Expr expr;
            if (InternalUtilities.srcIsExpr(parent.getSymbolKind())) {
                expr = (Expr)parent;
                switch (expr.exprOptcode) {
                    case 6: {
                        if (context != ((SourceExpression)parent).getFirstOperand()) break;
                        return this.assignVariable(variable, context);
                    }
                }
            }
            if (!this.useVariable(variable, context)) {
                return false;
            }
            if (InternalUtilities.srcIsExpr(parent.getSymbolKind())) {
                expr = (Expr)parent;
                switch (expr.exprOptcode) {
                    case 2: 
                    case 8: 
                    case 11: 
                    case 13: 
                    case 18: 
                    case 29: 
                    case 32: 
                    case 34: 
                    case 36: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 52: 
                    case 57: {
                        if (context != ((SourceExpression)parent).getFirstOperand() || this.assignVariable(variable, context)) break;
                        return false;
                    }
                }
            }
        } else if (!this.useVariable(variable, context)) {
            return false;
        }
        return true;
    }

    @Override
    public boolean fieldUsed(SourceFieldVariable field, SourceExpression context) {
        return this.sourceVariableUsed(field, context);
    }

    @Override
    public boolean parameterUsed(SourceFormalParameter parameter, SourceSimpleNameExpression context) {
        return this.sourceVariableUsed(parameter, context);
    }

    @Override
    public boolean catchParameterUsed(SourceCatchParameter parameter, SourceSimpleNameExpression context) {
        return this.sourceVariableUsed(parameter, context);
    }

    @Override
    public boolean lambdaParameterUsed(SourceLambdaParameter parameter, SourceSimpleNameExpression context) {
        return this.sourceVariableUsed(parameter, context);
    }

    @Override
    public boolean methodCalled(SourceMethodCallExpression methodCall) {
        JavaMethod javaMethod = methodCall.getResolvedMethod();
        if (javaMethod != null) {
            String name = methodCall.getName();
            if ("this".equals(name)) {
                FixedBitSet assigned;
                SourceMethod sourceMethod;
                if (javaMethod.isConstructor() && (sourceMethod = javaMethod.getSourceElement()) != null && (assigned = this.finishedConstructorAssigned.get(sourceMethod)) != null) {
                    this.assignedVariables.or(assigned);
                }
                this.checkThisOrSuperIsFirstStatement(methodCall, (short)96);
            } else if ("super".equals(name)) {
                this.checkThisOrSuperIsFirstStatement(methodCall, (short)95);
            }
            Collection<JavaType> exceptions = javaMethod.getExceptions();
            for (JavaType exception : exceptions) {
                if (exception == null) continue;
                this.addThrownException(exception);
            }
        }
        return true;
    }

    @Override
    public boolean newClassCreation(SourceNewClassExpression newClassExpr) {
        JavaMethod javaMethod = newClassExpr.getResolvedMethod();
        if (javaMethod != null) {
            Collection<JavaType> exceptions = javaMethod.getExceptions();
            for (JavaType exception : exceptions) {
                if (exception == null) continue;
                this.addThrownException(exception);
            }
        }
        return true;
    }

    private void checkThisOrSuperIsFirstStatement(SourceMethodCallExpression methodCall, short errorCode) {
        boolean error = false;
        SourceElement parent = methodCall.getParent();
        if (parent == null || parent.getSymbolKind() != 52 || parent.getSiblingBefore() != null) {
            error = true;
        } else {
            SourceElement grandParent = parent.getParent();
            if (grandParent == null || grandParent.getSymbolKind() != 2) {
                error = true;
            } else {
                SourceElement greatGrandParent = grandParent.getParent();
                if (greatGrandParent == null || greatGrandParent.getSymbolKind() != 6) {
                    error = true;
                }
            }
        }
        if (error) {
            this.compiler.error((Sym)((Object)methodCall), errorCode);
        }
    }

    @Override
    public boolean startIfCondition(SourceWrapperExpression condition) {
        return true;
    }

    @Override
    public boolean endIfCondition(SourceWrapperExpression condition) {
        this.pushContext(ContextKind.IF_BODY, (Sym)((Object)condition));
        return true;
    }

    @Override
    public boolean startWhileCondition(SourceWrapperExpression condition) {
        return true;
    }

    @Override
    public boolean endWhileCondition(SourceWrapperExpression condition) {
        return true;
    }

    @Override
    public boolean startDoCondition(SourceWrapperExpression condition) {
        return true;
    }

    @Override
    public boolean endDoCondition(SourceWrapperExpression condition) {
        return true;
    }

    @Override
    public boolean startSwitchCondition(SourceWrapperExpression condition) {
        return true;
    }

    @Override
    public boolean endSwitchCondition(SourceWrapperExpression condition) {
        return true;
    }

    @Override
    public boolean startSynchronizedExpression(SourceWrapperExpression expression) {
        return true;
    }

    @Override
    public boolean endSynchronizedExpression(SourceWrapperExpression expression) {
        return true;
    }

    @Override
    public boolean startStatement(SourceStatement statement) {
        SourceElement parent = statement.getParent();
        if (parent != null) {
            Object constantValue;
            SourceExpression conditionalExpr = null;
            switch (parent.getSymbolKind()) {
                case 61: {
                    conditionalExpr = ((WhileStmt)parent).getExpression();
                    break;
                }
                case 54: {
                    ForStmt forStmt = (ForStmt)parent;
                    if (forStmt.getForType() == 2) break;
                    conditionalExpr = forStmt.getForConditional();
                    break;
                }
            }
            if (conditionalExpr != null && (constantValue = conditionalExpr.getConstantValue()) instanceof Boolean && !((Boolean)constantValue).booleanValue()) {
                this.compiler.error((Sym)((Object)statement), (short)92);
            }
        }
        switch (statement.getSymbolKind()) {
            case 45: {
                this.pushContext(ContextKind.BLOCK_STATEMENT, (Sym)((Object)statement));
                break;
            }
            case 47: {
                if (this.startCatchStatement((CatchStmt)statement)) break;
                return false;
            }
            case 49: {
                this.pushContext(ContextKind.DO, (Sym)((Object)statement));
                break;
            }
            case 50: {
                if (this.contextStack.isEmpty()) {
                    return false;
                }
                if (this.contextStack.peek().kind == ContextKind.IF_BODY && this.popContext(ContextKind.IF_BODY) == null) {
                    return false;
                }
                this.pushContext(ContextKind.ELSE, (Sym)((Object)statement));
                break;
            }
            case 53: {
                if (!this.popTryBody()) {
                    return false;
                }
                this.pushContext(ContextKind.FINALLY, (Sym)((Object)statement));
                break;
            }
            case 54: {
                this.pushContext(ContextKind.FOR, (Sym)((Object)statement));
                break;
            }
            case 55: {
                this.pushContext(ContextKind.IF, (Sym)((Object)statement));
                break;
            }
            case 57: {
                this.pushContext(ContextKind.SWITCH, (Sym)((Object)statement));
                break;
            }
            case 60: {
                JavaClass ioexception;
                this.pushContext(ContextKind.TRY, (Sym)((Object)statement));
                this.pushContext(ContextKind.TRY_BODY, (Sym)((Object)statement));
                this.thrownExceptionsStack.push(this.thrownExceptions);
                this.thrownExceptions = null;
                TryStmt tryStatement = (TryStmt)statement;
                if (!tryStatement.hasTryResourcesElements() || tryStatement.getTryResourcesElements().isEmpty()) break;
                JavaClass javaClass = ioexception = this.compiler.getProvider() != null ? this.compiler.getProvider().getClass("java.io.IOException") : null;
                if (ioexception == null) break;
                this.addThrownException(ioexception);
                break;
            }
            case 61: {
                this.pushContext(ContextKind.WHILE, (Sym)((Object)statement));
                break;
            }
            case 58: {
                this.pushContext(ContextKind.SYNCHRONIZED, (Sym)((Object)statement));
            }
        }
        return this.checkUnreachableStatement(statement);
    }

    private boolean checkUnreachableStatement(SourceStatement statement) {
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        if (!context.relaxedCanReachNext) {
            this.compiler.error((Sym)((Object)statement), (short)92);
            context.relaxedCanReachNext = true;
        }
        return true;
    }

    private boolean startCatchStatement(CatchStmt catchStatement) {
        if (!this.popTryBody()) {
            return false;
        }
        SourceVariable catchVariable = catchStatement.getCatchVariable();
        if (catchVariable != null) {
            this.variableToIndex.put((Sym)((Object)catchVariable), this.variableCount);
            ++this.variableCount;
        }
        this.pushContext(ContextKind.CATCH, catchStatement);
        if (catchVariable != null) {
            this.assignParameter(catchVariable);
        }
        return true;
    }

    private boolean popTryBody() {
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context analysisContext = this.contextStack.peek();
        if (analysisContext.kind == ContextKind.TRY_BODY) {
            if (this.popContext(ContextKind.TRY_BODY) == null) {
                return false;
            }
            if (this.contextStack.isEmpty()) {
                return false;
            }
            analysisContext = this.contextStack.peek();
            if (analysisContext.kind != ContextKind.TRY) {
                return false;
            }
            this.removeCaughtExceptions(analysisContext);
            if (this.thrownExceptionsStack.isEmpty()) {
                return false;
            }
            Set<JavaType> previousThrownExceptions = this.thrownExceptionsStack.pop();
            if (previousThrownExceptions != null) {
                if (this.thrownExceptions != null) {
                    this.thrownExceptions.addAll(previousThrownExceptions);
                } else {
                    this.thrownExceptions = previousThrownExceptions;
                }
            }
        }
        return true;
    }

    @Override
    public boolean endStatement(SourceStatement statement) {
        if (!this.checkStatementReachableBreak()) {
            return false;
        }
        switch (statement.getSymbolKind()) {
            case 45: {
                if (this.popContext(ContextKind.BLOCK_STATEMENT) != null) break;
                return false;
            }
            case 46: {
                if (this.endBreakContinueStatement((BreakStmt)statement)) break;
                return false;
            }
            case 47: {
                if (this.endCatchStatement((CatchStmt)statement)) break;
                return false;
            }
            case 48: {
                if (this.endBreakContinueStatement((Stmt)statement)) break;
                return false;
            }
            case 49: {
                if (this.endDoStatement((DoStmt)statement)) break;
                return false;
            }
            case 50: {
                if (this.popContext(ContextKind.ELSE) != null) break;
                return false;
            }
            case 53: {
                if (this.endFinallyStatement((FinallyStmt)statement)) break;
                return false;
            }
            case 54: {
                if (this.endForStatement((ForStmt)statement)) break;
                return false;
            }
            case 55: {
                if (this.endIfStatement((IfStmt)statement)) break;
                return false;
            }
            case 56: {
                if (this.endReturnStatement()) break;
                return false;
            }
            case 57: {
                if (this.popContext(ContextKind.SWITCH) != null) break;
                return false;
            }
            case 59: {
                if (this.endThrowStatement((ThrowStmt)statement)) break;
                return false;
            }
            case 60: {
                if (this.endTryStatement()) break;
                return false;
            }
            case 61: {
                if (this.endWhileStatement((WhileStmt)statement)) break;
                return false;
            }
            case 58: {
                if (this.popContext(ContextKind.SYNCHRONIZED) != null) break;
                return false;
            }
        }
        return true;
    }

    private boolean checkStatementReachableBreak() {
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        if (context.hasReachableBreak) {
            FixedBitSet possiblyMultipleAssigned;
            FixedBitSet possiblyAssigned;
            if (!context.canReachNext && this.possiblyAssigneds != null && (possiblyAssigned = this.possiblyAssigneds.remove(context.sym)) != null) {
                this.assignedVariables.or(possiblyAssigned);
            }
            if (!context.canReachNext && this.possiblyMultipleAssigneds != null && (possiblyMultipleAssigned = this.possiblyMultipleAssigneds.remove(context.sym)) != null) {
                this.multipleAssignedVariables.or(possiblyMultipleAssigned);
            }
            context.canReachNext = true;
            context.relaxedCanReachNext = true;
        }
        return true;
    }

    private boolean endReturnStatement() {
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        if (context.canReachNext) {
            context.canReachNext = false;
            context.relaxedCanReachNext = false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean endBreakContinueStatement(Stmt statement) {
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context currentContext = this.contextStack.peek();
        if (currentContext.canReachNext || currentContext.relaxedCanReachNext) {
            String targetLabel = null;
            Sym target = statement.getChild((byte)20);
            if (target != null) {
                targetLabel = ((NameSym)target).getName();
            }
            Context targetContext = null;
            if (targetLabel != null) {
                block5: for (int contextIndex = this.contextStack.size() - 1; contextIndex >= 0; --contextIndex) {
                    Context context = (Context)this.contextStack.get(contextIndex);
                    if (context.sym == null || !InternalUtilities.srcIsStmt(context.sym.symKind)) continue;
                    List<SourceStatementLabel> labels = ((SourceStatement)((Object)context.sym)).getStatementLabels();
                    for (SourceStatementLabel label : labels) {
                        if (!targetLabel.equals(label.getName())) continue;
                        targetContext = context;
                        break block5;
                    }
                }
            }
            if (targetContext == null) {
                block7: for (int x = contextIndex; x >= 0; --x) {
                    switch (((Context)this.contextStack.get((int)x)).kind) {
                        case SWITCH: {
                            if (statement.symKind == 48) break;
                        }
                        case DO: 
                        case FOR: 
                        case WHILE: {
                            targetContext = (Context)this.contextStack.get(x);
                            break block7;
                        }
                        case CASE_BODY: {
                            if (statement.symKind == 48) break;
                            Context caseContext = (Context)this.contextStack.get(x);
                            if (currentContext.canReachNext) {
                                caseContext.hasReachableBreak = true;
                            }
                            if (currentContext.relaxedCanReachNext) {
                                caseContext.hasRelaxedReachableBreak = true;
                            }
                            this.addPossiblyAssigned(caseContext.sym, this.assignedVariables);
                            this.addPossiblyMultipleAssigned(caseContext.sym, this.multipleAssignedVariables);
                        }
                    }
                }
            }
            if (targetContext != null) {
                if (statement.symKind != 48) {
                    targetContext.hasReachableBreak = true;
                    targetContext.hasRelaxedReachableBreak = true;
                }
                this.addPossiblyAssigned(targetContext.sym, this.assignedVariables);
                this.addPossiblyMultipleAssigned(targetContext.sym, this.multipleAssignedVariables);
            }
        }
        currentContext.canReachNext = false;
        currentContext.relaxedCanReachNext = false;
        return true;
    }

    private boolean endCatchStatement(CatchStmt catchStatement) {
        Context context;
        Integer index;
        SourceVariable catchVariable = catchStatement.getCatchVariable();
        if (catchVariable != null && (index = this.variableToIndex.remove(catchVariable)) != null) {
            this.definitelyAssignedFinals.clear(index);
            --this.variableCount;
        }
        if ((context = this.popContext(ContextKind.CATCH)) == null) {
            return false;
        }
        SourceCatchParameter parameter = (SourceCatchParameter)catchStatement.getCatchVariable();
        if (parameter != null) {
            List<SourceTypeReference> list = parameter.getSourceTypes();
            for (SourceTypeReference type : list) {
                JavaType javaType = type.getResolvedType();
                if (javaType == null) continue;
                if (this.compiler.isUncheckedException(javaType)) {
                    this.addCatchThatCaughtExceptions(context.sym);
                    continue;
                }
                String name = javaType.getRawName();
                if (!"java.lang.Exception".equals(name) && !"java.lang.Throwable".equals(name)) continue;
                this.addCatchThatCaughtExceptions(context.sym);
            }
        }
        return true;
    }

    private boolean endFinallyStatement(FinallyStmt finallyStatement) {
        Context context = this.popContext(ContextKind.FINALLY);
        if (context == null) {
            return false;
        }
        if (!context.canReachNext) {
            this.compiler.error(finallyStatement, (short)88);
        }
        return true;
    }

    private boolean endThrowStatement(ThrowStmt throwStatement) {
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        if (context.canReachNext) {
            JavaType type;
            context.canReachNext = false;
            context.relaxedCanReachNext = false;
            Expr e = throwStatement.getExpressionSym();
            if (e != null && (type = e.getResolvedType()) != null) {
                this.addThrownException(type);
                block0: for (int x = this.contextStack.size() - 1; x >= 0; --x) {
                    Context tryContext = (Context)this.contextStack.get(x);
                    if (tryContext.kind != ContextKind.TRY) continue;
                    TryStmt tryStmt = (TryStmt)tryContext.sym;
                    List<JavaType> caughtExceptions = tryStmt.getCaughtExceptions();
                    for (JavaType caughtException : caughtExceptions) {
                        if (!Conversions.isSubtypeOf(type, caughtException)) continue;
                        this.addPossiblyAssigned(tryContext.sym, this.assignedVariables);
                        this.addPossiblyMultipleAssigned(tryContext.sym, this.multipleAssignedVariables);
                        break block0;
                    }
                }
            }
        }
        return true;
    }

    private boolean endIfStatement(IfStmt ifStatement) {
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        if (context.kind == ContextKind.IF_BODY) {
            if (this.popContext(ContextKind.IF_BODY) == null) {
                return false;
            }
            if (this.contextStack.isEmpty()) {
                return false;
            }
            context = this.contextStack.peek();
        }
        boolean ifCanReachNext = true;
        boolean ifRelaxedCanReachNext = true;
        boolean elseCanReachNext = true;
        boolean elseRelaxedCanReachNext = true;
        FixedBitSet ifAssignedVariables = null;
        FixedBitSet elseAssignedVariables = null;
        FixedBitSet ifMultipleAssignedVariables = null;
        FixedBitSet elseMultipleAssignedVariables = null;
        if (context.childContexts != null) {
            ChildContext childContext;
            if (context.childContexts.size() > 0) {
                childContext = context.childContexts.get(0);
                ifCanReachNext = childContext.canReachNext;
                ifRelaxedCanReachNext = childContext.relaxedCanReachNext;
                ifAssignedVariables = childContext.assignedVariables;
                ifMultipleAssignedVariables = childContext.multipleAssignedVariables;
            }
            if (context.childContexts.size() > 1) {
                childContext = context.childContexts.get(1);
                elseCanReachNext = childContext.canReachNext;
                elseRelaxedCanReachNext = childContext.relaxedCanReachNext;
                elseAssignedVariables = childContext.assignedVariables;
                elseMultipleAssignedVariables = childContext.multipleAssignedVariables;
            }
        }
        Boolean strictCanReachNext = null;
        Boolean constantValue = this.getConstantValue(ifStatement);
        if (constantValue != null) {
            if (constantValue.booleanValue()) {
                strictCanReachNext = ifCanReachNext;
                if (ifCanReachNext) {
                    if (ifAssignedVariables != null) {
                        this.assignedVariables.or(ifAssignedVariables);
                    }
                    if (ifMultipleAssignedVariables != null) {
                        this.multipleAssignedVariables.or(ifMultipleAssignedVariables);
                    }
                }
            } else {
                strictCanReachNext = elseCanReachNext;
                if (elseCanReachNext) {
                    if (elseAssignedVariables != null) {
                        this.assignedVariables.or(elseAssignedVariables);
                    }
                    if (elseMultipleAssignedVariables != null) {
                        this.multipleAssignedVariables.or(elseMultipleAssignedVariables);
                    }
                }
            }
        } else if (ifAssignedVariables != null && elseAssignedVariables != null) {
            FixedBitSet multipleAssignedIntersection;
            FixedBitSet assignedIntersection = ifCanReachNext ? ifAssignedVariables : null;
            FixedBitSet fixedBitSet = multipleAssignedIntersection = ifCanReachNext ? ifMultipleAssignedVariables : null;
            if (elseCanReachNext) {
                if (assignedIntersection == null) {
                    assignedIntersection = elseAssignedVariables;
                } else {
                    assignedIntersection.and(elseAssignedVariables);
                }
                if (multipleAssignedIntersection == null) {
                    multipleAssignedIntersection = elseMultipleAssignedVariables;
                } else {
                    multipleAssignedIntersection.and(elseMultipleAssignedVariables);
                }
            }
            if (assignedIntersection != null) {
                this.assignedVariables.or(assignedIntersection);
            }
            if (multipleAssignedIntersection != null) {
                this.multipleAssignedVariables.or(multipleAssignedIntersection);
            }
        }
        if (strictCanReachNext == null) {
            strictCanReachNext = ifCanReachNext || elseCanReachNext;
        }
        context.canReachNext = strictCanReachNext;
        context.relaxedCanReachNext = ifRelaxedCanReachNext || elseRelaxedCanReachNext;
        return this.popContext(ContextKind.IF) != null;
    }

    private Boolean getConstantValue(Stmt statement) {
        Object constantValue;
        SourceExpression controlExpression = statement.getControlExpression();
        if (controlExpression != null && (constantValue = controlExpression.getConstantValue()) instanceof Boolean) {
            return (Boolean)constantValue;
        }
        return null;
    }

    private boolean endWhileStatement(WhileStmt whileStatement) {
        Object constantValue;
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        boolean forEver = false;
        Boolean canReachNextStatement = null;
        SourceExpression controlExpression = whileStatement.getControlExpression();
        if (controlExpression != null && (constantValue = controlExpression.getConstantValue()) instanceof Boolean) {
            forEver = (Boolean)constantValue;
        }
        if (forEver) {
            canReachNextStatement = context.hasReachableBreak;
            if (canReachNextStatement.booleanValue()) {
                FixedBitSet possiblyMultipleAssigned;
                FixedBitSet possiblyAssigned;
                FixedBitSet fixedBitSet = possiblyAssigned = this.possiblyAssigneds == null ? null : this.possiblyAssigneds.remove(context.sym);
                if (possiblyAssigned != null) {
                    this.assignedVariables = possiblyAssigned;
                }
                FixedBitSet fixedBitSet2 = possiblyMultipleAssigned = this.possiblyMultipleAssigneds == null ? null : this.possiblyMultipleAssigneds.remove(context.sym);
                if (possiblyMultipleAssigned != null) {
                    this.multipleAssignedVariables = possiblyMultipleAssigned;
                }
            }
        } else {
            canReachNextStatement = true;
        }
        context.canReachNext = canReachNextStatement;
        context.relaxedCanReachNext = canReachNextStatement;
        return this.popContext(ContextKind.WHILE) != null;
    }

    private boolean endDoStatement(DoStmt doStatement) {
        Object constantValue;
        Boolean canReachNextStatement = null;
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        SourceExpression controlExpression = doStatement.getControlExpression();
        boolean forEver = false;
        if (controlExpression != null && (constantValue = controlExpression.getConstantValue()) instanceof Boolean) {
            forEver = (Boolean)constantValue;
        }
        if (forEver) {
            canReachNextStatement = context.hasReachableBreak;
            if (canReachNextStatement.booleanValue()) {
                FixedBitSet possiblyMultipleAssigned;
                FixedBitSet possiblyAssigned;
                FixedBitSet fixedBitSet = possiblyAssigned = this.possiblyAssigneds == null ? null : this.possiblyAssigneds.remove(context.sym);
                if (possiblyAssigned != null) {
                    this.assignedVariables = possiblyAssigned;
                }
                FixedBitSet fixedBitSet2 = possiblyMultipleAssigned = this.possiblyMultipleAssigneds == null ? null : this.possiblyMultipleAssigneds.remove(context.sym);
                if (possiblyMultipleAssigned != null) {
                    this.multipleAssignedVariables = possiblyMultipleAssigned;
                }
            }
        } else {
            canReachNextStatement = true;
        }
        context.canReachNext = canReachNextStatement;
        context.relaxedCanReachNext = canReachNextStatement;
        return this.popContext(ContextKind.DO) != null;
    }

    private boolean endForStatement(ForStmt forStatement) {
        Boolean canReachNextStatement = null;
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        if (forStatement.getForType() == 2) {
            canReachNextStatement = true;
        } else {
            boolean forEver = false;
            SourceExpression conditional = forStatement.getForConditional();
            if (conditional != null) {
                Object constantValue = conditional.getConstantValue();
                if (constantValue instanceof Boolean) {
                    forEver = (Boolean)constantValue;
                }
            } else {
                forEver = true;
            }
            if (forEver) {
                FixedBitSet possiblyMultipleAssigned;
                FixedBitSet possiblyAssigned;
                canReachNextStatement = context.hasReachableBreak;
                FixedBitSet fixedBitSet = possiblyAssigned = this.possiblyAssigneds == null ? null : this.possiblyAssigneds.remove(context.sym);
                if (possiblyAssigned != null) {
                    this.assignedVariables = possiblyAssigned;
                }
                FixedBitSet fixedBitSet2 = possiblyMultipleAssigned = this.possiblyMultipleAssigneds == null ? null : this.possiblyMultipleAssigneds.remove(context.sym);
                if (possiblyMultipleAssigned != null) {
                    this.multipleAssignedVariables = possiblyMultipleAssigned;
                }
            } else {
                canReachNextStatement = true;
            }
        }
        context.canReachNext = canReachNextStatement;
        context.relaxedCanReachNext = canReachNextStatement;
        return this.popContext(ContextKind.FOR) != null;
    }

    private boolean endTryStatement() {
        if (!this.popTryBody()) {
            return false;
        }
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        Boolean canReachNextStatement = null;
        Boolean relaxedCanReachNext = null;
        boolean tryCanReachNext = true;
        boolean tryRelaxedCanReachNext = true;
        Boolean catchCanReachNext = null;
        Boolean catchRelaxedCanReachNext = null;
        if (context.childContexts != null) {
            for (Context context2 : context.childContexts) {
                switch (context2.kind) {
                    case TRY_BODY: {
                        tryCanReachNext = context2.canReachNext;
                        tryRelaxedCanReachNext = context2.relaxedCanReachNext;
                        break;
                    }
                    case CATCH: {
                        catchCanReachNext = catchCanReachNext == null ? Boolean.valueOf(context2.canReachNext) : Boolean.valueOf(catchCanReachNext | context2.canReachNext);
                        catchRelaxedCanReachNext = catchRelaxedCanReachNext == null ? Boolean.valueOf(context2.relaxedCanReachNext) : Boolean.valueOf(catchRelaxedCanReachNext | context2.relaxedCanReachNext);
                    }
                }
            }
        }
        if (catchCanReachNext == null) {
            canReachNextStatement = tryCanReachNext;
            relaxedCanReachNext = tryRelaxedCanReachNext;
        } else {
            canReachNextStatement = tryCanReachNext | catchCanReachNext;
            relaxedCanReachNext = tryRelaxedCanReachNext | catchRelaxedCanReachNext;
        }
        context.canReachNext = canReachNextStatement;
        context.relaxedCanReachNext = relaxedCanReachNext;
        return this.popContext(ContextKind.TRY) != null;
    }

    private void removeCaughtExceptions(Context tryStmt) {
        LinkedHashMap<SourceTypeReference, CatchStmt> allCatchableExceptions = new LinkedHashMap<SourceTypeReference, CatchStmt>();
        TryStmt tryStmtSym = (TryStmt)tryStmt.sym;
        List<SourceCatchClause> catchClauses = tryStmtSym.getCatchClauses();
        for (SourceCatchClause catchClause : catchClauses) {
            SourceCatchParameter catchVariable = (SourceCatchParameter)catchClause.getCatchVariable();
            if (catchVariable == null) continue;
            List<SourceTypeReference> catchableExceptions = catchVariable.getSourceTypes();
            for (SourceTypeReference sourceTypeReference : catchableExceptions) {
                JavaType catchableExceptionType = sourceTypeReference.getResolvedType();
                if (catchableExceptionType == null) continue;
                allCatchableExceptions.put(sourceTypeReference, (CatchStmt)catchClause);
            }
        }
        HashSet exceptionsPossiblyCaught = new HashSet();
        if (this.thrownExceptions != null) {
            Iterator<JavaType> thrownIter = this.thrownExceptions.iterator();
            while (thrownIter.hasNext()) {
                JavaType thrownException = thrownIter.next();
                boolean removeThrownException = false;
                for (Map.Entry entry : allCatchableExceptions.entrySet()) {
                    JavaType caughtType = ((SourceTypeReference)entry.getKey()).getResolvedType();
                    if (Conversions.isSubtypeOf(thrownException, caughtType)) {
                        this.addCatchThatCaughtExceptions((SourceElement)entry.getValue());
                        exceptionsPossiblyCaught.add(entry.getKey());
                        removeThrownException = true;
                        continue;
                    }
                    if (!Conversions.isSubtypeOf(caughtType, thrownException)) continue;
                    exceptionsPossiblyCaught.add(entry.getKey());
                }
                if (!removeThrownException) continue;
                thrownIter.remove();
            }
        }
        for (SourceTypeReference exceptionCaught : exceptionsPossiblyCaught) {
            allCatchableExceptions.remove(exceptionCaught);
        }
        for (SourceTypeReference catchableException : allCatchableExceptions.keySet()) {
            JavaType exceptionType = catchableException.getResolvedType();
            if (this.compiler.isUncheckedException(exceptionType) || "java.lang.Exception".equals(exceptionType.getRawName()) || "java.lang.Throwable".equals(exceptionType.getRawName())) continue;
            this.compiler.error((Sym)((Object)catchableException), (short)117, exceptionType);
        }
    }

    private Context pushContext(ContextKind kind, Sym sym) {
        Context context;
        Context previousContext = this.contextStack.isEmpty() ? null : this.contextStack.peek();
        boolean isChildContext = kind.isChildContextKind();
        if (isChildContext) {
            Boolean constantValue;
            ChildContext childContext;
            if (this.cachedChildContexts.isEmpty()) {
                childContext = new ChildContext(this.assignedVariables, this.multipleAssignedVariables);
            } else {
                childContext = this.cachedChildContexts.pop();
                childContext.reinit();
                childContext.setAssignedVariables(this.assignedVariables);
                childContext.multipleAssignedVariables = this.multipleAssignedVariables;
            }
            context = childContext;
            if (previousContext != null && previousContext.kind == ContextKind.IF && (constantValue = this.getConstantValue((Stmt)previousContext.sym)) != null) {
                if (!constantValue.booleanValue() && kind == ContextKind.IF_BODY) {
                    context.suppressAssignErrors = true;
                } else if (constantValue.booleanValue() && kind == ContextKind.ELSE) {
                    context.suppressAssignErrors = true;
                }
            }
        } else if (this.cachedContexts.isEmpty()) {
            context = new Context();
        } else {
            context = this.cachedContexts.pop();
            context.reinit();
        }
        context.kind = kind;
        context.sym = sym;
        if (previousContext != null) {
            context.suppressAssignErrors |= previousContext.suppressAssignErrors;
        }
        switch (context.kind) {
            case METHOD: 
            case LAMBDA_EXPRESSION: 
            case CONSTRUCTOR: 
            case CLASS: {
                context.multipleAssignedVariables = new FixedBitSet(this.multipleAssignedVariables);
            }
        }
        this.assignedVariables.resize(this.variableCount);
        this.multipleAssignedVariables.resize(this.variableCount);
        this.contextStack.push(context);
        return context;
    }

    private Context popContext(ContextKind targetKind) {
        if (this.contextStack.isEmpty()) {
            if (this.checkCorrectPopContext) {
                throw new IllegalStateException("Pop Context Failure: Empty Stack");
            }
            return null;
        }
        Context context = this.contextStack.pop();
        if (context.kind != targetKind) {
            if (this.checkCorrectPopContext) {
                throw new IllegalStateException("Pop Context Failure: Incorrect Kind");
            }
            return null;
        }
        this.assignedVariables.resize(this.variableCount);
        this.multipleAssignedVariables.resize(this.variableCount);
        if (context.isChildContext()) {
            ChildContext childContext = (ChildContext)context;
            FixedBitSet childAssigned = this.assignedVariables;
            this.assignedVariables = childContext.assignedVariables;
            childContext.assignedVariables = childAssigned;
            FixedBitSet childMultipleAssigned = this.multipleAssignedVariables;
            this.multipleAssignedVariables = childContext.multipleAssignedVariables;
            childContext.multipleAssignedVariables = childMultipleAssigned;
            if (!this.contextStack.isEmpty()) {
                Context parent = this.contextStack.peek();
                parent.addChildContext(childContext);
            }
            return childContext;
        }
        this.cachedContexts.push(context);
        switch (context.kind) {
            case METHOD: 
            case LAMBDA_EXPRESSION: 
            case CONSTRUCTOR: 
            case CLASS: {
                this.multipleAssignedVariables = context.multipleAssignedVariables;
            }
        }
        if (context.kind == ContextKind.METHOD || context.kind == ContextKind.CLASS || context.kind == ContextKind.LAMBDA_EXPRESSION) {
            return context;
        }
        this.handlePoppedContext(context);
        return context;
    }

    private void handlePoppedContext(Context context) {
        if (context.childContexts != null) {
            FixedBitSet childrenAssigned = null;
            FixedBitSet childrenMultipleAssigned = null;
            Boolean casesCanReachNext = null;
            Boolean casesRelaxedCanReachNext = null;
            boolean hasDefaultCase = false;
            boolean hasDefaultCaseThatCanReachNext = false;
            boolean hasDefaultCaseThatRelaxedCanReachNext = false;
            boolean caseHasReachableBreak = false;
            boolean caseHasRelaxedReachableBreak = false;
            FixedBitSet casePossiblyAssigned = null;
            FixedBitSet casePossiblyMultipleAssigned = null;
            for (int x = 0; x < context.childContexts.size(); ++x) {
                FixedBitSet possiblyMultipleAssigned;
                FixedBitSet possiblyAssigned;
                ChildContext child = context.childContexts.get(x);
                this.cachedChildContexts.push(child);
                if (child.kind == ContextKind.CASE_BODY) {
                    if (child.isDefaultCase) {
                        hasDefaultCase = true;
                        hasDefaultCaseThatCanReachNext = child.canReachNext;
                        hasDefaultCaseThatRelaxedCanReachNext = child.relaxedCanReachNext;
                    }
                    if (child.hasReachableBreak) {
                        caseHasReachableBreak = true;
                    }
                    if (child.hasRelaxedReachableBreak) {
                        caseHasRelaxedReachableBreak = true;
                    }
                    casesCanReachNext = casesCanReachNext == null ? Boolean.valueOf(child.canReachNext) : Boolean.valueOf(casesCanReachNext | child.canReachNext);
                    casesRelaxedCanReachNext = casesRelaxedCanReachNext == null ? Boolean.valueOf(child.relaxedCanReachNext) : Boolean.valueOf(casesRelaxedCanReachNext | child.relaxedCanReachNext);
                }
                FixedBitSet fixedBitSet = possiblyAssigned = this.possiblyAssigneds == null ? null : this.possiblyAssigneds.remove(child.sym);
                if (possiblyAssigned != null) {
                    if (casePossiblyAssigned == null) {
                        casePossiblyAssigned = possiblyAssigned;
                    } else {
                        casePossiblyAssigned.and(possiblyAssigned);
                    }
                }
                FixedBitSet fixedBitSet2 = possiblyMultipleAssigned = this.possiblyMultipleAssigneds == null ? null : this.possiblyMultipleAssigneds.remove(child.sym);
                if (possiblyMultipleAssigned != null) {
                    if (casePossiblyMultipleAssigned == null) {
                        casePossiblyMultipleAssigned = possiblyMultipleAssigned;
                    } else {
                        casePossiblyMultipleAssigned.and(possiblyMultipleAssigned);
                    }
                }
                boolean ignore = !child.canReachNext;
                ignore |= child.kind == ContextKind.FINALLY;
                if (!(child.kind != ContextKind.CATCH || this.catchesThatCaughtExceptions != null && this.catchesThatCaughtExceptions.remove(child.sym))) {
                    ignore = true;
                }
                if (ignore |= context.kind == ContextKind.IF) continue;
                if (child.kind == ContextKind.CASE_BODY) {
                    if (casePossiblyAssigned == null) {
                        casePossiblyAssigned = child.assignedVariables;
                    } else {
                        casePossiblyAssigned.and(child.assignedVariables);
                    }
                    if (casePossiblyMultipleAssigned == null) {
                        casePossiblyMultipleAssigned = child.multipleAssignedVariables;
                        continue;
                    }
                    casePossiblyMultipleAssigned.and(child.multipleAssignedVariables);
                    continue;
                }
                if (childrenAssigned == null) {
                    childrenAssigned = child.assignedVariables;
                } else {
                    childrenAssigned.and(child.assignedVariables);
                }
                if (childrenMultipleAssigned == null) {
                    childrenMultipleAssigned = child.multipleAssignedVariables;
                    continue;
                }
                childrenMultipleAssigned.and(child.multipleAssignedVariables);
            }
            context.childContexts.clear();
            if (childrenAssigned != null) {
                this.assignedVariables.or(childrenAssigned);
            }
            if (childrenMultipleAssigned != null) {
                this.multipleAssignedVariables.or(childrenMultipleAssigned);
            }
            if (casesCanReachNext != null) {
                if (casePossiblyAssigned != null) {
                    this.assignedVariables = casePossiblyAssigned;
                }
                if (casePossiblyMultipleAssigned != null) {
                    this.multipleAssignedVariables = casePossiblyMultipleAssigned;
                }
                if (caseHasReachableBreak) {
                    casesCanReachNext = true;
                }
                if (caseHasRelaxedReachableBreak) {
                    casesRelaxedCanReachNext = true;
                }
                if (hasDefaultCaseThatCanReachNext || !hasDefaultCase) {
                    casesCanReachNext = true;
                }
                if (hasDefaultCaseThatRelaxedCanReachNext || !hasDefaultCase) {
                    casesRelaxedCanReachNext = true;
                }
                context.canReachNext &= casesCanReachNext.booleanValue();
                context.relaxedCanReachNext &= casesRelaxedCanReachNext.booleanValue();
            }
        }
        if (!this.contextStack.isEmpty()) {
            Context parent = this.contextStack.peek();
            if (context.kind == ContextKind.FINALLY) {
                if (!context.canReachNext) {
                    parent.canReachNext = false;
                }
                if (!context.relaxedCanReachNext) {
                    parent.relaxedCanReachNext = false;
                }
            } else {
                parent.canReachNext &= context.canReachNext;
                parent.relaxedCanReachNext &= context.relaxedCanReachNext;
            }
        }
    }

    private boolean assignVariable(SourceVariable variable, SourceExpression expr) {
        Integer index = this.variableToIndex.get(variable);
        if (index != null) {
            if (this.contextStack.isEmpty()) {
                return false;
            }
            Context context = this.contextStack.peek();
            if (context.canReachNext) {
                boolean isFinal = variable.isFinal() || this.definitelyAssignedFinals.get(index);
                boolean isAlreadyAssigned = this.assignedVariables.get(index);
                if (isFinal && isAlreadyAssigned && !context.suppressAssignErrors) {
                    Sym errorSym = expr == null ? (Sym)((Object)variable) : (Sym)((Object)expr);
                    short errorCode = this.definitelyAssignedFinals.get(index) ? (short)91 : 89;
                    this.compiler.error(errorSym, errorCode, variable.getName());
                }
                if (isAlreadyAssigned) {
                    this.multipleAssignedVariables.set(index);
                } else {
                    this.assignedVariables.set(index);
                }
            }
        }
        return true;
    }

    private void assignParameter(SourceVariable parameter) {
        Integer index = this.variableToIndex.get(parameter);
        if (index != null) {
            SourceCatchParameter catchParameter;
            this.assignedVariables.set(index);
            boolean isFinal = parameter.isFinal();
            if (!isFinal && parameter.getSymbolKind() == 28 && (catchParameter = (SourceCatchParameter)parameter).getSourceTypes().size() > 1) {
                isFinal = true;
            }
            if (isFinal) {
                this.definitelyAssignedFinals.set(index);
            }
        }
    }

    private boolean checkFieldUsage(Sym field) {
        block8: for (int x = this.contextStack.size() - 1; x >= 0; --x) {
            Context parent = (Context)this.contextStack.get(x);
            switch (parent.kind) {
                case CLASS: {
                    break block8;
                }
                case INITIALIZER: {
                    if (parent.sym.isStatic()) {
                        return field.isStatic();
                    }
                    return true;
                }
                case CONSTRUCTOR: {
                    return !field.isStatic();
                }
                case METHOD: {
                    return false;
                }
                case FIELD_DECLARATION: {
                    return field.getParentSym() == parent.sym;
                }
                case LAMBDA_EXPRESSION: {
                    return false;
                }
                default: {
                    continue block8;
                }
            }
        }
        return false;
    }

    public boolean useVariable(SourceVariable variable, SourceExpression expr) {
        if (this.contextStack.isEmpty()) {
            return false;
        }
        Context context = this.contextStack.peek();
        if (!context.canReachNext) {
            return true;
        }
        if (variable.getSymbolKind() == 10 && !this.checkFieldUsage((Sym)((Object)variable))) {
            return true;
        }
        Integer index = this.variableToIndex.get(variable);
        if (index != null) {
            if (context.canReachNext && !this.assignedVariables.get(index) && !context.suppressAssignErrors) {
                this.compiler.error((Sym)((Object)expr), (short)90, variable.getName());
            }
            if (variable.getSymbolKind() == 10) {
                return true;
            }
            if (!(variable.isFinal() || this.isJdk8OrAbove && !this.multipleAssignedVariables.get(index))) {
                SourceElement variableOwner = null;
                switch (variable.getSymbolKind()) {
                    case 17: {
                        variableOwner = ((SourceLocalVariable)variable).getOwningBlock();
                        break;
                    }
                    case 13: {
                        variableOwner = CommonUtilities.getEnclosingMethod(variable);
                        break;
                    }
                    case 31: {
                        variableOwner = ((SourceLambdaParameter)variable).getOwningLambdaExpression();
                    }
                }
                if (variableOwner != null) {
                    for (SourceElement parent = expr; parent != null && parent != variableOwner; parent = parent.getParent()) {
                        if (parent.getSymbolKind() == 3 && ((SourceClass)parent).isAnonymousClass()) {
                            if (this.isJdk8OrAbove) {
                                this.compiler.error((Sym)((Object)expr), (short)103, variable.getName());
                                break;
                            }
                            this.compiler.error((Sym)((Object)expr), (short)70, variable.getName());
                            break;
                        }
                        if (parent.getSymbolKind() != 79) continue;
                        this.compiler.error((Sym)((Object)expr), (short)103, variable.getName());
                        break;
                    }
                }
            }
        }
        return true;
    }

    public static void main(String[] args) {
        FixedBitSet bitset = new FixedBitSet(302);
        for (int x = 0; x < 302; x += 5) {
            bitset.set(x, true);
            if (bitset.get(x)) continue;
            System.out.println("Bad x: " + x);
        }
    }

    private static class FixedBitSet {
        private int size;
        private int[] pieces;

        FixedBitSet(int size) {
            this.size = size;
            this.pieces = size == 0 ? new int[0] : new int[(size - 1 >> 5) + 1];
        }

        FixedBitSet(FixedBitSet other) {
            this(other.size);
            this.or(other);
        }

        public boolean get(int bitIndex) {
            if (bitIndex < 0 || bitIndex >= this.size) {
                throw new IndexOutOfBoundsException("bitIndex: " + bitIndex);
            }
            int pieceIndex = bitIndex >> 5;
            int subIndex = bitIndex - (bitIndex >> 5 << 5);
            return (this.pieces[pieceIndex] & 1 << subIndex) != 0;
        }

        public void set(int bitIndex) {
            this.set(bitIndex, true);
        }

        public void set(int bitIndex, boolean value) {
            if (bitIndex < 0 || bitIndex >= this.size) {
                throw new IndexOutOfBoundsException("bitIndex: " + bitIndex);
            }
            int pieceIndex = bitIndex >> 5;
            int subIndex = bitIndex - (bitIndex >> 5 << 5);
            if (value) {
                int n = pieceIndex;
                this.pieces[n] = this.pieces[n] | 1 << subIndex;
            } else {
                int n = pieceIndex;
                this.pieces[n] = this.pieces[n] & ~(1 << subIndex);
            }
        }

        void and(FixedBitSet other) {
            int len = Math.min(this.size, other.size);
            if (len > 0) {
                int pieceLen = (len - 1 >> 5) + 1;
                for (int x = 0; x < pieceLen; ++x) {
                    int n = x;
                    this.pieces[n] = this.pieces[n] & other.pieces[x];
                }
            }
        }

        void or(FixedBitSet other) {
            int len = Math.min(this.size, other.size);
            if (len > 0) {
                int pieceLen = (len - 1 >> 5) + 1;
                for (int x = 0; x < pieceLen; ++x) {
                    int n = x;
                    this.pieces[n] = this.pieces[n] | other.pieces[x];
                }
            }
        }

        void resize(int newSize) {
            if (newSize == this.size) {
                return;
            }
            int oldSize = this.size;
            this.size = newSize;
            if (newSize > oldSize) {
                if (newSize > this.pieces.length << 5) {
                    int[] oldPieces = this.pieces;
                    this.pieces = new int[(newSize >> 5) + 1];
                    for (int x = 0; x < oldPieces.length; ++x) {
                        this.pieces[x] = oldPieces[x];
                    }
                }
                for (int x = oldSize; x < newSize; ++x) {
                    this.set(x, false);
                }
            }
        }
    }

    private static class Context {
        Sym sym;
        List<ChildContext> childContexts;
        ContextKind kind;
        boolean canReachNext = true;
        boolean relaxedCanReachNext = true;
        boolean hasReachableBreak;
        boolean hasRelaxedReachableBreak;
        boolean suppressAssignErrors;
        FixedBitSet multipleAssignedVariables;

        private Context() {
        }

        void reinit() {
            if (this.childContexts != null) {
                this.childContexts.clear();
                this.childContexts = null;
            }
            this.canReachNext = true;
            this.relaxedCanReachNext = true;
            this.hasReachableBreak = false;
            this.hasRelaxedReachableBreak = false;
            this.suppressAssignErrors = false;
        }

        boolean isChildContext() {
            return false;
        }

        void addChildContext(ChildContext childContext) {
            if (this.childContexts == null) {
                this.childContexts = new ArrayList<ChildContext>();
            }
            this.childContexts.add(childContext);
        }
    }

    private static class ChildContext
    extends Context {
        FixedBitSet assignedVariables;
        boolean isDefaultCase;

        ChildContext(FixedBitSet assignedVariables, FixedBitSet multipleAssignedVariables) {
            this.setAssignedVariables(assignedVariables);
            this.multipleAssignedVariables = multipleAssignedVariables;
        }

        @Override
        void reinit() {
            super.reinit();
            this.isDefaultCase = false;
        }

        void setAssignedVariables(FixedBitSet assignedVariables) {
            this.assignedVariables = new FixedBitSet(assignedVariables);
        }

        @Override
        boolean isChildContext() {
            return true;
        }
    }

    private static enum ContextKind {
        BLOCK(false),
        BLOCK_STATEMENT(false),
        CLASS(false),
        CONSTRUCTORS(false),
        DO(false),
        DO_CONDITION(false),
        FIELD_DECLARATION(false),
        FINALLY(false),
        FOR(false),
        IF(false),
        INITIALIZER(false),
        LAMBDA_EXPRESSION(false),
        METHOD(false),
        SWITCH(false),
        SYNCHRONIZED(false),
        TRY(false),
        WHILE(false),
        CASE_BODY(true),
        CATCH(true),
        CONSTRUCTOR(true),
        ELSE(true),
        IF_BODY(true),
        TRY_BODY(true);

        boolean isChildContext;

        private ContextKind(boolean isChildContext) {
            this.isChildContext = isChildContext;
        }

        boolean isChildContextKind() {
            return this.isChildContext;
        }
    }
}

