/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public abstract class SignatureParser<T>
implements JavaConstants {
    protected int curToken;
    protected String errorMessage = "Unknown error.";
    private int pos;
    private String text;
    private int textLength;
    private int curTokenStart;
    private int curTokenEnd;

    protected SignatureParser(String text) {
        this.text = text;
        this.textLength = text.length();
        this.skipToken();
    }

    protected SignatureParser(ReadTextBuffer buffer) {
        this(buffer.getString(0, buffer.getLength()));
    }

    protected int getCurToken() {
        return this.curToken;
    }

    protected int getCurTokenStart() {
        return this.curTokenStart;
    }

    protected int getCurTokenEnd() {
        return this.curTokenEnd;
    }

    protected String getCurTokenText() {
        if (this.curTokenStart < this.textLength) {
            return this.text.substring(this.curTokenStart, this.curTokenEnd);
        }
        return "";
    }

    protected abstract T getUnboundedWildcard();

    protected abstract T getBoundedWildcard(boolean var1, T var2);

    protected abstract void addTypeArgument(T var1, T var2);

    protected abstract T getClassType(char var1, String var2);

    protected abstract void pushInnerClassType(T var1, String var2);

    protected abstract T getTypeVariable(String var1);

    protected abstract T getArrayType(T var1);

    protected abstract T getPrimitiveType(PrimitiveType var1);

    protected final void nextToken(short tk) {
        if (this.curToken == tk) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    protected final void nextToken(short tk1, short tk2) {
        if (this.curToken == tk1 || this.curToken == tk2) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    protected final boolean optionalToken(short tk) {
        if (this.curToken != tk) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final boolean optionalToken(short tk1, short tk2) {
        if (this.curToken != tk1 && this.curToken != tk2) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final void skipToken() {
        if (this.pos >= this.textLength) {
            this.curToken = 0;
            this.curTokenStart = this.pos;
            this.curTokenEnd = this.pos;
        } else {
            this.curTokenStart = this.pos;
            char c = this.text.charAt(this.pos++);
            switch (c) {
                case ';': {
                    this.curToken = 75;
                    break;
                }
                case '*': {
                    this.curToken = 63;
                    break;
                }
                case '+': {
                    this.curToken = 67;
                    break;
                }
                case '-': {
                    this.curToken = 59;
                    break;
                }
                case '<': {
                    this.curToken = 58;
                    break;
                }
                case '>': {
                    this.curToken = 46;
                    break;
                }
                case '/': {
                    this.curToken = 41;
                    break;
                }
                case '.': {
                    this.curToken = 43;
                    break;
                }
                case ':': {
                    this.curToken = 38;
                    break;
                }
                case '(': {
                    this.curToken = 55;
                    break;
                }
                case ')': {
                    this.curToken = 72;
                    break;
                }
                case '^': {
                    this.curToken = 37;
                    break;
                }
                case '[': {
                    this.curToken = 50;
                    break;
                }
                default: {
                    if (JavaLexer.isJavaIdentifierPart(c) || c >= '\u0100' && Character.isJavaIdentifierPart(c)) {
                        this.curToken = 4;
                        while (this.pos < this.textLength && (JavaLexer.isJavaIdentifierPart(c = this.text.charAt(this.pos)) || c >= '\u0100' && Character.isJavaIdentifierPart(c))) {
                            ++this.pos;
                        }
                        break;
                    }
                    this.curToken = 0;
                }
            }
            this.curTokenEnd = this.pos;
        }
    }

    private final T parseTypeArgument0() {
        int bound = 0;
        switch (this.curToken) {
            case 63: {
                this.skipToken();
                return this.getUnboundedWildcard();
            }
            case 67: {
                bound = 1;
                this.skipToken();
                break;
            }
            case 59: {
                bound = 2;
                this.skipToken();
            }
        }
        T argument = this.parseTypeSignature0();
        if (bound == 0) {
            return argument;
        }
        return this.getBoundedWildcard(bound == 1, argument);
    }

    private final void parseTypeArguments_opt0(T type) {
        if (this.optionalToken((short)58)) {
            while (this.curToken != 46 && this.curToken != 0) {
                T argument = this.parseTypeArgument0();
                this.addTypeArgument(type, argument);
            }
            this.nextToken((short)46);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T parseTypeSignature0() {
        int start = this.curTokenStart;
        if (start == -1) {
            SignatureParser.panic("No token");
        }
        char ch = this.text.charAt(start);
        String savedError = this.errorMessage;
        try {
            PrimitiveType primitive;
            this.pos = start + 1;
            this.skipToken();
            switch (ch) {
                case 'L': {
                    int nameEnd;
                    this.errorMessage = "Invalid class reference.";
                    int nameStart = this.curTokenStart;
                    do {
                        if (this.curToken != 4) {
                            this.error();
                        }
                        nameEnd = this.curTokenEnd;
                        this.skipToken();
                    } while (this.optionalToken((short)41));
                    String name = this.text.substring(nameStart, nameEnd);
                    T type = this.getClassType(ch, name);
                    this.parseTypeArguments_opt0(type);
                    while (this.optionalToken((short)43)) {
                        if (this.curToken != 4) {
                            this.error();
                        }
                        int innerStart = this.curTokenStart;
                        int innerEnd = this.curTokenEnd;
                        this.skipToken();
                        String innerName = this.text.substring(innerStart, innerEnd);
                        this.pushInnerClassType(type, innerName);
                        this.parseTypeArguments_opt0(type);
                    }
                    this.nextToken((short)75);
                    T t = type;
                    return t;
                }
                case 'T': {
                    this.errorMessage = "Invalid type variable reference.";
                    int nameStart = start + 1;
                    if (this.curToken != 4) {
                        this.error();
                    }
                    int nameEnd = this.curTokenEnd;
                    String name = this.text.substring(nameStart, nameEnd);
                    this.skipToken();
                    this.nextToken((short)75);
                    T t = this.getTypeVariable(name);
                    return t;
                }
                case '[': {
                    T type = this.parseTypeSignature0();
                    T t = this.getArrayType(type);
                    return t;
                }
            }
            this.errorMessage = "Invalid class type signature.";
            if (ch < 'A' || 'Z' < ch) {
                this.error();
            }
            if ((primitive = PrimitiveType.PRIMITIVE_alpha[ch - 65]) == null) {
                this.error();
            }
            T t = this.getPrimitiveType(primitive);
            return t;
        }
        finally {
            this.errorMessage = savedError;
        }
    }

    protected final void error(String errorMessage) {
        errorMessage = errorMessage + ": " + this.text;
        CommonUtilities.panic(errorMessage);
    }

    protected final void error() {
        CommonUtilities.panic(this.text);
    }

    private static void panic(String message) {
        CommonUtilities.panic(message);
    }
}

