/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.filesystem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import oracle.javatools.filesystem.BufferFileSystemProvider;
import oracle.javatools.filesystem.PathImpl;

public class ByteBufferFileSystemProvider
extends BufferFileSystemProvider {
    public ByteBufferFileSystemProvider(String scheme) {
        super(scheme);
    }

    @Override
    protected SeekableByteChannel newByteChannelImpl(final PathImpl path, final Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (!this.getFileSystem().isOpen()) {
            throw new ClosedFileSystemException();
        }
        ByteBuffer buffer = (ByteBuffer)this.getBuffer(path);
        if (buffer == null) {
            buffer = ByteBuffer.allocate(0);
            this.putBuffer(path, buffer);
        } else if (options != null && options.contains(StandardOpenOption.CREATE_NEW)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        if (options == null || !options.contains(StandardOpenOption.APPEND) || !options.contains(StandardOpenOption.WRITE)) {
            buffer.rewind();
        }
        final ByteBuffer finalBuffer = buffer;
        return new SeekableByteChannel(){
            ByteBuffer buffer;
            {
                this.buffer = finalBuffer;
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                if (!ByteBufferFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                int remaining = this.buffer.remaining();
                dst.put(this.buffer);
                path.setLastAccessTime(System.currentTimeMillis());
                return remaining;
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                if (!ByteBufferFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                if (options != null && options.contains(StandardOpenOption.TRUNCATE_EXISTING) && options.contains(StandardOpenOption.WRITE)) {
                    this.truncate(0L);
                }
                int remaining = this.buffer.remaining();
                int srcRemaining = src.remaining();
                if (srcRemaining > remaining) {
                    int position = this.buffer.position();
                    ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() + srcRemaining - remaining);
                    this.buffer.rewind();
                    newBuffer.put(this.buffer);
                    newBuffer.position(position);
                    ByteBufferFileSystemProvider.this.putBuffer(path, newBuffer);
                    this.buffer = newBuffer;
                }
                this.buffer.put(src);
                path.setLastModifiedTime(System.currentTimeMillis());
                return srcRemaining;
            }

            @Override
            public long position() throws IOException {
                if (!ByteBufferFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                return this.buffer.position();
            }

            @Override
            public SeekableByteChannel position(long newPosition) throws IOException {
                if (!ByteBufferFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                if (newPosition < 0L || newPosition > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                if (newPosition > (long)this.buffer.capacity()) {
                    ByteBuffer newBuffer = ByteBuffer.allocate((int)newPosition);
                    this.buffer.rewind();
                    newBuffer.put(this.buffer);
                    ByteBufferFileSystemProvider.this.putBuffer(path, newBuffer);
                    this.buffer = newBuffer;
                }
                this.buffer.position((int)newPosition);
                return this;
            }

            @Override
            public long size() throws IOException {
                if (!ByteBufferFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                return this.buffer.capacity();
            }

            @Override
            public SeekableByteChannel truncate(long size) throws IOException {
                if (!ByteBufferFileSystemProvider.this.getFileSystem().isOpen()) {
                    throw new ClosedFileSystemException();
                }
                if (size < 0L || size > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                if (size < this.size()) {
                    ByteBuffer newBuffer = ByteBuffer.allocate((int)size);
                    this.buffer.rewind();
                    newBuffer.put(this.buffer.array(), 0, (int)size);
                    ByteBufferFileSystemProvider.this.putBuffer(path, newBuffer);
                    this.buffer = newBuffer;
                    path.setLastModifiedTime(System.currentTimeMillis());
                }
                return this;
            }

            @Override
            public boolean isOpen() {
                return ByteBufferFileSystemProvider.this.getFileSystem().isOpen();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

