/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.text;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareHighLite;
import oracle.javatools.compare.CompareHighLiteListener;
import oracle.javatools.compare.CompareHints;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.ExpirableContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareElement;

public abstract class TextCompareContributor
extends SequenceCompareContributor
implements ExpirableContributor {
    private List _changeListeners;
    private TextBufferListener _bufferListener;
    private Object _documentModel;
    private TextBuffer _textBufferSnapshot;
    private int _length;
    private Collection<CompareHighLite> _highLite;
    private Collection<CompareHighLiteListener> _highLiteListener;
    private Boolean _ignoreWhitespace;

    public Object getDocumentModel() {
        return this._documentModel;
    }

    public void setDocumentModel(Object documentModel) {
        this._documentModel = documentModel;
    }

    protected void addTextBufferListeners() {
        this._bufferListener = new TextBufferListener(){

            @Override
            public void attributeUpdate(TextBuffer buffer, int attribute) {
                if (attribute != 5) {
                    return;
                }
                if (TextCompareContributor.this.getPropertyChangeSupport() == null) {
                    return;
                }
                boolean modified = TextCompareContributor.this.getTextBuffer().isModified();
                this.firePropertyChange("modified", !modified, modified);
            }

            private void firePropertyChange(final String propertyName, final Object oldValue, final Object newValue) {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.firePropertyChange(propertyName, oldValue, newValue);
                        }
                    });
                    return;
                }
                TextCompareContributor.this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
            }

            @Override
            public void removeUpdate(TextBuffer buffer, int a, int b, char[] c) {
                TextCompareContributor.this.fireChangeEvent();
            }

            @Override
            public void insertUpdate(TextBuffer buffer, int a, int b, char[] c) {
                TextCompareContributor.this.fireChangeEvent();
            }
        };
        this.getTextBuffer().addTextBufferListener(this._bufferListener);
    }

    public void addChangeListener(ChangeListener cl) {
        if (this._changeListeners == null) {
            this._changeListeners = new ArrayList();
        }
        if (!this._changeListeners.contains(cl)) {
            this._changeListeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this._changeListeners != null) {
            this._changeListeners.remove(cl);
        }
    }

    protected void fireChangeEvent() {
        if (this._changeListeners != null) {
            ChangeEvent ce = null;
            Iterator i = this._changeListeners.iterator();
            while (i.hasNext()) {
                if (ce == null) {
                    ce = new ChangeEvent(this);
                }
                ((ChangeListener)i.next()).stateChanged(ce);
            }
        }
    }

    public final void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this._ignoreWhitespace = ignoreWhitespace;
    }

    public final boolean getIgnoreWhitespace() {
        if (this._ignoreWhitespace != null) {
            return this._ignoreWhitespace;
        }
        return CompareHints.isIgnoreWhiteSpace();
    }

    public abstract TextBuffer getTextBuffer();

    @Override
    public int getLength() {
        this.getTextBufferSnapshot();
        return this._length;
    }

    public void addHighLiteListener(CompareHighLiteListener listener) {
        if (this._highLiteListener == null) {
            this._highLiteListener = new ArrayList<CompareHighLiteListener>();
        }
        this._highLiteListener.add(listener);
    }

    public void removeHighLiteListener(CompareHighLiteListener listener) {
        if (this._highLiteListener != null) {
            this._highLiteListener.remove(listener);
        }
    }

    public boolean isHighLite() {
        return this._highLite == null;
    }

    public void addHighLite(CompareHighLite lite) {
        if (this._highLite == null) {
            this._highLite = new HashSet<CompareHighLite>();
        }
        this._highLite.add(lite);
        this.fireChangeEvent();
    }

    public void deleteHighLite(CompareHighLite lite) {
        if (this._highLite != null) {
            this._highLite.remove(lite);
            this.fireChangeEvent();
        }
    }

    public void selected(CompareHighLite lite) {
        if (this._highLiteListener != null) {
            for (CompareHighLiteListener listener : this._highLiteListener) {
                listener.selected(lite);
            }
        }
    }

    public void newHighLite(int startPos, int endPos, int startLine, int endLine) {
        if (this._highLiteListener != null) {
            for (CompareHighLiteListener listener : this._highLiteListener) {
                listener.added(startLine, endLine, startPos, endPos);
            }
        }
    }

    public CompareHighLite[] getHighLite() {
        if (this._highLite != null) {
            return this._highLite.toArray(new CompareHighLite[0]);
        }
        return new CompareHighLite[0];
    }

    private final int _getLength() {
        if (!this.getTextBufferSnapshot().tryReadLock()) {
            throw new ExpiredTextBufferException(this.getClass(), this.getTextBufferSnapshot());
        }
        try {
            if (this.getTextBufferSnapshot().getLength() == 0) {
                int n = 0;
                return n;
            }
            int n = this.getTextBufferSnapshot().getLineMap().getLineCount();
            return n;
        }
        finally {
            this.getTextBufferSnapshot().readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equal(int thisIndex, SequenceCompareContributor other, int otherIndex) {
        if (!this.getTextBufferSnapshot().tryReadLock()) {
            throw new ExpiredTextBufferException(this.getClass(), this.getTextBufferSnapshot());
        }
        try {
            boolean bl = this._equal(thisIndex, other, otherIndex);
            return bl;
        }
        finally {
            this.getTextBufferSnapshot().readUnlock();
        }
    }

    public boolean _equal(int thisIndex, SequenceCompareContributor other, int otherIndex) {
        TextCompareContributor otherText = (TextCompareContributor)other;
        int thisLineOffset = this.getTextBufferSnapshot().getLineMap().getLineStartOffset(thisIndex);
        int thatLineOffset = otherText.getTextBufferSnapshot().getLineMap().getLineStartOffset(otherIndex);
        int thisLineEndOffset = this.getTextBufferSnapshot().getLineMap().getLineEndOffset(thisIndex);
        int thatLineEndOffset = otherText.getTextBufferSnapshot().getLineMap().getLineEndOffset(otherIndex);
        thisLineEndOffset = Math.min(thisLineEndOffset, this.getTextBufferSnapshot().getLength());
        thatLineEndOffset = Math.min(thatLineEndOffset, otherText.getTextBufferSnapshot().getLength());
        if (!this.getIgnoreWhitespace() && thatLineEndOffset - thatLineOffset != thisLineEndOffset - thisLineOffset) {
            return false;
        }
        int i = thisLineOffset;
        int j = thatLineOffset;
        while (i < thisLineEndOffset || j < thatLineEndOffset) {
            char thatChar;
            char thisChar = i < thisLineEndOffset ? this.getTextBufferSnapshot().getChar(i) : (char)'\u0000';
            char c = thatChar = j < thatLineEndOffset ? otherText.getTextBufferSnapshot().getChar(j) : (char)'\u0000';
            if (this.getIgnoreWhitespace()) {
                if (TextCompareContributor.isWhitespace(thisChar)) {
                    ++i;
                    continue;
                }
                if (TextCompareContributor.isWhitespace(thatChar)) {
                    ++j;
                    continue;
                }
            }
            if (thisChar != thatChar) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TextBuffer getTextBufferSnapshot() {
        if (this._textBufferSnapshot == null) {
            TextCompareContributor textCompareContributor = this;
            synchronized (textCompareContributor) {
                if (this._textBufferSnapshot == null) {
                    this._textBufferSnapshot = TextBufferFactory.createExpirableTextBufferSnapshot(this.getTextBuffer());
                }
                this._length = this._getLength();
            }
        }
        return this._textBufferSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reset() {
        if (this._textBufferSnapshot != null) {
            TextCompareContributor textCompareContributor = this;
            synchronized (textCompareContributor) {
                this._textBufferSnapshot = null;
            }
        }
    }

    @Override
    public SequenceCompareElement getElement(SequenceCompareDifference difference, ContributorKind contributor) {
        int start = this.getTextBuffer().getLineMap().getLineStartOffset(difference.getStart(contributor));
        int end = this.getTextBuffer().getLineMap().getLineEndOffset(difference.getStart(contributor) + difference.getLength(contributor) - 1);
        final char[] chars = this.getTextBuffer().getChars(start, end - start);
        return new SequenceCompareElement(){

            @Override
            public Object getData() {
                return chars;
            }
        };
    }

    @Override
    public UndoableEdit deleteElement(int start, int end) {
        int startCaretPos = this.getTextBuffer().getLineMap().getLineStartOffset(start);
        int endCaretPos = this.getTextBuffer().getLineMap().getLineEndOffset(end);
        endCaretPos = Math.min(endCaretPos, this.getTextBuffer().getLength());
        int count = endCaretPos - startCaretPos;
        this.getTextBuffer().remove(startCaretPos, count < 0 ? 0 : count);
        return null;
    }

    @Override
    public UndoableEdit insertElement(int index, boolean after, SequenceCompareElement element) {
        int indexCaretPos = !after ? this.getTextBuffer().getLineMap().getLineStartOffset(index) : this.getTextBuffer().getLineMap().getLineEndOffset(index);
        indexCaretPos = Math.min(indexCaretPos, this.getTextBuffer().getLength());
        this.getTextBuffer().insert(indexCaretPos, (char[])element.getData());
        return null;
    }

    @Override
    public UndoableEdit replaceElement(int start, int end, SequenceCompareElement element) {
        int startCaretPos = this.getTextBuffer().getLineMap().getLineStartOffset(start);
        int endCaretPos = this.getTextBuffer().getLineMap().getLineEndOffset(end);
        endCaretPos = Math.min(endCaretPos, this.getTextBuffer().getLength());
        int count = endCaretPos - startCaretPos;
        this.getTextBuffer().remove(startCaretPos, count < 0 ? 0 : count);
        this.getTextBuffer().insert(startCaretPos, (char[])element.getData());
        return null;
    }
}

