/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import oracle.javatools.buffer.DefaultOffsetMark;

final class LinkedOffsetMark
extends DefaultOffsetMark {
    private LinkedOffsetMark forward;
    private LinkedOffsetMark backward;

    LinkedOffsetMark(int offset, boolean bias) {
        super(offset, bias);
        this.initializeHead();
    }

    LinkedOffsetMark nextMark() {
        return this.forward;
    }

    LinkedOffsetMark previousMark() {
        return this.backward;
    }

    void initializeHead() {
        this.forward = this;
        this.backward = this;
    }

    void attachAfter(LinkedOffsetMark currentMark) {
        LinkedOffsetMark nextMark;
        this.forward = nextMark = currentMark.forward;
        nextMark.backward = this;
        this.backward = currentMark;
        currentMark.forward = this;
    }

    void attachBefore(LinkedOffsetMark currentMark) {
        this.attachAfter(currentMark.backward);
    }

    void detach() {
        LinkedOffsetMark nextMark = this.forward;
        LinkedOffsetMark previousMark = this.backward;
        previousMark.forward = nextMark;
        nextMark.backward = previousMark;
        this.initializeHead();
    }
}

