/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

public class ForwardingTextBufferListener
implements TextBufferListener {
    private TextBuffer buffer;
    private CopyOnWriteArrayList<WeakReference<TextBufferListener>> listeners = new CopyOnWriteArrayList();

    public ForwardingTextBufferListener(TextBuffer buffer) {
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextBufferListener(TextBufferListener listener) {
        CopyOnWriteArrayList<WeakReference<TextBufferListener>> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            for (WeakReference<TextBufferListener> reference : this.listeners) {
                if (listener != reference.get()) continue;
                return;
            }
            this.listeners.add(new WeakReference<TextBufferListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTextBufferListener(TextBufferListener listener) {
        CopyOnWriteArrayList<WeakReference<TextBufferListener>> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            int i = this.listeners.size();
            while (i-- > 0) {
                if (listener != this.listeners.get(i).get()) continue;
                this.listeners.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pack() {
        CopyOnWriteArrayList<WeakReference<TextBufferListener>> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            int i = this.listeners.size();
            while (i-- > 0) {
                if (null != this.listeners.get(i).get()) continue;
                this.listeners.remove(i);
                return;
            }
        }
    }

    @Override
    public void attributeUpdate(TextBuffer buffer, int attribute) {
        boolean pack = false;
        for (WeakReference<TextBufferListener> reference : this.listeners) {
            TextBufferListener listener = (TextBufferListener)reference.get();
            if (listener != null) {
                listener.attributeUpdate(this.buffer, attribute);
                continue;
            }
            pack = true;
        }
        if (pack) {
            this.pack();
        }
    }

    @Override
    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        boolean pack = false;
        for (WeakReference<TextBufferListener> reference : this.listeners) {
            TextBufferListener listener = (TextBufferListener)reference.get();
            if (listener != null) {
                listener.insertUpdate(this.buffer, offset, count, insertedData);
                continue;
            }
            pack = true;
        }
        if (pack) {
            this.pack();
        }
    }

    @Override
    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        boolean pack = false;
        for (WeakReference<TextBufferListener> reference : this.listeners) {
            TextBufferListener listener = (TextBufferListener)reference.get();
            if (listener != null) {
                listener.removeUpdate(this.buffer, offset, count, removedData);
                continue;
            }
            pack = true;
        }
        if (pack) {
            this.pack();
        }
    }
}

