/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.util.concurrent.TimeUnit;

public final class ExpiredTextBufferException
extends RuntimeException {
    private final Class<?> source;
    private final Object name;
    private final boolean autoClosed;
    private final long expirationTime;
    private final String expirationThread;
    private final String reportThread;
    private final AWTEvent currentEvent;
    private static final long ONE_MILLISECOND = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    private static final long ONE_SECOND = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);

    public ExpiredTextBufferException(Class<?> source, Object name) {
        this.source = source;
        this.name = name;
        this.autoClosed = false;
        this.expirationTime = 0L;
        this.expirationThread = Thread.currentThread().getName();
        this.reportThread = Thread.currentThread().getName();
        this.currentEvent = EventQueue.getCurrentEvent();
    }

    public ExpiredTextBufferException(Class<?> source, Object name, boolean autoClosed, long expirationTime, String expirationThread, Throwable expirationCause) {
        super(expirationCause);
        this.source = source;
        this.name = name;
        this.autoClosed = autoClosed;
        this.expirationTime = expirationTime;
        this.expirationThread = expirationThread;
        this.reportThread = Thread.currentThread().getName();
        this.currentEvent = EventQueue.getCurrentEvent();
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(" expired ");
        if (this.autoClosed) {
            builder.append("(auto-closed) ");
        }
        if (this.expirationTime == 0L) {
            builder.append("and ");
        } else {
            int hours;
            int MILLISECOND = 1;
            int SECOND = 1000 * MILLISECOND;
            int MINUTE = 60 * SECOND;
            int HOUR = 60 * MINUTE;
            int DAY = 24 * HOUR;
            int remainder = (int)(System.currentTimeMillis() - this.expirationTime);
            assert (remainder >= 0);
            int days = remainder / DAY;
            if (days > 0) {
                builder.append(days).append("d ");
                remainder %= DAY;
            }
            if (days + (hours = remainder / HOUR) > 0) {
                builder.append(hours).append("h ");
                remainder %= HOUR;
            }
            int minutes = remainder / MINUTE;
            assert (minutes < HOUR);
            if (days + hours + minutes > 0) {
                builder.append(minutes).append("m ");
                remainder %= MINUTE;
            }
            if (days + hours == 0) {
                int seconds = remainder / SECOND;
                assert (seconds < MINUTE);
                builder.append(seconds);
                remainder %= SECOND;
                if (days + hours + minutes == 0) {
                    int milliseconds = remainder / MILLISECOND;
                    assert (milliseconds < SECOND);
                    builder.append('.').append("00" + remainder, 0, 3);
                }
                builder.append("s ");
            }
            builder.append("ago (see \"Caused by:\" stack trace below); ");
        }
        builder.append("reported from ").append(this.source.getSimpleName());
        builder.append(" on thread ").append(this.reportThread);
        if (this.currentEvent != null) {
            builder.append(" active AWT event:\n\t").append(this.currentEvent);
        }
        return builder.toString();
    }
}

