/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.text.Segment;
import oracle.javatools.buffer.TextBuffer;

final class DigestHash {
    private byte[] _digestHash;
    private int _hashCode;

    private DigestHash(byte[] digestHash) {
        this._digestHash = digestHash;
        this._hashCode = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DigestHash computeDigestHash(TextBuffer buffer) {
        buffer.readLock();
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            if (digest != null) {
                int CHAR_FETCH_SIZE = 128;
                int BYTE_FETCH_SIZE = 256;
                byte[] byteData = new byte[256];
                Segment segment = new Segment();
                int charsLeft = buffer.getLength();
                int pos = 0;
                while (charsLeft > 0) {
                    int charsToFetch = Math.min(128, charsLeft);
                    buffer.getText(pos, charsToFetch, segment);
                    int segmentSize = segment.count;
                    int segmentStart = segment.offset;
                    int segmentEnd = segmentStart + segmentSize;
                    char[] segmentData = segment.array;
                    int writePos = 0;
                    for (int i = segmentStart; i < segmentEnd; ++i) {
                        char c = segmentData[i];
                        byteData[writePos++] = (byte)(c & 0xFF);
                        byteData[writePos++] = (byte)(c >>> 8 & 0xFF);
                    }
                    digest.update(byteData, 0, writePos);
                    charsLeft -= charsToFetch;
                    pos += charsToFetch;
                }
                DigestHash digestHash = new DigestHash(digest.digest());
                return digestHash;
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("  Warning: MD5 digest unavailable: " + e.getMessage());
        }
        finally {
            buffer.readUnlock();
        }
        return null;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            int hashValue = 0;
            int length = this._digestHash.length;
            for (int i = 0; i < length; ++i) {
                hashValue = hashValue * 19 + this._digestHash[i];
            }
            this._hashCode = hashValue;
        }
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DigestHash) {
            return DigestHash.equals(this._digestHash, ((DigestHash)obj)._digestHash);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int length = this._digestHash.length;
        for (int i = 0; i < length; ++i) {
            buffer.append(Character.forDigit(this._digestHash[i] >> 4 & 0xF, 16));
            buffer.append(Character.forDigit(this._digestHash[i] >> 0 & 0xF, 16));
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private static boolean equals(byte[] data1, byte[] data2) {
        int len1 = data1.length;
        int len2 = data2.length;
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }
}

