/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.net.ProtocolConstants;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;

public class IdeURLFileSystemHelper
extends URLFileSystemHelper {
    @Override
    public URL canonicalize(URL url) {
        return URLFileSystem.canonicalize(this.getRealURL(url));
    }

    @Override
    public boolean canRead(URL url) {
        return URLFileSystem.canRead(this.getRealURL(url));
    }

    @Override
    public boolean canWrite(URL url) {
        return URLFileSystem.canWrite(this.getRealURL(url));
    }

    @Override
    public boolean canCreate(URL url) {
        return URLFileSystem.canCreate(this.getRealURL(url));
    }

    @Override
    public boolean canDelete(URL url) {
        return URLFileSystem.canDelete(this.getRealURL(url));
    }

    @Override
    public boolean isValid(URL url) {
        return URLFileSystem.isValid(this.getRealURL(url));
    }

    @Override
    public URL convertSuffix(URL url, String oldSuffix, String newSuffix) {
        return URLFileSystem.convertSuffix(this.getRealURL(url), oldSuffix, newSuffix);
    }

    @Override
    public void delete(URL url) throws IOException {
        URLFileSystem.deleteEx(this.getRealURL(url));
    }

    @Override
    public URL ensureSuffix(URL url, String suffix) {
        return URLFileSystem.ensureSuffix(this.getRealURL(url), suffix);
    }

    @Override
    public boolean equals(URL url1, URL url2) {
        return URLFileSystem.equals(this.getRealURL(url1), this.getRealURL(url2));
    }

    @Override
    public int hashCode(URL url) {
        return URLFileSystem.hashCode(this.getRealURL(url));
    }

    @Override
    public boolean exists(URL url) {
        return URLFileSystem.exists(this.getRealURL(url));
    }

    @Override
    public Icon getDefaultIcon(URL url) {
        return URLFileSystem.getDefaultIcon(this.getRealURL(url));
    }

    @Override
    public String getFileName(URL url) {
        return URLFileSystem.getFileName(this.getRealURL(url));
    }

    @Override
    public long getLength(URL url) {
        return URLFileSystem.getLength(this.getRealURL(url));
    }

    @Override
    public String getName(URL url) {
        return URLFileSystem.getName(this.getRealURL(url));
    }

    @Override
    public URL getParent(URL url) {
        return URLFileSystem.getParent(this.getRealURL(url));
    }

    @Override
    public String getPath(URL url) {
        return URLFileSystem.getPath(this.getRealURL(url));
    }

    @Override
    public String getPathNoExt(URL url) {
        return URLFileSystem.getPathNoExt(this.getRealURL(url));
    }

    @Override
    public String getPlatformPathName(URL url) {
        return URLFileSystem.getPlatformPathName(this.getRealURL(url));
    }

    @Override
    public String getSuffix(URL url) {
        return URLFileSystem.getSuffix(this.getRealURL(url));
    }

    @Override
    public boolean hasSuffix(URL url, String suffix) {
        return URLFileSystem.hasSuffix(this.getRealURL(url), suffix);
    }

    @Override
    public boolean isBaseURLFor(URL url1, URL url2) {
        return URLFileSystem.isBaseURLFor(this.getRealURL(url1), this.getRealURL(url2));
    }

    @Override
    public boolean isDirectory(URL url) {
        return URLFileSystem.isDirectory(this.getRealURL(url));
    }

    @Override
    public boolean isDirectoryPath(URL url) {
        return URLFileSystem.isDirectoryPath(this.getRealURL(url));
    }

    @Override
    public boolean isHidden(URL url) {
        return URLFileSystem.isHidden(this.getRealURL(url));
    }

    @Override
    public boolean isReadOnly(URL url) {
        return URLFileSystem.isReadOnly(this.getRealURL(url));
    }

    @Override
    public boolean isRegularFile(URL url) {
        return URLFileSystem.isRegularFile(this.getRealURL(url));
    }

    @Override
    public boolean isLocal(URL url) {
        return URLFileSystem.isLocal(this.getRealURL(url));
    }

    @Override
    public long lastModified(URL url) {
        return URLFileSystem.lastModified(this.getRealURL(url));
    }

    @Override
    public URL[] list(URL url) {
        return URLFileSystem.list(this.getRealURL(url));
    }

    @Override
    public URL[] list(URL url, URLFilter filter) {
        return URLFileSystem.list(this.getRealURL(url), filter);
    }

    @Override
    public boolean mkdir(URL url) {
        return URLFileSystem.mkdir(this.getRealURL(url));
    }

    @Override
    public boolean mkdirs(URL url) {
        return URLFileSystem.mkdirs(this.getRealURL(url));
    }

    @Override
    public InputStream openInputStream(URL url) throws IOException {
        return URLFileSystem.openInputStream(this.getRealURL(url));
    }

    @Override
    public OutputStream openOutputStream(URL url) throws IOException {
        return URLFileSystem.openOutputStream(this.getRealURL(url));
    }

    @Override
    public void rename(URL oldURL, URL newURL) throws IOException {
        URLFileSystem.renameEx(this.getRealURL(oldURL), this.getRealURL(newURL));
    }

    @Override
    public boolean setLastModified(URL url, long time) {
        return URLFileSystem.setLastModified(this.getRealURL(url), time);
    }

    @Override
    public boolean setReadOnly(URL url, boolean readOnly) {
        return URLFileSystem.setReadOnly(this.getRealURL(url), readOnly);
    }

    @Override
    public String toDisplayString(URL url) {
        return URLFileSystem.toDisplayString(this.getRealURL(url));
    }

    @Override
    public String toRelativeSpec(URL url, URL base) {
        return super.toRelativeSpec(url, base);
    }

    @Override
    public String toRelativeSpec(URL url, URL base, boolean mustConsumeBase) {
        return super.toRelativeSpec(url, base, mustConsumeBase);
    }

    @Override
    public URL getBaseParent(URL url, String relativeSpec) {
        return URLFileSystem.getBaseParent(this.getRealURL(url), relativeSpec);
    }

    @Override
    public Reader createReader(URL url, String encoding) throws IOException {
        return URLFileSystem.createReader(this.getRealURL(url), encoding);
    }

    protected URL getRealURL(URL url) {
        String protocol = url.getProtocol();
        if (!ProtocolConstants.isIdeProtocol(protocol)) {
            return url;
        }
        int index = protocol.lastIndexOf(".");
        String ideProtocol = null;
        String protocolCopy = protocol;
        List<Object> protocols = Arrays.asList(ProtocolConstants.PROTOCOLS.getItems());
        while (index > 0) {
            String head = protocolCopy.substring(0, index);
            int i = protocols.indexOf(head);
            if (i >= 0) {
                ideProtocol = (String)protocols.get(i);
            }
            if (ideProtocol != null) break;
            protocolCopy = head;
            index = protocolCopy.lastIndexOf(".");
        }
        if (ideProtocol != null) {
            String realProtocol = protocol.substring(ideProtocol.length() + 1, protocol.length());
            return URLFactory.replaceProtocolPart(url, realProtocol);
        }
        return null;
    }
}

