/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import oracle.jdeveloper.cm.AbstractConnectionWrapper;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.CMUtils;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;

public class JdbcConnectionWrapper
extends AbstractConnectionWrapper {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("oracle.jdeveloper.cm.ConnectionRtBundle");
    private Connection _connection;

    protected JdbcConnectionWrapper(ConnectionDescriptor descriptor, ConnectInfoPrompter prompter, ConnectionManager manager) throws CMException {
        super(descriptor, prompter, manager);
        this._connTypes = new ArrayList(1);
        this._connTypes.add("JDBC");
    }

    @Override
    void createConnection(ConnectionDescriptor descriptor) throws CMException {
        if (null != this._prompter) {
            this._prompter.promptUser(descriptor);
        }
        Properties jdbcProps = new Properties();
        String role = descriptor.getRole();
        if (null != role && !role.equals("") && !role.equals("Normal")) {
            jdbcProps.put("internal_logon", role);
        }
        String username = descriptor.getUsername();
        String password = descriptor.getPassword();
        if (descriptor.getProperty("ORACLE_JDBC_TYPE") != null && (username == null || password == null)) {
            throw new CMException(bundle.getString("ERROR_NULL_USER_PWD"));
        }
        if (null != username) {
            jdbcProps.put("user", username);
        }
        if (null != password) {
            jdbcProps.put("password", password);
        }
        String url = CMUtils.getUrl("JDBC", descriptor);
        String driverClass = descriptor.getJdbcDriver();
        if (driverClass == null) {
            throw new CMException("No driver specified.");
        }
        try {
            this._connection = this.createConnectionImpl(driverClass, url, jdbcProps);
        }
        catch (ClassNotFoundException cnfe) {
            throw new CMException("Unable to find driver: " + driverClass);
        }
        catch (IllegalAccessException iae) {
            throw new CMException("Unable to register driver: " + driverClass);
        }
        catch (InstantiationException ie) {
            throw new CMException("Unable to instantiate driver: " + driverClass);
        }
        catch (SQLException ex) {
            throw new CMException(ex);
        }
    }

    protected Connection createConnectionImpl(String driverClass, String url, Properties jdbcProps) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        DriverManager.registerDriver((Driver)Class.forName(driverClass).newInstance());
        return DriverManager.getConnection(url, jdbcProps);
    }

    @Override
    public Object getPresentation(String connType) throws CMException {
        if (!connType.equals("JDBC")) {
            throw new CMException("Cannot find presentation for " + connType + " in this ConnectionWrapper instance");
        }
        return this.getJdbcConnection();
    }

    public Connection getJdbcConnection() throws CMException {
        if (this._connection == null) {
            this.createConnection(this._descriptor);
        }
        return this._connection;
    }

    @Override
    public void closeConnection() {
        if (this._connection == null) {
            return;
        }
        try {
            this._connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean containsPresentation(String connType) {
        return connType.equals("JDBC");
    }
}

