/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.client;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.spatial.rdf.client.CompiledSPARQL;
import oracle.spatial.rdf.client.RDFModelMetadata;
import oracle.spatial.rdf.client.SPARQLClientUtils;
import oracle.spatial.rdf.client.SPARQLFeatureConfig;
import oracle.spatial.rdf.client.SPARQLPreparedStatement;
import oracle.spatial.rdf.server.LogUtils;
import oracle.spatial.rdf.server.OraBindValueInfo;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RDFLogger;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public class SPARQLRdbmsPreparedStatement
implements SPARQLPreparedStatement {
    private static final String CLASS_LOG_PFX = "oracle.spatial.rdf.client.SPARQLRdbmsPreparedStatement: ";
    Connection conn;
    PreparedStatement ps;
    CompiledSPARQL compiledSPARQL;
    OraBindValueInfo bvInfo;
    Map<String, String> varToResWordMap;
    RDFLogger logger;

    private SPARQLRdbmsPreparedStatement(Connection connection, String string, RDFModelMetadata rDFModelMetadata, String string2, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException {
        this.conn = connection;
        this.compiledSPARQL = SPARQLClientUtils.compileSPARQL(string, rDFModelMetadata, string2, null, null, rDFLogger, sPARQLFeatureConfig);
        this.bvInfo = this.compiledSPARQL.newBindValueInfo();
        this.logger = rDFLogger;
    }

    public static SPARQLRdbmsPreparedStatement prepareStatement(Connection connection, String string, String string2, String string3, String string4, String string5, RDFLogger rDFLogger) throws SQLException, RDFException {
        return SPARQLRdbmsPreparedStatement.prepareStatement(connection, string, string2, string3, string4, string5, rDFLogger, null);
    }

    public static SPARQLRdbmsPreparedStatement prepareStatement(Connection connection, String string, String string2, String string3, String string4, String string5, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException {
        RDFModelMetadata rDFModelMetadata = SPARQLClientUtils.populateRDFModelMetadata(connection, string2, string4, string5, rDFLogger);
        return SPARQLRdbmsPreparedStatement.prepareStatement(connection, string, rDFModelMetadata, string3, rDFLogger, sPARQLFeatureConfig);
    }

    public static SPARQLRdbmsPreparedStatement prepareStatement(Connection connection, String string, RDFModelMetadata rDFModelMetadata, String string2, RDFLogger rDFLogger) throws SQLException, RDFException {
        return SPARQLRdbmsPreparedStatement.prepareStatement(connection, string, rDFModelMetadata, string2, rDFLogger, null);
    }

    public static SPARQLRdbmsPreparedStatement prepareStatement(Connection connection, String string, RDFModelMetadata rDFModelMetadata, String string2, RDFLogger rDFLogger, SPARQLFeatureConfig sPARQLFeatureConfig) throws SQLException, RDFException {
        return new SPARQLRdbmsPreparedStatement(connection, string, rDFModelMetadata, string2, rDFLogger, sPARQLFeatureConfig);
    }

    @Override
    public void close() throws SQLException {
        if (this.ps != null) {
            this.ps.close();
        }
    }

    public String getSqlTranslation() throws SQLException, RDFException, ParseException {
        return this.compiledSPARQL.getSqlTranslation();
    }

    @Override
    public ResultSet executeQuery() throws SQLException, RDFException, ParseException {
        return this.executeQuery(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(Map<String, String> map) throws SQLException, RDFException, ParseException {
        ArrayList<Clob> arrayList = new ArrayList<Clob>();
        ResultSet resultSet = null;
        try {
            if (this.ps == null) {
                LogUtils.debug((String)"oracle.spatial.rdf.client.SPARQLRdbmsPreparedStatement:  ps is NULL ... creating PreparedStatement", (RDFLogger)this.logger);
                this.ps = this.compiledSPARQL.generatePreparedStmt(this.conn, this.bvInfo, map);
                this.varToResWordMap = new HashMap<String, String>();
                this.varToResWordMap.putAll(map);
            }
            LogUtils.debug((String)"oracle.spatial.rdf.client.SPARQLRdbmsPreparedStatement:  setting bind values", (RDFLogger)this.logger);
            this.compiledSPARQL.setBindValsInPreparedStmt(this.conn, this.ps, this.bvInfo, arrayList);
            if (map != null) {
                LogUtils.debug((String)"oracle.spatial.rdf.client.SPARQLRdbmsPreparedStatement:  populating input reserved word map with saved mappings", (RDFLogger)this.logger);
                map.putAll(this.varToResWordMap);
            }
            LogUtils.debug((String)"oracle.spatial.rdf.client.SPARQLRdbmsPreparedStatement:  executing SQL PreparedStatement ", (RDFLogger)this.logger);
            resultSet = this.ps.executeQuery();
        }
        finally {
            if (arrayList != null) {
                for (Clob clob : arrayList) {
                    if (clob == null) continue;
                    clob.free();
                }
            }
        }
        return resultSet;
    }

    @Override
    public void setURI(int n, String string) throws RDFException {
        this.bvInfo.setURI(n, string);
    }

    @Override
    public void setFloat(int n, float f) throws RDFException {
        this.bvInfo.setFloat(n, f);
    }

    @Override
    public void setDouble(int n, double d) throws RDFException {
        this.bvInfo.setDouble(n, d);
    }

    @Override
    public void setInt(int n, int n2) throws RDFException {
        this.bvInfo.setInt(n, n2);
    }

    @Override
    public void setLong(int n, long l) throws RDFException {
        this.bvInfo.setLong(n, l);
    }

    @Override
    public void setPlainLiteral(int n, String string) throws RDFException {
        this.bvInfo.setPlainLiteral(n, string);
    }

    @Override
    public void setLangLiteral(int n, String string, String string2) throws RDFException {
        this.bvInfo.setLangLiteral(n, string, string2);
    }

    @Override
    public void setTypedLiteral(int n, String string, String string2) throws RDFException {
        this.bvInfo.setTypedLiteral(n, string, string2);
    }
}

