/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.StatementProvider;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.offline.Db2OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.DB2Capturer;
import oracle.dbtools.migration.workbench.plugin.DB2OnlineCapturer;
import oracle.dbtools.migration.workbench.plugin.DB2Provider;
import oracle.dbtools.migration.workbench.plugin.DB2Quoter;
import oracle.dbtools.migration.workbench.plugin.Db2Converter;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import org.antlr.stringtemplate.StringTemplate;

public abstract class DB2Plugin
extends AbstractMigrationPlugin {
    public Logger LOGGER = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    private static final String EXPORT_COLUMN_DELIMITER = "#";
    private static final String DB2_PLATFORM_NAME = "DB2";
    public static final String DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static boolean s_driverLoaded = false;
    private static final String TEMPLATEPATH = "oracle/dbtools/migration/workbench/plugin/templates";
    private static final String DB2_TEMPLATE_NAME = "DB2";
    private boolean m_HeaderFlag = false;

    protected String getSupportedMapsXMLFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/DB2SupportedDataTypesMap.xml";
    }

    public DB2Plugin() {
        this.loadPluginTemplates(TEMPLATEPATH, ((Object)((Object)this)).getClass().getClassLoader(), "DB2");
    }

    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        try {
            DB2Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string);
            return new DB2Provider(this, connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        try {
            DB2Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, properties);
            return new DB2Provider(this, connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public String getIconFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/db2actions/images/ibmdb2.png";
    }

    public ThirdPartyDbProvider getProvider(String string, String string2, String string3) throws MigrationPluginException {
        try {
            DB2Plugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            return new DB2Provider(this, connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection connection) throws MigrationPluginException {
        return new DB2Provider(this, connection);
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName(DRIVER_CLASS).newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationPluginException((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MigrationPluginException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MigrationPluginException((Throwable)illegalAccessException);
            }
        }
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public int getPlatformMask() {
        return 65536;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new Db2OfflineCapturer();
    }

    public String getPlatformName() {
        return "DB2";
    }

    public String getPluginName() {
        return this.getPlatformName() + " " + this.getVersionNumber();
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.db2actions");
    }

    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        Object object = "";
        String string = mdColumn.getColumnType();
        String string2 = mdColumn2.getColumnName();
        String string3 = mdColumn2.getColumnType();
        Integer n = mdColumn2.getPrecision();
        int n2 = 0;
        n2 = n == null ? 0 : n;
        if ((string3.equalsIgnoreCase("CHAR") || string3.equalsIgnoreCase("NCHAR") || string3.equalsIgnoreCase("VARCHAR2") || string3.equalsIgnoreCase("NVARCHAR2")) && n2 >= 255) {
            object = "CHAR(" + n2 + ")";
        }
        if (string.equalsIgnoreCase("BLOB") || string.equalsIgnoreCase("CLOB") || string.equalsIgnoreCase("XML")) {
            object = "CHAR(1000000000)";
        }
        if (string.equalsIgnoreCase("TIME") || string.equalsIgnoreCase("TIMESTAMP")) {
            object = "\"TO_TIMESTAMP(:" + string2 + ", '" + MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask() + "')\"";
        } else if (string.equalsIgnoreCase("DATE")) {
            object = "\"TO_DATE(:" + string2 + ", '" + MigrationAddin.getMigrationConfig().getDateOfflineDateMask() + "')\"";
        }
        return object;
    }

    public StatementProvider getStatementProviderForDataMove() {
        return new StatementProvider(){

            public Object getColumnValue(ResultSet resultSet, String string) throws SQLException {
                Object object = resultSet.getObject(string);
                if (object != null) {
                    Class<?>[] classArray;
                    for (Class<?> clazz : classArray = object.getClass().getInterfaces()) {
                        if (!clazz.getName().endsWith("DB2Xml")) continue;
                        return resultSet.getString(string);
                    }
                }
                return super.getColumnValue(resultSet, string);
            }
        };
    }

    public Converter getConverter() {
        return new Db2Converter();
    }

    public String getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        StringBuffer stringBuffer = new StringBuffer("db2 export to ");
        try {
            String string3 = string;
            String string4 = string2;
            String string5 = migrationConfig.getEndColumnDelimiter();
            String string6 = "'" + string5 + "'";
            String string7 = migrationConfig.getEndRowDelimiter();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (MdColumn mdColumn : mdColumnArray) {
                String string8 = "'" + mdColumn.getColumnName() + "'";
                if ("XML".equals(mdColumn.getColumnType())) {
                    string8 = "XMLSERIALIZE(" + string8 + " AS CLOB)";
                }
                stringBuffer2.append(string8).append(",").append(string6).append(",");
            }
            stringBuffer2.setLength(stringBuffer2.length() - 1);
            stringBuffer.append("data\\");
            stringBuffer.append(string4);
            stringBuffer.append(" of DEL lobs to ." + File.separator + " modified by " + this.getLobFileOption());
            stringBuffer.append(" coldel\"#\"");
            stringBuffer.append(" datesiso nochardel \"select ").append(stringBuffer2);
            stringBuffer.append(", '" + string7).append("' from ").append(this.addQuotesToFileName(string3)).append("\"");
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, "Cannot get data Export command for {0}", string);
            return "";
        }
        return stringBuffer.toString();
    }

    public String getDataExportCommmand(String string, MdColumn[] stringTemplate, String string2, boolean bl) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer("db2 export to ");
        try {
            String string4 = string;
            String string5 = string2;
            String string6 = migrationConfig.getEndColumnDelimiter();
            String string7 = "'" + string6 + "'";
            String string8 = migrationConfig.getEndRowDelimiter();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (MdColumn mdColumn : stringTemplate) {
                String string9 = "\\\"" + mdColumn.getColumnName() + "\\\"";
                if ("XML".equals(mdColumn.getColumnType())) {
                    string9 = "XMLSERIALIZE(" + string9 + " AS CLOB)";
                }
                stringBuffer2.append(string9).append(",").append(string7).append(",");
            }
            stringBuffer2.setLength(stringBuffer2.length() - 1);
            stringBuffer.append("data\\");
            stringBuffer.append(string5);
            stringBuffer.append(" of DEL lobs to ." + File.separator + " modified by " + this.getLobFileOption());
            stringBuffer.append(" coldel\"#\"");
            stringBuffer.append(" datesiso nochardel \"select ").append(stringBuffer2);
            stringBuffer.append(", '" + string8).append("' from ").append(this.addQuotesToFileName(string4)).append("\"");
            StringTemplate stringTemplate2 = this.getPluginTemplateGroup().getInstanceOf("DataExportCommmand");
            stringTemplate2.setAttribute("platformWindows", (Object)bl);
            stringTemplate2.setAttribute("dataFileName", (Object)string2);
            stringTemplate2.setAttribute("colList", (Object)(stringBuffer2 + ", '" + string8 + "' "));
            stringTemplate2.setAttribute("orgOutFile", (Object)this.addQuotesToFileName(string4));
            string3 = stringTemplate2.toString();
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.WARNING, "Cannot get data Export command for {0}", string);
            return "";
        }
        return string3;
    }

    public String getDataHeaderCommand(boolean bl) {
        String string = "";
        StringTemplate stringTemplate = this.getPluginTemplateGroup().getInstanceOf("DataExportCommmandHeader");
        stringTemplate.setAttribute("platformWindows", (Object)bl);
        string = stringTemplate.toString();
        stringTemplate.reset();
        return string;
    }

    protected String getLobFileOption() {
        return "";
    }

    public String getDataMoveColumnDelimiter() {
        String string = super.getDataMoveColumnDelimiter();
        return EXPORT_COLUMN_DELIMITER + string + EXPORT_COLUMN_DELIMITER;
    }

    public String getDataMoveRowDelimiter() {
        String string = super.getDataMoveRowDelimiter();
        String string2 = this.getNewLineString();
        return string + string2;
    }

    private String getNewLineString() {
        String string = System.getProperty("line.separator");
        string = string.length() == 2 ? "\\r\\n" : "\\n";
        return string;
    }

    private String addQuotesToFileName(String string) {
        Object object = string.trim();
        String string2 = "\\\"";
        int n = ((String)object).lastIndexOf(46);
        String string3 = new StringBuffer((String)object).insert(n + 1, string2).toString();
        object = string3 + string2;
        return object;
    }

    public String getPlatformNameforNavigator() {
        return this.getPlatformName();
    }

    public DB2Capturer getCapturer(MigrationStorer migrationStorer, Connection connection) {
        return new DB2Capturer(migrationStorer, connection){

            @Override
            protected DB2OnlineCapturer getOnlineCapturer(MigrationStorer migrationStorer, Connection connection) {
                return new DB2OnlineCapturer(migrationStorer, connection);
            }
        };
    }

    public String createDataFileName(String string, String string2) {
        return this.replaceBlankSpaceWithUnderscoreInFileName(string) + ".dat";
    }

    private String replaceBlankSpaceWithUnderscoreInFileName(String string) {
        String string2 = string.trim();
        String string3 = "\\.";
        String[] stringArray = string2.split(string3);
        Object object = "";
        for (int i = 0; i < stringArray.length; ++i) {
            object = i < stringArray.length - 1 ? (String)object + stringArray[i].trim() + "." : (String)object + stringArray[i];
        }
        string2 = ((String)object).length() > 0 ? object : string2;
        String string4 = "_";
        if (string2.contains(" ")) {
            string2 = string2.replaceAll(" ", string4);
        }
        return string2;
    }

    public Quoter getQuoter() {
        return new DB2Quoter();
    }

    public MigrationPlugin.ProjectMergeLevel getMergeProjectSupportLevel() {
        return MigrationPlugin.ProjectMergeLevel.PROJECT_MERGE_LEVEL_SCHEMA;
    }
}

