/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.util;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import oracle.olapdv.log.LogWriter;
import oracle.olapdv.log.ValidateLogger;
import oracle.olapdv.log.ViewLogDialog;
import oracle.olapdv.olap.model.ValidateTopDO;

public class MiscUtils {
    private static Logger LOG = Logger.getLogger(MiscUtils.class.getName());

    public ImageIcon getImage(String string) {
        ImageIcon imageIcon = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            inputStream.close();
            imageIcon = new ImageIcon(bufferedImage);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "In method getImage IOException occurred", iOException);
        }
        return imageIcon;
    }

    public static Rectangle centerWindow(Component component, int n, int n2) {
        double d = component.getX();
        double d2 = component.getY();
        double d3 = component.getWidth();
        double d4 = component.getHeight();
        int n3 = (int)(d + (d3 - (double)n) / 2.0);
        int n4 = (int)(d2 + (d4 - (double)n2) / 2.0);
        if (n3 < 0) {
            n3 = 10;
        }
        if (n4 < 0) {
            n4 = 10;
        }
        return new Rectangle(n3, n4, n, n2);
    }

    public static String stripCarriageReturnCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            int n = string.length();
            String string2 = null;
            for (int i = 0; i < n; ++i) {
                string2 = string.substring(i, i + 1);
                if (string2.equalsIgnoreCase("\r")) continue;
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static String stripCarriageReturnAndLineFeedCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            int n = string.length();
            String string2 = null;
            for (int i = 0; i < n; ++i) {
                string2 = string.substring(i, i + 1);
                if (string2.equalsIgnoreCase("\r") || string2.equalsIgnoreCase("\n")) continue;
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public boolean verifyCommitOnPendingSQL(Component component) {
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        if (validateTopDO.getPendingSQLUpdates()) {
            int n = JOptionPane.showConfirmDialog(component, "There are pending SQL updates. Your current action will commit the SQL updates. Continue?", "Commit SQL Updates", 0);
            boolean bl = n == 0;
            return bl;
        }
        return true;
    }

    public static void showLogInformation(String string, Component component) {
        String string2 = string + ".log";
        InputStreamReader inputStreamReader = null;
        String string3 = null;
        String string4 = MiscUtils.getHomeDirectory();
        string3 = string4 != null ? string4 + "/" + string2 : string2;
        try {
            File file = new File(string3);
            if (!file.exists()) {
                ValidateLogger validateLogger = ValidateLogger.getInstance();
                LogWriter logWriter = validateLogger.getLogWriter(string);
                logWriter.write(" ");
                file = new File(string3);
            }
            long l = file.length();
            char[] cArray = new char[(int)(l += 100L)];
            inputStreamReader = new FileReader(string3);
            int n = 0;
            int n2 = 0;
            while (n >= 0 && (long)n2 < l) {
                n = inputStreamReader.read(cArray, n2, 1);
                ++n2;
            }
            inputStreamReader.close();
            String string5 = new String(cArray);
            String string6 = string5.trim();
            string6 = MiscUtils.stripCarriageReturnCharacters(string6);
            ViewLogDialog viewLogDialog = null;
            viewLogDialog = component instanceof JFrame ? new ViewLogDialog((JFrame)component, string2, string6, string) : new ViewLogDialog((JDialog)component, string2, string6, string);
            Rectangle rectangle = MiscUtils.centerWindow(component, 650, 600);
            viewLogDialog.setBounds(rectangle);
            viewLogDialog.setModal(true);
            viewLogDialog.setVisible(true);
        }
        catch (IOException iOException) {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            LOG.log(Level.SEVERE, "In method showLogInformation, IOException error showing the sql log file", iOException);
            JOptionPane.showMessageDialog(component, "IOException " + iOException, "Error", 0);
        }
    }

    public static String getHomeDirectory() {
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = System.getProperty(string);
            if (!string.equalsIgnoreCase("user.home")) continue;
            return string2;
        }
        return null;
    }
}

