/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.query;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.ValidateViewer;
import oracle.olapdv.log.LogWriter;
import oracle.olapdv.log.ValidateLogger;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.query.ValidateQuerySQL;

public class DrillToDetailQuery {
    private static final Logger LOG = Logger.getLogger(DrillToDetailQuery.class.getName());
    private Object[][] m_someData = null;
    private ValidateModelDO m_validateModelDO;
    private LevelDO m_levelDO;
    private int m_activeReport;
    private ValidateViewer m_validateViewer;
    private int m_alterTableSize = 0;
    private int m_alterTableSize2 = 0;

    public DrillToDetailQuery(ValidateViewer validateViewer, ValidateModelDO validateModelDO, LevelDO levelDO, int n) {
        this.m_validateViewer = validateViewer;
        this.m_validateModelDO = validateModelDO;
        this.m_levelDO = levelDO;
        this.m_activeReport = n;
    }

    public void logDrillToDetailQuery() {
        this.m_someData = null;
        QueryManager queryManager = new QueryManager();
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        ValidateLogger validateLogger = ValidateLogger.getInstance();
        LogWriter logWriter = validateLogger.getLogWriter(this.m_levelDO.getModelName());
        String string = null;
        LevelMapDO levelMapDO = null;
        levelMapDO = this.m_levelDO.getLevelMapDO();
        String string2 = levelMapDO.getOwner();
        String string3 = levelMapDO.getTableName();
        String string4 = levelMapDO.getColumnName();
        String string5 = levelMapDO.getLongDescriptionColumnName();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null || string2.length() == 0) {
            stringBuffer.append(OLAPDVArb.format("TABLE_OWNER_IS_NULL_FOR_LEVEL", this.m_levelDO.getName()));
            bl = true;
        }
        if (string3 == null || string3.length() == 0) {
            stringBuffer.append(OLAPDVArb.format("TABLE_NAME_IS_NULL_FOR_LEVEL", this.m_levelDO.getName()));
            bl = true;
        }
        if (string4 == null || string4.length() == 0) {
            stringBuffer.append(OLAPDVArb.format("KEY_COLUMN_IS_NULL_FOR_LEVEL", this.m_levelDO.getName()));
            bl = true;
        }
        if (string5 == null || string5.length() == 0) {
            stringBuffer.append(OLAPDVArb.format("DESCRIPTION_COLUMN_IS_NULL_FOR_LEVEL", this.m_levelDO.getName()));
            bl = true;
        }
        if (bl) {
            this.showInvalidArgumentsErrorMessage(stringBuffer);
            return;
        }
        try {
            if (this.m_activeReport == 1) {
                string = validateQuerySQL.getSQLForDrillOnDistinctMembersAndDescriptions(this.m_levelDO);
                logWriter.write(" ");
                logWriter.write("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_MEMBERS", this.m_levelDO.getName(), this.m_levelDO.getOwningDimensionName(), this.m_levelDO.getOwningHierarchyName()));
                logWriter.write(string + ";");
            } else if (this.m_activeReport == 2) {
                string = validateQuerySQL.getSQLForDrillOnDistinctMembersAndDescriptions(this.m_levelDO);
                logWriter.write(" ");
                logWriter.write("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_DISTINCT_MEMBERS_AND_DESCRIPTIONS", this.m_levelDO.getName(), this.m_levelDO.getOwningDimensionName(), this.m_levelDO.getOwningHierarchyName()));
                logWriter.write(string + ";");
            } else if (this.m_activeReport == 3) {
                string = validateQuerySQL.getSQLForDrillOnNonUniqueMembersAcrossLevel(this.m_levelDO);
                logWriter.write(" ");
                logWriter.write("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_DUPLICATE_MEMBERS_ACROSS_LEVELS", this.m_levelDO.getName(), this.m_levelDO.getOwningDimensionName(), this.m_levelDO.getOwningHierarchyName()));
                logWriter.write(string + ";");
            } else if (this.m_activeReport == 4) {
                string = validateQuerySQL.getSQLForDrillOnMembersWithNullRows(this.m_levelDO);
                logWriter.write(" ");
                logWriter.write("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_NULL_MEMBER_ROWS", this.m_levelDO.getName(), this.m_levelDO.getOwningDimensionName(), this.m_levelDO.getOwningHierarchyName()));
                logWriter.write(string + ";");
            } else if (this.m_activeReport == 5) {
                string = validateQuerySQL.getSQLForDrillOnMembersWithNullDescriptions(this.m_levelDO);
                logWriter.write(" ");
                logWriter.write("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_NULL_DESCRIPTIONS", this.m_levelDO.getName(), this.m_levelDO.getOwningDimensionName(), this.m_levelDO.getOwningHierarchyName()));
                logWriter.write(string + ";");
            } else if (this.m_activeReport == 6) {
                string = validateQuerySQL.getSQLForDrillOnMembersWithMultipleDescriptions(this.m_levelDO);
                logWriter.write(" ");
                logWriter.write("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_MEMBERS_WITH_MULTIPLE_DESCRIPTION", this.m_levelDO.getName(), this.m_levelDO.getOwningDimensionName(), this.m_levelDO.getOwningHierarchyName()));
                logWriter.write(string + ";");
            } else if (this.m_activeReport == 7) {
                string = validateQuerySQL.getSQLForDrillOnDescriptionsAssignedToMultipleMembers(this.m_levelDO);
                logWriter.write(" ");
                logWriter.write("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_DESCRIPTIONS_WITH_MULTIPLE_MEMBERS", this.m_levelDO.getName(), this.m_levelDO.getOwningDimensionName(), this.m_levelDO.getOwningHierarchyName()));
                logWriter.write(string + ";");
                this.m_alterTableSize = queryManager.findAlterTableColumnSizeForConcatFix(this.m_levelDO, 3);
                if (this.m_levelDO.getParentLevelDO() != null) {
                    this.m_alterTableSize2 = queryManager.findAlterTableColumnSizeForConcatFix(this.m_levelDO, 2);
                }
            } else if (this.m_activeReport == 8) {
                string = validateQuerySQL.getSQLForDrillOnMembersWithMultipleParents(this.m_levelDO);
                logWriter.write(" ");
                logWriter.write("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_MEMBERS_WITH_MULTIPLE_PARENTS", this.m_levelDO.getName(), this.m_levelDO.getOwningDimensionName(), this.m_levelDO.getOwningHierarchyName()));
                logWriter.write(string + ";");
                LevelDO levelDO = this.m_levelDO.getParentLevelDO();
                this.m_alterTableSize = queryManager.findAlterTableColumnSizeForConcatFix(this.m_levelDO, 1);
            } else if (this.m_activeReport == 9) {
                string = validateQuerySQL.getSQLForDrillOnDescriptionsWithMultipleParentDescs(this.m_levelDO);
                logWriter.write(" ");
                logWriter.write("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_DESCRIPTIONS_WITH_MULTIPLE_PARENT_DESCRIPTIONS", this.m_levelDO.getName(), this.m_levelDO.getOwningDimensionName(), this.m_levelDO.getOwningHierarchyName()));
                logWriter.write(string + ";");
                LevelDO levelDO = this.m_levelDO.getParentLevelDO();
                this.m_alterTableSize = queryManager.findAlterTableColumnSizeForConcatFix(this.m_levelDO, 2);
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, "In method logDrillToDetailQuery, SQL Exception occurred, error code = " + sQLException.getErrorCode(), sQLException);
            this.showErrorMessage(sQLException, string);
        }
    }

    public String getSQLQuery() {
        String string = null;
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        if (this.m_activeReport == 1) {
            string = validateQuerySQL.getSQLForDrillOnDistinctMembersAndDescriptions(this.m_levelDO);
        } else if (this.m_activeReport == 2) {
            string = validateQuerySQL.getSQLForDrillOnDistinctMembersAndDescriptions(this.m_levelDO);
        } else if (this.m_activeReport == 3) {
            string = validateQuerySQL.getSQLForDrillOnNonUniqueMembersAcrossLevel(this.m_levelDO);
        } else if (this.m_activeReport == 4) {
            string = validateQuerySQL.getSQLForDrillOnMembersWithNullRows(this.m_levelDO);
        } else if (this.m_activeReport == 5) {
            string = validateQuerySQL.getSQLForDrillOnMembersWithNullDescriptions(this.m_levelDO);
        } else if (this.m_activeReport == 6) {
            string = validateQuerySQL.getSQLForDrillOnMembersWithMultipleDescriptions(this.m_levelDO);
        } else if (this.m_activeReport == 7) {
            string = validateQuerySQL.getSQLForDrillOnDescriptionsAssignedToMultipleMembers(this.m_levelDO);
        } else if (this.m_activeReport == 8) {
            string = validateQuerySQL.getSQLForDrillOnMembersWithMultipleParents(this.m_levelDO);
        } else if (this.m_activeReport == 9) {
            string = validateQuerySQL.getSQLForDrillOnDescriptionsWithMultipleParentDescs(this.m_levelDO);
        }
        return string;
    }

    public void showErrorMessage(SQLException sQLException, String string) {
        final SQLException sQLException2 = sQLException;
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (sQLException2.getErrorCode() != 1013 && sQLException2.getErrorCode() != 17009 && sQLException2.getErrorCode() != 17011) {
                    JOptionPane.showMessageDialog(DrillToDetailQuery.this.m_validateViewer.getParentComponent(), OLAPDVArb.format("DRILL_QUERY_ERROR_IS", sQLException2, string2), OLAPDVArb.getString("QUERY_ERROR"), 0);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void showInvalidArgumentsErrorMessage(StringBuffer stringBuffer) {
        final StringBuffer stringBuffer2 = stringBuffer;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(DrillToDetailQuery.this.m_validateViewer.getParentComponent(), OLAPDVArb.format("THE_DRILL_TO_DETAILS_QUERY_CANNOT_BE_COMPLETED", stringBuffer2.toString()), OLAPDVArb.getString("INVALID_SOURCE_MAPPING_FOUND"), 0);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public Object[][] getDataRaw() {
        return this.m_someData;
    }

    public void clearData() {
        if (this.m_someData != null) {
            this.m_someData = null;
        }
    }

    public int getAlterTableSize() {
        return this.m_alterTableSize;
    }

    public int getAlterTableSize2() {
        return this.m_alterTableSize2;
    }
}

