/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.olap.util.ButtonMenu;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.OLAPDVImagesArb;
import oracle.olapdv.app.ProgressStatusDialog;
import oracle.olapdv.app.SwingWorker;
import oracle.olapdv.app.ValidateDrillDialog;
import oracle.olapdv.app.ValidateDrillResolvePanel;
import oracle.olapdv.app.ValidateInterruptObserver;
import oracle.olapdv.app.ValidatePanel;
import oracle.olapdv.app.ValidateViewer;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.log.LogWriter;
import oracle.olapdv.log.ValidateLogger;
import oracle.olapdv.log.ViewLogDialog;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;
import oracle.olapdv.query.DrillToDetailQuery;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.query.ValidateQuerySQL;
import oracle.olapdv.util.MiscUtils;
import oracle.olapdv.util.jdbc.SQLWrapper;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.NUMBER;

public class ValidateDrillPanel
extends JPanel
implements ListSelectionListener,
ValidateInterruptObserver,
ActionListener {
    private JScrollPane drillResultSetTableScrollPane;
    private ResultSetTable drillResultSetTable;
    private ValidateDrillDialog m_drillDialog;
    private ValidateDrillResolvePanel resolvePanel;
    private ProgressStatusDialog progressStatusDialog;
    private ValidateModelDO validateModelDO;
    private String lastSearchString;
    private boolean continueSearchFlag = false;
    private int startRowForSearch = 0;
    private JButton helpButton;
    private JButton refreshButton;
    private JToggleButton exportButton;
    private LevelDO levelDO;
    private LevelDO parentLevelDO;
    private int activeReport;
    private ValidateViewer validateViewer;
    private int lastRow;
    private int lastColumn;
    private JTextArea sqlTextArea;
    private JTextField findTextField;
    private int alterTableSize = 0;
    private int alterTableSize2 = 0;
    private boolean doneUpdate = false;
    private boolean interrupted = false;
    private boolean isDisposed = false;
    private String sqlQuery;
    private List<JMenuItem> items = new ArrayList<JMenuItem>();
    private ImageIcon refreshDataImage;
    private String lastTimeTableUpdated;
    private static final Logger LOG = Logger.getLogger(ValidateDrillPanel.class.getName());

    public ValidateDrillPanel(ValidateDrillDialog validateDrillDialog, ValidateViewer validateViewer, ValidateModelDO validateModelDO, LevelDO levelDO, int n) {
        this.m_drillDialog = validateDrillDialog;
        this.validateViewer = validateViewer;
        this.validateModelDO = validateModelDO;
        this.levelDO = levelDO;
        this.parentLevelDO = levelDO.getParentLevelDO();
        this.activeReport = n;
    }

    protected ValidateViewer getValidateViewer() {
        return this.validateViewer;
    }

    @Override
    public boolean getInterruptedStatus() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted() {
        this.interrupted = true;
        try {
            SQLWrapper.cancel();
        }
        catch (SQLException sQLException) {
            LOG.log(Level.WARNING, "In method setInterruped, SQL Exception for cancel is " + sQLException.getErrorCode(), sQLException);
        }
    }

    @Override
    public void clearInterrupted() {
        this.interrupted = false;
    }

    public void initializePanel(DrillToDetailQuery drillToDetailQuery) {
        this.jbinit(drillToDetailQuery);
        this.lastTimeTableUpdated = this.getLastTimeTableUpdated();
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        validateTopDO.setLastDrillToDetailLevel(this.levelDO);
        validateTopDO.setLastTimeDimensionTableUpdated(this.lastTimeTableUpdated);
    }

    protected String getLastTimeTableUpdated() {
        LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
        String string = levelMapDO.getOwner();
        String string2 = levelMapDO.getTableName();
        QueryManager queryManager = new QueryManager();
        String string3 = queryManager.getLastTimeTableUpdated(string, string2);
        return string3;
    }

    private void jbinit(DrillToDetailQuery drillToDetailQuery) {
        this.refreshDataImage = new ImageIcon(OLAPDVImagesArb.getImage("REFRESH_ICON"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.alterTableSize = drillToDetailQuery.getAlterTableSize();
        this.alterTableSize2 = drillToDetailQuery.getAlterTableSize2();
        this.sqlQuery = drillToDetailQuery.getSQLQuery();
        this.drillResultSetTable = new ResultSetTable();
        OracleDatabaseImpl oracleDatabaseImpl = ValidateTopDO.getInstance().getOracleDatabaseImpl();
        String string = oracleDatabaseImpl.getQualifiedName();
        this.drillResultSetTable.setQuery(string, this.sqlQuery, null, null);
        try {
            this.drillResultSetTable.refresh();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "In method jbinit, refresh of drillResultSetTable caused the exception ", exception);
        }
        this.drillResultSetTable.allRowsFetched();
        this.drillResultSetTable.setSelectionMode(0);
        this.drillResultSetTableScrollPane = new JScrollPane();
        this.drillResultSetTableScrollPane.setViewportView((Component)this.drillResultSetTable);
        this.refreshButton = new JButton(this.refreshDataImage);
        gridBagConstraints.gridwidth = 5;
        JButton jButton = new JButton(StringUtils.stripMnemonic((String)OLAPDVArb.get("SHOW_DRILL_TO_DETAIL_SQL_LABEL")));
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPDVArb.get("SHOW_DRILL_TO_DETAIL_SQL_LABEL")));
        LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
        String string2 = levelMapDO.getTableName();
        String string3 = levelMapDO.getOwner();
        JLabel jLabel = new JLabel(OLAPDVArb.format("SOURCE_DIMENSION_TABLE_LABEL", string3, string2));
        gridBagConstraints.gridheight = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 5, 0, 5);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(jLabel);
        ControlBar controlBar = new ControlBar();
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)OLAPDVArb.get("FIND_LABEL")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPDVArb.get("FIND_LABEL")));
        controlBar.add((Component)jLabel2);
        this.findTextField = new JTextField(30);
        this.findTextField.setMinimumSize(new Dimension(40, jLabel2.getHeight()));
        jLabel2.setLabelFor(this.findTextField);
        controlBar.add((Component)this.findTextField);
        JButton jButton2 = new JButton(OLAPDVArb.get("GO_LABEL"));
        jButton2.setMnemonic(71);
        controlBar.add((Component)jButton2);
        controlBar.add((Component)new JLabel("          "));
        controlBar.add((Component)jButton);
        controlBar.add((Component)new JLabel("   "));
        controlBar.add((Component)this.refreshButton);
        componentWithTitlebar.setControlBar(controlBar);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ++gridBagConstraints.gridy;
        componentWithTitlebar.setComponent((JComponent)this.drillResultSetTableScrollPane);
        this.add((Component)componentWithTitlebar, gridBagConstraints);
        this.resolvePanel = new ValidateDrillResolvePanel(this, this.levelDO, this.activeReport);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.resolvePanel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.sqlTextArea = new JTextArea(25, 1);
        this.sqlTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.sqlTextArea);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        if (this.shouldSQLTextAreaBeVisible()) {
            this.add((Component)jPanel, gridBagConstraints);
        }
        String string4 = this.getSQLQueryText();
        this.sqlTextArea.setText(string4);
        if (string4 != null && string4.length() > 0) {
            this.sqlTextArea.setCaretPosition(1);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        this.populateButtonMenu();
        this.helpButton = new JButton(StringUtils.stripMnemonic((String)OLAPDVArb.getString("HELP_BUTTON")));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPDVArb.getString("HELP_BUTTON")));
        this.exportButton = ButtonMenu.createButtonMenu((String)OLAPDVArb.getString("EXPORT_BUTTON"), null, this.items);
        this.exportButton.setMnemonic(88);
        JButton jButton3 = new JButton(OLAPDVArb.getString("CLOSE_BUTTON"));
        jButton3.setMnemonic(76);
        this.enableExportButton();
        switch (this.activeReport) {
            case 1: {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olapdv_details_distinct_mem");
                break;
            }
            case 2: {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olapdv_details_distinct_mem_descr");
                break;
            }
            case 3: {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olapdv_details_dup_mem");
                break;
            }
            case 4: {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olapdv_details_rows_null_mem");
                break;
            }
            case 5: {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olapdv_details_mem_null_descr");
                break;
            }
            case 6: {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olapdv_details_mem_mult_descr");
                break;
            }
            case 7: {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olapdv_details_descr_mult_mem");
                break;
            }
            case 8: {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olapdv_details_mem_mult_parent");
                break;
            }
            case 9: {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olapdv_details_descr_mult_parent_descr");
            }
        }
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidateDrillPanel.this.showHelp();
            }
        };
        ActionMap actionMap = this.m_drillDialog.getRootPane().getActionMap();
        InputMap inputMap = this.m_drillDialog.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("F1"), "help");
        actionMap.put("help", abstractAction);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)new JLabel("     "), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)new JLabel("     "), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 3;
        jPanel3.add((Component)this.exportButton, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel3.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel3, gridBagConstraints);
        this.drillResultSetTable.getSelectionModel().addListSelectionListener(this);
        this.drillResultSetTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
        if (this.drillResultSetTable.getRowCount() > 0) {
            try {
                this.drillResultSetTable.addRowSelectionInterval(0, 0);
            }
            catch (Exception exception) {
                System.out.println("Exception is " + exception);
            }
            this.lastRow = 0;
            this.lastColumn = 0;
            this.resolvePanel.enableRadioButtons(true);
        } else {
            this.lastRow = -1;
            this.lastColumn = -1;
            this.resolvePanel.enableRadioButtons(false);
            this.sqlTextArea.setText("");
            this.exportButton.setEnabled(false);
        }
        this.setFirstRowSelected();
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidateDrillPanel.this.doFindInTable();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidateDrillPanel.this.showHelp();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidateDrillPanel.this.refreshTableData();
                ValidateDrillPanel.this.setFirstRowSelected();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidateDrillPanel.this.processCloseDialog();
                ValidateDrillPanel.this.m_drillDialog.removeValidateDrillDialogFromList();
                ValidateDrillPanel.this.m_drillDialog.dispose();
                ValidateDrillPanel.this.m_drillDialog = null;
                ValidatePanel validatePanel = ValidateDrillPanel.this.validateViewer.getValidatePanel();
                validatePanel.setCurrentRowFocused();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
                String string = null;
                StringBuffer stringBuffer = new StringBuffer();
                switch (ValidateDrillPanel.this.activeReport) {
                    case 1: {
                        stringBuffer.append("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_MEMBERS", ValidateDrillPanel.this.levelDO.getName(), ValidateDrillPanel.this.levelDO.getOwningDimensionName(), ValidateDrillPanel.this.levelDO.getOwningHierarchyName()));
                        stringBuffer.append("\n");
                        stringBuffer.append(validateQuerySQL.getSQLForDrillOnDistinctMembersAndDescriptions(ValidateDrillPanel.this.levelDO));
                        string = stringBuffer.toString();
                        break;
                    }
                    case 2: {
                        stringBuffer.append("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_DISTINCT_MEMBERS_AND_DESCRIPTIONS", ValidateDrillPanel.this.levelDO.getName(), ValidateDrillPanel.this.levelDO.getOwningDimensionName(), ValidateDrillPanel.this.levelDO.getOwningHierarchyName()));
                        stringBuffer.append("\n");
                        stringBuffer.append(validateQuerySQL.getSQLForDrillOnDistinctMembersAndDescriptions(ValidateDrillPanel.this.levelDO));
                        string = stringBuffer.toString();
                        break;
                    }
                    case 3: {
                        stringBuffer.append("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_DUPLICATE_MEMBERS_ACROSS_LEVELS", ValidateDrillPanel.this.levelDO.getName(), ValidateDrillPanel.this.levelDO.getOwningDimensionName(), ValidateDrillPanel.this.levelDO.getOwningHierarchyName()));
                        stringBuffer.append("\n");
                        stringBuffer.append(validateQuerySQL.getSQLForDrillOnNonUniqueMembersAcrossLevel(ValidateDrillPanel.this.levelDO));
                        string = stringBuffer.toString();
                        break;
                    }
                    case 4: {
                        stringBuffer.append("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_NULL_MEMBER_ROWS", ValidateDrillPanel.this.levelDO.getName(), ValidateDrillPanel.this.levelDO.getOwningDimensionName(), ValidateDrillPanel.this.levelDO.getOwningHierarchyName()));
                        stringBuffer.append("\n");
                        stringBuffer.append(validateQuerySQL.getSQLForDrillOnMembersWithNullRows(ValidateDrillPanel.this.levelDO));
                        string = stringBuffer.toString();
                        break;
                    }
                    case 5: {
                        stringBuffer.append("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_NULL_DESCRIPTIONS", ValidateDrillPanel.this.levelDO.getName(), ValidateDrillPanel.this.levelDO.getOwningDimensionName(), ValidateDrillPanel.this.levelDO.getOwningHierarchyName()));
                        stringBuffer.append("\n");
                        stringBuffer.append(validateQuerySQL.getSQLForDrillOnMembersWithNullDescriptions(ValidateDrillPanel.this.levelDO));
                        string = stringBuffer.toString();
                        break;
                    }
                    case 6: {
                        stringBuffer.append("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_MEMBERS_WITH_MULTIPLE_DESCRIPTION", ValidateDrillPanel.this.levelDO.getName(), ValidateDrillPanel.this.levelDO.getOwningDimensionName(), ValidateDrillPanel.this.levelDO.getOwningHierarchyName()));
                        stringBuffer.append("\n");
                        stringBuffer.append(validateQuerySQL.getSQLForDrillOnMembersWithMultipleDescriptions(ValidateDrillPanel.this.levelDO));
                        string = stringBuffer.toString();
                        break;
                    }
                    case 7: {
                        stringBuffer.append("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_DESCRIPTIONS_WITH_MULTIPLE_MEMBERS", ValidateDrillPanel.this.levelDO.getName(), ValidateDrillPanel.this.levelDO.getOwningDimensionName(), ValidateDrillPanel.this.levelDO.getOwningHierarchyName()));
                        stringBuffer.append("\n");
                        stringBuffer.append(validateQuerySQL.getSQLForDrillOnDescriptionsAssignedToMultipleMembers(ValidateDrillPanel.this.levelDO));
                        string = stringBuffer.toString();
                        break;
                    }
                    case 8: {
                        stringBuffer.append("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_MEMBERS_WITH_MULTIPLE_PARENTS", ValidateDrillPanel.this.levelDO.getName(), ValidateDrillPanel.this.levelDO.getOwningDimensionName(), ValidateDrillPanel.this.levelDO.getOwningHierarchyName()));
                        stringBuffer.append("\n");
                        stringBuffer.append(validateQuerySQL.getSQLForDrillOnMembersWithMultipleParents(ValidateDrillPanel.this.levelDO));
                        string = stringBuffer.toString();
                        break;
                    }
                    case 9: {
                        stringBuffer.append("REM *** " + OLAPDVArb.format("DRILL_QUERY_FOR_DESCRIPTIONS_WITH_MULTIPLE_PARENT_DESCRIPTIONS", ValidateDrillPanel.this.levelDO.getName(), ValidateDrillPanel.this.levelDO.getOwningDimensionName(), ValidateDrillPanel.this.levelDO.getOwningHierarchyName()));
                        stringBuffer.append("\n");
                        stringBuffer.append(validateQuerySQL.getSQLForDrillOnDescriptionsWithMultipleParentDescs(ValidateDrillPanel.this.levelDO));
                        string = stringBuffer.toString();
                    }
                }
                string = MiscUtils.stripCarriageReturnCharacters(string);
                ViewLogDialog viewLogDialog = null;
                viewLogDialog = new ViewLogDialog(ValidateDrillPanel.this.m_drillDialog, OLAPDVArb.format("DRILL_TO_DETAIL_SQL_FOR_LEVEL", ValidateDrillPanel.this.levelDO.getName()), string);
                Rectangle rectangle = MiscUtils.centerWindow(ValidateDrillPanel.this.m_drillDialog, 600, 500);
                viewLogDialog.setBounds(rectangle);
                viewLogDialog.setModal(true);
                viewLogDialog.setVisible(true);
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    ValidateDrillPanel.this.doFindInTable();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };
        this.findTextField.addKeyListener(keyAdapter);
    }

    protected void processCloseDialog() {
        this.doneUpdate = false;
        if (this.lastTimeTableUpdated != null && this.lastTimeTableUpdated.length() > 0 && !this.lastTimeTableUpdated.equals(this.getLastTimeTableUpdated())) {
            this.doneUpdate = true;
        }
        if (this.doneUpdate) {
            this.setCursor(new Cursor(3));
            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
            int n = validateTopDO.getFilter();
            validateTopDO.setFilter(2);
            this.validateViewer.getValidatePanel().runValidationOnAllReports(this.levelDO.getDimensionDO().getName(), true, null);
            this.validateViewer.getValidateMessagePanel().refreshMessageData(this.activeReport);
            validateTopDO.setFilter(n);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.drillResultSetTable.closeModel();
    }

    private void enableExportButton() {
        if (this.activeReport == 1 || this.activeReport == 2 || this.activeReport == 3) {
            this.exportButton.setEnabled(false);
        } else {
            this.exportButton.setEnabled(true);
        }
    }

    public void setFirstRowSelected() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.WARNING, "In method setFirstRowSelected, Interruption exception occurred.");
                }
                if (ValidateDrillPanel.this.drillResultSetTable.getRowCount() > 0) {
                    ValidateDrillPanel.this.drillResultSetTable.changeSelection(0, 0, false, false);
                    ValidateDrillPanel.this.lastRow = 0;
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ((string.equalsIgnoreCase("EXPORT_TO_WORKSHEET") || string.equalsIgnoreCase("EXPORT_TO_CLIPBOARD")) && (this.activeReport == 5 || this.activeReport == 4 || this.activeReport == 6 || this.activeReport == 8 || this.activeReport == 7 || this.activeReport == 9)) {
            String string2 = this.getSQLQueryText();
            StringBuffer stringBuffer = new StringBuffer();
            ValidateLogger validateLogger = ValidateLogger.getInstance();
            LogWriter logWriter = validateLogger.getLogWriter(this.validateModelDO.getName());
            ValidatePanel validatePanel = this.validateViewer.getValidatePanel();
            String string3 = validatePanel.getDrillToDetailDialogTitle();
            if (string.equalsIgnoreCase("EXPORT_TO_WORKSHEET")) {
                logWriter.write(OLAPDVArb.getString("EXPORT_TO_WORKSHEET_LOG_MSG"));
            } else {
                logWriter.write(OLAPDVArb.getString("EXPORT_TO_CLIPBOARD_LOG_MSG"));
            }
            logWriter.write(OLAPDVArb.format("LOG_FILE_EXPORT_DETAIL_MSG", string3));
            logWriter.write(string2 + ";");
            stringBuffer.append(OLAPDVArb.format("LOG_FILE_EXPORT_DETAIL_MSG", string3));
            stringBuffer.append("\n");
            stringBuffer.append(string2 + ";");
            if (string.equalsIgnoreCase("EXPORT_TO_WORKSHEET")) {
                Connection connection = ConnectionManager.getInstance().getMainConnection();
                RaptorDBAddin.getSqlOpener().openNewEditor(stringBuffer.toString(), Connections.getInstance().getConnectionName(connection));
            } else {
                ClipboardCopy clipboardCopy = new ClipboardCopy(stringBuffer.toString());
                clipboardCopy.copyToClipboard();
            }
        }
    }

    private void populateButtonMenu() {
        this.items = new ArrayList<JMenuItem>();
        JMenuItem jMenuItem = new JMenuItem(OLAPDVArb.getString("EXPORT_TO_WORKSHEET_MENU_LABEL"));
        jMenuItem.setActionCommand("EXPORT_TO_WORKSHEET");
        jMenuItem.addActionListener(this);
        this.items.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(OLAPDVArb.getString("EXPORT_TO_CLIPBOARD_MENU_LABEL"));
        jMenuItem2.setActionCommand("EXPORT_TO_CLIPBOARD");
        jMenuItem2.addActionListener(this);
        this.items.add(jMenuItem2);
    }

    private void doFindInTable() {
        String string = this.findTextField.getText();
        if (string != null && string.length() > 0) {
            int n = this.drillResultSetTable.getRowCount();
            int n2 = this.drillResultSetTable.getColumnCount();
            String string2 = null;
            int n3 = 0;
            if (this.lastSearchString != null && this.lastSearchString.equals(string)) {
                if (this.continueSearchFlag && n > this.startRowForSearch) {
                    n3 = this.startRowForSearch;
                }
            } else {
                this.continueSearchFlag = false;
            }
            this.setCursor(new Cursor(3));
            for (int i = n3; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    string2 = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(i, j));
                    if (string2 == null) continue;
                    if (string2.equalsIgnoreCase(string)) {
                        this.drillResultSetTable.setRowSelectionInterval(i, i);
                        Rectangle rectangle = this.drillResultSetTable.getCellRect(i, j, false);
                        if (rectangle != null) {
                            this.drillResultSetTable.scrollRectToVisible(rectangle);
                        }
                        this.setCursor(Cursor.getDefaultCursor());
                        this.lastSearchString = string;
                        this.continueSearchFlag = true;
                        this.startRowForSearch = i + 1;
                        return;
                    }
                    if (string2.indexOf(string) < 0) continue;
                    this.drillResultSetTable.setRowSelectionInterval(i, i);
                    Rectangle rectangle = this.drillResultSetTable.getCellRect(i, j, false);
                    if (rectangle != null) {
                        this.drillResultSetTable.scrollRectToVisible(rectangle);
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    this.lastSearchString = string;
                    this.continueSearchFlag = true;
                    this.startRowForSearch = i + 1;
                    return;
                }
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (this.continueSearchFlag) {
                JOptionPane.showMessageDialog(this.m_drillDialog, OLAPDVArb.format("NO_MORE_OCCURRENCES_FOUND_MSG", string));
            } else {
                JOptionPane.showMessageDialog(this.m_drillDialog, OLAPDVArb.format("NOT_FOUND_MSG", string));
            }
            this.continueSearchFlag = false;
            this.startRowForSearch = 0;
            if (this.drillResultSetTable.getRowCount() > 0) {
                this.drillResultSetTable.changeSelection(0, 0, false, false);
            }
            this.setFindTextFieldFocus();
        }
    }

    public void setFindTextFieldFocus() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.WARNING, "In method setFindTextFieldFocus, Sleep thread interrupted");
                }
                ValidateDrillPanel.this.findTextField.requestFocusInWindow();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void refreshTableData() {
        this.runnableRefresh();
    }

    private void runnableRefresh() {
        this.progressStatusDialog = new ProgressStatusDialog(this.m_drillDialog, OLAPDVArb.get("REFRESH_TABLE_PROGRESS_MSG"), OLAPDVArb.get("REFRESH_TABLE_PROGRESS_MSG"), true);
        this.progressStatusDialog.setIsIndeterminateToTrue();
        this.progressStatusDialog.addObserver(this);
        this.clearInterrupted();
        this.progressStatusDialog.initializeDialogPanel();
        this.progressStatusDialog.setModal(true);
        Rectangle rectangle = MiscUtils.centerWindow(this.m_drillDialog, 550, 200);
        this.progressStatusDialog.setBounds(rectangle);
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                try {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ValidateDrillPanel.this.drillResultSetTable.refresh();
                                ValidateDrillPanel.this.drillResultSetTable.allRowsFetched();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    SwingUtilities.invokeAndWait(runnable);
                    if (ValidateDrillPanel.this.getInterruptedStatus()) {
                        return null;
                    }
                    return "Finished";
                }
                catch (Exception exception) {
                    return exception;
                }
            }

            @Override
            public void finished() {
                ValidateDrillPanel.this.isDisposed = true;
                ValidateDrillPanel.this.progressStatusDialog.dispose();
            }
        };
        this.isDisposed = false;
        this.progressStatusDialog.setWorkerThread(swingWorker);
        swingWorker.start();
        try {
            if (!this.isDisposed) {
                this.progressStatusDialog.setVisible(true);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "In method RunnableRefresh, Interrupted Exception occurred", exception);
        }
        if (swingWorker.getValue() == null) {
            QueryManager queryManager = new QueryManager();
            queryManager.getCurrentServerDateTime();
            return;
        }
        if (swingWorker.getValue() instanceof SQLException) {
            LOG.log(Level.SEVERE, "In method RunnableRefresh worker thread returns SQL Exception error: " + swingWorker.getValue());
            return;
        }
        boolean bl = false;
        if (this.drillResultSetTable.getRowCount() == 0) {
            bl = true;
        }
        this.drillResultSetTable.setSelectionMode(0);
        this.drillResultSetTableScrollPane.invalidate();
        this.drillResultSetTableScrollPane.repaint();
        this.drillResultSetTableScrollPane.setViewportView(null);
        this.drillResultSetTableScrollPane.setViewportView((Component)this.drillResultSetTable);
        this.drillResultSetTableScrollPane.invalidate();
        this.drillResultSetTableScrollPane.repaint();
        this.drillResultSetTable.invalidate();
        this.drillResultSetTable.repaint();
        if (!bl) {
            if (this.drillResultSetTable.getRowCount() > 0) {
                this.drillResultSetTable.changeSelection(0, 0, false, false);
            }
            this.lastRow = 0;
            this.lastColumn = 0;
            this.resolvePanel.enableRadioButtons(true);
            this.enableExportButton();
        } else {
            this.lastRow = -1;
            this.lastColumn = -1;
            this.resolvePanel.enableRadioButtons(false);
            this.sqlTextArea.setText("");
            this.exportButton.setEnabled(false);
        }
    }

    private boolean shouldSQLTextAreaBeVisible() {
        boolean bl = true;
        if (this.activeReport == 1 || this.activeReport == 2 || this.activeReport == 3) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.drillResultSetTable.getSelectedRow();
        int n2 = this.drillResultSetTable.getSelectedColumn();
        if (n == this.lastRow && n2 == this.lastColumn) {
            return;
        }
        if (n < 0) {
            return;
        }
        this.lastRow = n;
        this.lastColumn = n2;
        this.updateRadioButtonLabelText();
        this.updateSQLQueryText();
        if (this.lastRow >= 0) {
            this.resolvePanel.enableRadioButtons(true);
        }
    }

    protected void updateRadioButtonLabelText() {
        if (this.drillResultSetTable.getRowCount() == 0) {
            return;
        }
        if (this.activeReport == 6 || this.activeReport == 8 || this.activeReport == 9) {
            JRadioButton jRadioButton = this.resolvePanel.getMemberSelectedRadioButton();
            if (this.activeReport == 6) {
                String string = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 0));
                String string2 = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 1));
                LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
                String string3 = levelMapDO.getColumnName();
                String string4 = levelMapDO.getLongDescriptionColumnName();
                String string5 = levelMapDO.getColumnDataType();
                String string6 = string5.startsWith("VARCHAR") || string5.startsWith("NVARCHAR") || string5.startsWith("CHAR") || string5.startsWith("NCHAR") ? "SET " + string4 + " = '" + string2 + "' WHERE " + string3 + " = '" + string + "'" : "SET " + string4 + " = '" + string2 + "' WHERE " + string3 + " = " + string;
                jRadioButton.setText(OLAPDVArb.format("SET_DESCRIPTION_LABEL", string6));
            } else if (this.activeReport == 8) {
                String string = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 0));
                String string7 = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 1));
                String string8 = null;
                boolean bl = false;
                LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
                String string9 = levelMapDO.getColumnName();
                String string10 = levelMapDO.getParentColumnName();
                String string11 = levelMapDO.getTableName();
                String string12 = " ";
                String string13 = levelMapDO.getColumnDataType();
                if (string13.startsWith("VARCHAR") || string13.startsWith("NVARCHAR") || string13.startsWith("CHAR") || string13.startsWith("NCHAR")) {
                    string12 = "'";
                }
                LevelDO levelDO = this.levelDO.getParentLevelDO();
                LevelMapDO levelMapDO2 = levelDO.getLevelMapDO();
                string13 = levelMapDO2.getColumnDataType();
                String string14 = " ";
                if (string13.startsWith("VARCHAR") || string13.startsWith("NVARCHAR") || string13.startsWith("CHAR") || string13.startsWith("NCHAR")) {
                    string14 = "'";
                }
                levelMapDO2 = levelDO.getLevelMapDO();
                String string15 = levelMapDO2.getTableName();
                String string16 = levelMapDO2.getColumnName();
                String string17 = levelMapDO2.getLongDescriptionColumnName();
                if (!string11.equalsIgnoreCase(string15)) {
                    bl = true;
                }
                if (!bl) {
                    string8 = string14.equalsIgnoreCase("'") ? "SET " + string16 + " = " + string14 + string7 + string14 + " WHERE " : "SET " + string16 + " = " + string7 + " WHERE ";
                    string8 = string12.equalsIgnoreCase("'") ? string8 + string9 + " = " + string12 + string + string12 : string8 + string9 + " = " + string;
                } else {
                    string8 = string14.equalsIgnoreCase("'") ? "SET " + string10 + " = " + string14 + string7 + string14 + " WHERE " : "SET " + string10 + " = " + string7 + " WHERE ";
                    string8 = string12.equalsIgnoreCase("'") ? string8 + string9 + " = " + string12 + string + string12 : string8 + string9 + " = " + string;
                }
                jRadioButton.setText(OLAPDVArb.format("UPDATE_PARENT_MEMBER_LABEL", string8));
            } else if (this.activeReport == 9) {
                String string = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 0));
                String string18 = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 1));
                LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
                String string19 = levelMapDO.getOwner();
                String string20 = levelMapDO.getTableName();
                String string21 = levelMapDO.getLongDescriptionColumnName();
                LevelDO levelDO = this.levelDO.getParentLevelDO();
                LevelMapDO levelMapDO3 = levelDO.getLevelMapDO();
                String string22 = levelMapDO3.getLongDescriptionColumnName();
                String string23 = "SET " + string22 + " = '" + string18 + "' WHERE " + string21 + " = '" + string + "'";
                jRadioButton.setText(OLAPDVArb.format("UPDATE_PARENT_DESCRIPTION_LABEL", string23));
            }
        }
    }

    protected void updateSQLQueryText() {
        String string = this.getSQLQueryText();
        this.sqlTextArea.setText(string);
        if (this.sqlTextArea.getText().length() > 0) {
            this.sqlTextArea.setCaretPosition(1);
        }
    }

    private String getSQLQueryText() {
        Object object = null;
        int n = this.resolvePanel.getCurrentRadioSelection();
        ValidateQuerySQL validateQuerySQL = new ValidateQuerySQL();
        if (this.activeReport == 5) {
            String string = this.resolvePanel.getConcatenationString();
            String string2 = this.resolvePanel.getPrefixString();
            object = validateQuerySQL.getSQLTextForAppendFixForMembersWithNullDescriptions(this.levelDO, string2, string);
        } else if (this.activeReport == 4) {
            object = n == 4 ? validateQuerySQL.getSQLTextForNullMembers(this.levelDO) : validateQuerySQL.getSQLTextForNullMembersByDescription(this.levelDO);
        } else if (this.activeReport == 6) {
            if (n == 1) {
                object = validateQuerySQL.getSQLTextForMembersWithMultipleDescriptions(this.levelDO);
            } else {
                String string = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 0));
                String string3 = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 1));
                object = validateQuerySQL.getSQLTextForMemberFixForMembersWithMultipleDescriptions(this.levelDO, string, string3);
            }
        } else if (this.activeReport == 7) {
            if (n == 6) {
                String string = this.resolvePanel.getConcatenationString();
                String string4 = null;
                LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
                int n2 = levelMapDO.getDescColumnDataTypeLength();
                if (n2 < this.alterTableSize + string.length()) {
                    String string5 = levelMapDO.getOwner();
                    String string6 = levelMapDO.getTableName();
                    String string7 = levelMapDO.getLongDescriptionColumnName();
                    int n3 = string != null && string.length() > 0 ? this.alterTableSize + string.length() + 10 : this.alterTableSize + 1 + 10;
                    String string8 = levelMapDO.getLongDescDataType();
                    if (string8.startsWith("VARCHAR")) {
                        string4 = "ALTER TABLE " + string5 + "." + string6 + " MODIFY(" + string7 + " VARCHAR2(" + n3 + "));\n";
                    } else if (string8.startsWith("NVARCHAR")) {
                        string4 = "ALTER TABLE " + string5 + "." + string6 + " MODIFY(" + string7 + " NVARCHAR2(" + n3 + "));\n";
                    }
                }
                object = string4 != null ? string4 + validateQuerySQL.getSQLTextForDescriptionsWithMultipleMembers(this.levelDO, string) : validateQuerySQL.getSQLTextForDescriptionsWithMultipleMembers(this.levelDO, string);
            } else if (n == 3) {
                String string = this.resolvePanel.getConcatenationString();
                String string9 = null;
                LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
                int n4 = levelMapDO.getDescColumnDataTypeLength();
                if (n4 < this.alterTableSize2 + string.length()) {
                    String string10 = levelMapDO.getOwner();
                    String string11 = levelMapDO.getTableName();
                    String string12 = levelMapDO.getLongDescriptionColumnName();
                    int n5 = string != null && string.length() > 0 ? this.alterTableSize2 + string.length() + 10 : this.alterTableSize2 + 1 + 10;
                    String string13 = levelMapDO.getLongDescDataType();
                    if (string13.startsWith("VARCHAR")) {
                        string9 = "ALTER TABLE " + string10 + "." + string11 + " MODIFY(" + string12 + " VARCHAR2(" + n5 + "));\n";
                    } else if (string13.startsWith("NVARCHAR")) {
                        string9 = "ALTER TABLE " + string10 + "." + string11 + " MODIFY(" + string12 + " NVARCHAR2(" + n5 + "));\n";
                    }
                }
                object = string9 != null ? string9 + validateQuerySQL.getSQLTextForConcatFixForDescriptionsWithMultipleMembers(this.levelDO, string) : validateQuerySQL.getSQLTextForConcatFixForDescriptionsWithMultipleMembers(this.levelDO, string);
            } else if (n == 7) {
                object = validateQuerySQL.getSQLTextForMostCommonFixForDescriptionsWithMultipleMembers(this.levelDO);
            }
        } else if (this.activeReport == 8) {
            if (n == 1) {
                object = validateQuerySQL.getSQLTextForMembersWithMultipleParents(this.parentLevelDO, this.levelDO);
            } else if (n == 2) {
                if (this.lastRow >= 0) {
                    String string = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 0));
                    String string14 = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 1));
                    String string15 = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 3));
                    object = validateQuerySQL.getSQLTextForMemberFixForMembersWithMultipleParents(this.parentLevelDO, this.levelDO, string, string14, string15);
                }
            } else if (n == 3) {
                String string = null;
                LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
                String string16 = levelMapDO.getColumnDataType();
                if (string16.startsWith("VARCHAR") || string16.startsWith("NVARCHAR")) {
                    String string17 = this.resolvePanel.getConcatenationString();
                    int n6 = levelMapDO.getColumnDataTypeLength();
                    if (n6 < this.alterTableSize + string17.length()) {
                        String string18 = levelMapDO.getOwner();
                        String string19 = levelMapDO.getTableName();
                        String string20 = levelMapDO.getColumnName();
                        int n7 = string17 != null && string17.length() > 0 ? this.alterTableSize + string17.length() + 10 : this.alterTableSize + 1 + 10;
                        string = string16.startsWith("VARCHAR2") ? "ALTER TABLE " + string18 + "." + string19 + " MODIFY(" + string20 + " VARCHAR2(" + n7 + "));\n" : "ALTER TABLE " + string18 + "." + string19 + " MODIFY(" + string20 + " NVARCHAR2(" + n7 + "));\n";
                    }
                }
                object = string != null ? string + validateQuerySQL.getSQLTextForConcatFixForMembersWithMultipleParents(this.parentLevelDO, this.levelDO, this.resolvePanel.getConcatenationString()) : validateQuerySQL.getSQLTextForConcatFixForMembersWithMultipleParents(this.parentLevelDO, this.levelDO, this.resolvePanel.getConcatenationString());
            }
        } else if (this.activeReport == 9) {
            if (n == 1) {
                object = validateQuerySQL.getSQLTextForDescriptionsWithMultipleParentDescriptions(this.parentLevelDO, this.levelDO);
            } else if (n == 2) {
                String string = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 0));
                String string21 = this.getTableCellValueAsString(this.drillResultSetTable.getValueAt(this.lastRow, 1));
                object = validateQuerySQL.getSQLTextForMemberFixForDescriptionsWithMultipleParentDescriptions(this.parentLevelDO, this.levelDO, string21, string);
            } else if (n == 3) {
                String string = this.resolvePanel.getConcatenationString();
                String string22 = null;
                LevelMapDO levelMapDO = this.levelDO.getLevelMapDO();
                int n8 = levelMapDO.getDescColumnDataTypeLength();
                if (n8 < this.alterTableSize + string.length()) {
                    String string23 = levelMapDO.getOwner();
                    String string24 = levelMapDO.getTableName();
                    String string25 = levelMapDO.getLongDescriptionColumnName();
                    int n9 = string != null && string.length() > 0 ? this.alterTableSize + string.length() + 10 : this.alterTableSize + 1 + 10;
                    String string26 = levelMapDO.getLongDescDataType();
                    if (string26.startsWith("VARCHAR")) {
                        string22 = "ALTER TABLE " + string23 + "." + string24 + " MODIFY(" + string25 + " VARCHAR2(" + n9 + "));\n";
                    } else if (string26.startsWith("NVARCHAR")) {
                        string22 = "ALTER TABLE " + string23 + "." + string24 + " MODIFY(" + string25 + " NVARCHAR2(" + n9 + "));\n";
                    }
                }
                object = string22 != null ? string22 + validateQuerySQL.getSQLTextForConcatFixForDescriptionsWithMultipleParentDescriptions(this.levelDO, string) : validateQuerySQL.getSQLTextForConcatFixForDescriptionsWithMultipleParentDescriptions(this.levelDO, string);
            }
        }
        object = MiscUtils.stripCarriageReturnCharacters((String)object);
        return object;
    }

    private String getTableCellValueAsString(Object object) {
        String string = null;
        if (object instanceof CHAR) {
            CHAR cHAR = (CHAR)object;
            string = cHAR.stringValue();
        } else if (object instanceof NUMBER) {
            NUMBER nUMBER = (NUMBER)object;
            string = nUMBER.stringValue();
        } else if (object instanceof DATE) {
            DATE dATE = (DATE)object;
            string = dATE.stringValue();
        } else if (object instanceof String) {
            string = (String)object;
        }
        return string;
    }

    private void showHelp() {
        HelpSystem.getHelpSystem().showHelp((JComponent)this);
    }

    protected static class ClipboardCopy {
        private String sqlToShow;

        public ClipboardCopy(String string) {
            this.sqlToShow = string;
        }

        public void copyToClipboard() {
            Transferable transferable = new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.stringFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                    return dataFlavor == DataFlavor.stringFlavor || dataFlavor == DataFlavor.plainTextFlavor;
                }

                @Override
                public Object getTransferData(DataFlavor dataFlavor) {
                    return sqlToShow;
                }
            };
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
        }
    }
}

