/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.OLAPDVImagesArb;
import oracle.olapdv.app.LaunchStatus;
import oracle.olapdv.app.ProgressStatusDialog;
import oracle.olapdv.app.ProgressStatusPanel;
import oracle.olapdv.app.Tree;
import oracle.olapdv.app.TreeSelection;
import oracle.olapdv.app.ValidateTreeModelListener;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.olap.model.AWDO;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;
import oracle.olapdv.olap.provider.AwProvider;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.reader.ModelReader;
import oracle.olapdv.util.MiscUtils;
import oracle.olapdv.writer.CreateSchemaObjects;
import oracle.olapdv.writer.ModelWriter;

public class TreePanel
extends JPanel
implements TreeSelectionListener,
ActionListener {
    private static final Logger LOG = Logger.getLogger(TreePanel.class.getName());
    Action showMenuAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TreePanel.this.showMenu();
        }
    };
    private Tree m_tree;
    private DefaultTreeModel m_treeModel;
    private DefaultMutableTreeNode m_top;
    private TreeSelection m_treeSelection;
    private ValidateTopDO m_validateTopDO;
    private DefaultMutableTreeNode m_currentTreeNode;
    private DefaultMutableTreeNode m_rightClickTreeNode;
    private String m_owner;
    private String m_modelName;
    private Component m_parentComponent;
    private ProgressStatusDialog m_progressStatusDialog;
    private ActionMap m_actionMap = null;
    private InputMap m_inputMap = null;
    private ImageIcon m_modelNodeImage = null;
    private ImageIcon m_reportNodeImage = null;
    private static final int MODEL_MENU = 1;
    private static final int VALIDATE_MENU = 2;
    private static final int ROOT_MENU = 3;
    public String ALL_MESSAGE_REPORT = OLAPDVArb.format("ALL_MESSAGE_REPORT", "ModelName");
    public static final String METADATA_AND_MAPPING_REPORT = OLAPDVArb.get("METADATA_AND_MAPPING_REPORT");
    public static final String MEMBER_COUNT_REPORT = OLAPDVArb.get("MEMBER_COUNT_REPORT");
    public static final String DISTINCT_DESCRIPTION_REPORT = OLAPDVArb.get("DISTINCT_DESCRIPTION_REPORT");
    public static final String NONUNIQUE_MEMBERS_ACROSS_LEVEL = OLAPDVArb.get("NONUNIQUE_MEMBERS_ACROSS_LEVEL");
    public static final String NULL_MEMBER_REPORT = OLAPDVArb.get("NULL_MEMBER_REPORT");
    public static final String NULL_DESCRIPTION_REPORT = OLAPDVArb.get("NULL_DESCRIPTION_REPORT");
    public static final String MEMBERS_MULTIPLE_DESCRIPTION_REPORT = OLAPDVArb.get("MEMBERS_MULTIPLE_DESCRIPTION_REPORT");
    public static final String DESCRIPTIONS_WITH_MULTIPLE_MEMBER_REPORT = OLAPDVArb.get("DESCRIPTIONS_WITH_MULTIPLE_MEMBER_REPORT");
    public static final String MEMBERS_WITH_MULTIPLE_PARENTS_REPORT = OLAPDVArb.get("MEMBERS_WITH_MULTIPLE_PARENTS_REPORT");
    public static final String DESCRIPTIONS_WITH_PARENTS_WITH_MULTIPLE_DESCRIPTION_REPORT = OLAPDVArb.get("DESCRIPTIONS_WITH_PARENTS_WITH_MULTIPLE_DESCRIPTION_REPORT");

    public TreePanel(ValidateTopDO validateTopDO, Component component, String string) {
        this.m_validateTopDO = validateTopDO;
        this.m_parentComponent = component;
        this.jbinit(string);
    }

    protected void setOwner(String string) {
        this.m_owner = string;
        this.m_treeSelection.setOwner(string);
    }

    protected void setModelName(String string) {
        this.m_modelName = string;
        this.m_treeSelection.setModelName(string);
    }

    protected void setTreeSelection(TreeSelection treeSelection) {
        this.m_treeSelection = treeSelection;
    }

    public void setValidateTopDO(ValidateTopDO validateTopDO) {
        this.m_validateTopDO = validateTopDO;
    }

    protected void jbinit(String string) {
        this.m_modelNodeImage = new ImageIcon(OLAPDVImagesArb.getImage("BUSINESS_MODEL_ICON"));
        this.m_reportNodeImage = new ImageIcon(OLAPDVImagesArb.getImage("REPORT_NODE_ICON"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        this.setLayout(new GridBagLayout());
        DefaultMutableTreeNode defaultMutableTreeNode = this.initializeTree();
        this.m_treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.m_treeModel.addTreeModelListener(new ValidateTreeModelListener());
        this.m_tree = new Tree(this.m_treeModel);
        this.m_tree.setRootVisible(false);
        MyTreeCellRenderer myTreeCellRenderer = new MyTreeCellRenderer();
        this.m_tree.setCellRenderer(myTreeCellRenderer);
        this.autoSelectFirstTreeNode();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.m_tree, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.m_tree.getSelectionModel().setSelectionMode(4);
        this.m_tree.addTreeSelectionListener(this);
        this.setBackground(Color.WHITE);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = TreePanel.this.m_tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = TreePanel.this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    JPopupMenu jPopupMenu = null;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    if (n != -1 && mouseEvent.getClickCount() == 1 && (mouseEvent.getModifiers() & 4) > 0) {
                        TreePanel.this.m_rightClickTreeNode = defaultMutableTreeNode;
                        if (defaultMutableTreeNode.getDepth() == 0) {
                            String string = (String)TreePanel.this.m_rightClickTreeNode.getUserObject();
                            jPopupMenu = string.equalsIgnoreCase(METADATA_AND_MAPPING_REPORT) ? TreePanel.this.getPopupMenu(1) : TreePanel.this.getPopupMenu(2);
                            Point point = mouseEvent.getPoint();
                            point.translate(TreePanel.this.getX(), TreePanel.this.getY());
                            Point point2 = TreePanel.getSuitableLocation(point, jPopupMenu.getPreferredSize(), mouseEvent.getComponent());
                            if (jPopupMenu != null) {
                                jPopupMenu.show(mouseEvent.getComponent(), point2.x, point2.y);
                            }
                        } else if (defaultMutableTreeNode.getDepth() == 1) {
                            jPopupMenu = TreePanel.this.getPopupMenu(2);
                            Point point = mouseEvent.getPoint();
                            point.translate(TreePanel.this.getX(), TreePanel.this.getY());
                            Point point3 = TreePanel.getSuitableLocation(point, jPopupMenu.getPreferredSize(), mouseEvent.getComponent());
                            if (jPopupMenu != null) {
                                jPopupMenu.show(mouseEvent.getComponent(), point3.x, point3.y);
                            }
                        }
                    }
                }
            }
        };
        this.m_tree.addMouseListener(mouseAdapter);
    }

    public void showMenu() {
        if (this.m_rightClickTreeNode != null) {
            if (this.m_rightClickTreeNode.getDepth() == 0) {
                String string = (String)this.m_rightClickTreeNode.getUserObject();
                JPopupMenu jPopupMenu = null;
                jPopupMenu = string.equalsIgnoreCase(METADATA_AND_MAPPING_REPORT) ? this.getPopupMenu(1) : this.getPopupMenu(2);
                TreePath treePath = this.m_tree.getSelectionPath();
                Rectangle rectangle = this.m_tree.getPathBounds(treePath);
                Point point = new Point((int)rectangle.getX() + 60, (int)rectangle.getY() + 10);
                point.translate(this.getX(), this.getY());
                Point point2 = TreePanel.getSuitableLocation(point, jPopupMenu.getPreferredSize(), this);
                if (jPopupMenu != null) {
                    jPopupMenu.show(this, point2.x, point2.y);
                }
            } else if (this.m_rightClickTreeNode.getDepth() == 1) {
                JPopupMenu jPopupMenu = this.getPopupMenu(2);
                TreePath treePath = this.m_tree.getSelectionPath();
                Rectangle rectangle = this.m_tree.getPathBounds(treePath);
                Point point = new Point((int)rectangle.getX() + 60, (int)rectangle.getY() + 10);
                point.translate(this.getX(), this.getY());
                Point point3 = TreePanel.getSuitableLocation(point, jPopupMenu.getPreferredSize(), this);
                if (jPopupMenu != null) {
                    jPopupMenu.show(this, point3.x, point3.y);
                }
            }
        }
    }

    public void refreshTree() {
        this.m_treeModel.reload();
        this.m_tree.repaint();
    }

    public void autoSelectFirstTreeNode() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreePanel.this.autoSelectFirstTreeNodeExecute();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            this.autoSelectFirstTreeNodeExecute();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.WARNING, "In method autoSelectFirstTreeNode, InterruptedException occurred");
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.log(Level.WARNING, "In method autoSelectFirstTreeNode, InvocationTargetException occurred");
            }
        }
    }

    private void autoSelectFirstTreeNodeExecute() {
        if (this.m_top.getChildCount() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            this.m_currentTreeNode = defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_top.getFirstChild();
            Object[] objectArray = new Object[]{this.m_top, defaultMutableTreeNode};
            TreePath treePath = new TreePath(objectArray);
            this.m_tree.setSelectionPath(treePath);
            this.m_tree.fireTreeExpanded(treePath);
            this.m_tree.requestFocus();
        } else {
            Object[] objectArray = new Object[]{this.m_top};
            TreePath treePath = new TreePath(objectArray);
            this.m_tree.setSelectionPath(treePath);
            if (this.m_treeSelection != null) {
                this.m_treeSelection.setRootNodeSelected();
                this.m_treeSelection.resetDividerLocation();
            }
        }
    }

    public void autoSelectNode(String string) {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreePanel.this.autoSelectNodeExecute(string2);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            this.autoSelectNodeExecute(string);
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.WARNING, "In method autoSelectNode, InterruptedException occurred");
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.log(Level.WARNING, "In method autoSelectNode, InvocationTargetException occurred");
            }
        }
    }

    private void autoSelectNodeExecute(String string) {
        if (this.m_top.getChildCount() > 0) {
            int n = this.m_top.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_top.getChildAt(i);
                String string2 = (String)defaultMutableTreeNode.getUserObject();
                if (!string2.startsWith(string)) continue;
                Object[] objectArray = new Object[]{this.m_top, defaultMutableTreeNode};
                this.m_currentTreeNode = defaultMutableTreeNode;
                TreePath treePath = new TreePath(objectArray);
                this.m_tree.setSelectionPath(treePath);
                this.m_tree.fireTreeExpanded(treePath);
                break;
            }
        }
    }

    public void customSelectNodeOnCacheRestart(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreePanel.this.customSelectNodeOnCacheRestartExecute(string);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            this.customSelectNodeOnCacheRestartExecute(string);
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.WARNING, "In method customSelectNodeOnCacheRestart, InterruptedException occurred");
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.log(Level.WARNING, "In method customSelectNodeOnCacheRestart, InvocationTargetException occurred");
            }
        }
    }

    private void customSelectNodeOnCacheRestartExecute(String string) {
        TreePath treePath = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_top.getChildAt(0);
        String string2 = (String)defaultMutableTreeNode.getUserObject();
        if (string.equalsIgnoreCase(string2)) {
            Object[] objectArray = new Object[]{this.m_top, defaultMutableTreeNode};
            treePath = new TreePath(objectArray);
            this.m_tree.fireTreeExpanded(treePath);
            this.m_tree.setSelectionPath(treePath);
            this.m_tree.requestFocus();
        } else {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                String string3 = (String)defaultMutableTreeNode2.getUserObject();
                if (!string3.equalsIgnoreCase(string)) continue;
                Object[] objectArray = new Object[]{this.m_top, defaultMutableTreeNode, defaultMutableTreeNode2};
                treePath = new TreePath(objectArray);
                this.m_tree.fireTreeExpanded(treePath);
                this.m_tree.setSelectionPath(treePath);
                this.m_tree.requestFocus();
                break;
            }
        }
    }

    protected void selectNewNode() {
        if (this.m_rightClickTreeNode != null) {
            String string;
            TreePath treePath = null;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_top.getChildAt(0);
            String string2 = (String)defaultMutableTreeNode.getUserObject();
            if (string2.equalsIgnoreCase(string = (String)this.m_rightClickTreeNode.getUserObject())) {
                Object[] objectArray = new Object[]{this.m_top, this.m_rightClickTreeNode};
                treePath = new TreePath(objectArray);
            } else {
                Object[] objectArray = new Object[]{this.m_top, defaultMutableTreeNode, this.m_rightClickTreeNode};
                treePath = new TreePath(objectArray);
            }
            this.m_tree.setSelectionPath(treePath);
        }
    }

    public boolean isTreeEmpty() {
        boolean bl = false;
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        if (validateTopDO.getModels().size() == 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (this.m_actionMap == null) {
            this.m_actionMap = this.getRootPane().getActionMap();
            this.m_inputMap = this.getRootPane().getInputMap(1);
            this.m_inputMap.put(KeyStroke.getKeyStroke("shift F10"), "showMenu");
            this.m_actionMap.put("showMenu", this.showMenuAction);
        }
        if (defaultMutableTreeNode.getDepth() == 0 || defaultMutableTreeNode.getDepth() == 1 || defaultMutableTreeNode.getDepth() == 2) {
            this.m_treeSelection.treeNodeSelected(defaultMutableTreeNode);
            this.m_currentTreeNode = defaultMutableTreeNode;
            this.m_rightClickTreeNode = defaultMutableTreeNode;
            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
            validateTopDO.setLastSelectedNodeName((String)defaultMutableTreeNode.getUserObject());
            if (!validateTopDO.isInitializing()) {
                validateTopDO.setLastDrillToDetailLevel(null);
                validateTopDO.setLastTimeDimensionTableUpdated(null);
            }
        }
    }

    protected JPopupMenu getPopupMenu(int n) {
        boolean bl;
        ValidateModelDO validateModelDO = this.m_validateTopDO.getValidateModelDO(this.m_owner, this.m_modelName);
        int n2 = this.m_tree.getSelectionCount();
        JPopupMenu jPopupMenu = new JPopupMenu();
        boolean bl2 = bl = validateModelDO.getValidModelRowCount() > 0;
        if (n == 1) {
            if (n2 > 1) {
                return null;
            }
            JMenu jMenu = new JMenu(OLAPDVArb.get("RUN_ALL_REPORTS_FOR_MENU_ITEM"));
            ArrayList<DimensionDO> arrayList = validateModelDO.getDimensionDOs();
            JMenuItem jMenuItem = new JMenuItem(OLAPDVArb.get("ALL_DIMENSIONS_MENU_ITEM"));
            jMenuItem.setActionCommand("VALIDATE1__ALL_DIMENSIONS_");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenu.setEnabled(bl);
            for (DimensionDO dimensionDO : arrayList) {
                JMenuItem jMenuItem2 = new JMenuItem(dimensionDO.getName());
                jMenuItem2.setActionCommand("VALIDATE1_" + dimensionDO.getName());
                jMenuItem2.addActionListener(this);
                jMenu.add(jMenuItem2);
            }
            jPopupMenu.add(jMenu);
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem3 = new JMenuItem(OLAPDVArb.format("SYNCH_MODEL_WITH_AW_MENU_ITEM", this.m_modelName));
            jMenuItem3.setActionCommand("SYNCH");
            jMenuItem3.addActionListener(this);
            jPopupMenu.add(jMenuItem3);
            if (this.m_rightClickTreeNode != null) {
                if (!this.m_validateTopDO.isModelAnAW(this.m_owner, this.m_modelName)) {
                    jMenuItem3.setEnabled(false);
                }
            } else {
                jMenuItem3.setEnabled(false);
            }
        } else if (n == 2) {
            JMenuItem jMenuItem;
            ArrayList<DimensionDO> arrayList = validateModelDO.getDimensionDOs();
            JMenu jMenu = null;
            String string = (String)this.m_rightClickTreeNode.getUserObject();
            if (string.equalsIgnoreCase(this.ALL_MESSAGE_REPORT)) {
                jMenu = new JMenu(OLAPDVArb.get("RUN_ALL_REPORTS_FOR_MENU_ITEM"));
                jMenu.setEnabled(bl);
                jMenuItem = new JMenuItem(OLAPDVArb.get("ALL_DIMENSIONS_MENU_ITEM"));
                jMenuItem.setActionCommand("VALIDATE1__ALL_DIMENSIONS_");
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                for (DimensionDO dimensionDO : arrayList) {
                    JMenuItem jMenuItem4 = new JMenuItem(dimensionDO.getName());
                    jMenuItem4.setActionCommand("VALIDATE1_" + dimensionDO.getName());
                    jMenuItem4.addActionListener(this);
                    jMenu.add(jMenuItem4);
                }
            } else {
                jMenu = n2 == 1 ? new JMenu(OLAPDVArb.format("RUN_REPORT_FOR_MENU_ITEM", string)) : new JMenu(OLAPDVArb.getString("RUN_ALL_REPORTS_FOR_MENU_ITEM"));
                jMenuItem = new JMenuItem(OLAPDVArb.get("ALL_DIMENSIONS_MENU_ITEM"));
                jMenuItem.setActionCommand("VALIDATE2__ALL_DIMENSIONS_");
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
                jMenu.setEnabled(bl);
                for (DimensionDO dimensionDO : arrayList) {
                    JMenuItem jMenuItem5 = new JMenuItem(dimensionDO.getName());
                    jMenuItem5.setActionCommand("VALIDATE2_" + dimensionDO.getName());
                    jMenuItem5.addActionListener(this);
                    jMenu.add(jMenuItem5);
                }
            }
            jPopupMenu.add(jMenu);
            if (n2 == 1 && string.equalsIgnoreCase(NONUNIQUE_MEMBERS_ACROSS_LEVEL)) {
                Object object;
                jPopupMenu.addSeparator();
                boolean bl3 = validateModelDO.getDisableReport();
                if (!bl3) {
                    object = new JMenuItem(OLAPDVArb.get("DISABLE_DUP_MEMBERS_RPT_MENU_ITEM"));
                    ((AbstractButton)object).addActionListener(this);
                    ((AbstractButton)object).setActionCommand("DISABLE_REPORT");
                    jPopupMenu.add((JMenuItem)object);
                    jMenu.setEnabled(bl);
                } else {
                    object = new JMenuItem(OLAPDVArb.get("ENABLE_DUP_MEMBERS_RPT_MENU_ITEM"));
                    ((AbstractButton)object).addActionListener(this);
                    ((AbstractButton)object).setActionCommand("ENABLE_REPORT");
                    jPopupMenu.add((JMenuItem)object);
                    jMenu.setEnabled(false);
                }
            }
        }
        return jPopupMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ValidateModelDO validateModelDO;
        String string = actionEvent.getActionCommand();
        int n = this.m_tree.getSelectionCount();
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        int[] nArray = null;
        if (n > 1) {
            nArray = this.getReportsToRun(treePathArray);
        }
        if (string.equalsIgnoreCase("DISABLE_REPORT")) {
            validateModelDO = this.m_validateTopDO.getValidateModelDO(this.m_owner, this.m_modelName);
            validateModelDO.setDisableReport(true);
            this.m_treeSelection.setReportTitle(NONUNIQUE_MEMBERS_ACROSS_LEVEL);
            this.m_treeSelection.updateValidateButtonState();
        }
        if (string.equalsIgnoreCase("ENABLE_REPORT")) {
            validateModelDO = this.m_validateTopDO.getValidateModelDO(this.m_owner, this.m_modelName);
            validateModelDO.setDisableReport(false);
            this.m_treeSelection.setReportTitle(NONUNIQUE_MEMBERS_ACROSS_LEVEL);
            this.m_treeSelection.updateValidateButtonState();
        }
        if (string.startsWith("VALIDATE1")) {
            this.setCursor(new Cursor(3));
            int n2 = this.m_validateTopDO.getFilter();
            String string2 = string.substring(10);
            if (string2.equalsIgnoreCase("_ALL_DIMENSIONS_")) {
                string2 = null;
            }
            this.m_treeSelection.runValidationOnAllReports(true, string2, nArray);
            this.m_validateTopDO.setFilter(n2);
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (string.startsWith("VALIDATE2")) {
            String string3 = string.substring(10);
            if (string3.equalsIgnoreCase("_ALL_DIMENSIONS_")) {
                string3 = null;
            }
            if (nArray == null) {
                int n3 = this.getReportToRunFromRightClick();
                nArray = new int[]{n3};
            }
            this.setCursor(new Cursor(3));
            this.m_treeSelection.runValidationOnAllReports(false, string3, nArray);
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (string.equalsIgnoreCase("SYNCH")) {
            Connection connection = null;
            try {
                connection = ConnectionManager.getInstance().getClonedConnection();
            }
            catch (SQLException sQLException) {
                LOG.log(Level.SEVERE, "In method actionPerformed, action SYNCH caused an SQL Exception, errorcode = " + sQLException.getErrorCode(), sQLException);
            }
            ModelWriter modelWriter = new ModelWriter();
            modelWriter.deleteModelFromTable(this.m_owner, this.m_modelName, false);
            String string4 = OLAPDVArb.get("SYNCH_MODEL_WITH_AW_PROGRESS_TITLE");
            String string5 = OLAPDVArb.get("SYNCH_MODEL_WITH_AW_PROGRESS_MSG");
            this.m_progressStatusDialog = this.m_parentComponent instanceof JFrame ? new ProgressStatusDialog((JFrame)this.m_parentComponent, string4, string5, false) : new ProgressStatusDialog((JDialog)this.m_parentComponent, string4, string5, false);
            Rectangle rectangle = MiscUtils.centerWindow(this.m_parentComponent, 500, 200);
            this.m_progressStatusDialog.setBounds(rectangle);
            this.m_progressStatusDialog.initializeDialogPanel();
            String string6 = this.m_modelName;
            LaunchStatus.setInterrupted(false);
            ImportAWThread importAWThread = new ImportAWThread(connection, this.m_owner, string6, this.m_modelName, false);
            importAWThread.start();
            this.m_progressStatusDialog.setModal(true);
            this.m_progressStatusDialog.setVisible(true);
            QueryManager queryManager = new QueryManager();
            if (LaunchStatus.getInterrupted()) {
                JOptionPane.showMessageDialog(this.m_parentComponent, OLAPDVArb.getString("SYNCHRONIZE_OPERATION_ABORTED_MSG"), OLAPDVArb.getString("SYNCHRONIZE_OPERATION_ABORTED_TITLE"), 2);
                queryManager.rollback();
                return;
            }
            queryManager.commit();
            ValidateModelDO validateModelDO2 = this.m_validateTopDO.getValidateModelDO(this.m_owner, string6);
            this.m_progressStatusDialog = new ProgressStatusDialog((JDialog)this.m_parentComponent, OLAPDVArb.format("RUNNING_MODEL_VALIDATION_TITLE", this.m_modelName), OLAPDVArb.format("RUNNING_MODEL_VALIDATION_MSG", this.m_modelName), false);
            rectangle = MiscUtils.centerWindow(this.m_parentComponent, 600, 200);
            this.m_progressStatusDialog.setBounds(rectangle);
            this.m_progressStatusDialog.initializeDialogPanel();
            Thread thread = this.m_treeSelection.runAutomaticModelValidation(validateModelDO2, this.m_progressStatusDialog);
            this.m_progressStatusDialog.setModal(true);
            this.m_progressStatusDialog.setVisible(true);
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                LOG.severe("Model validation background thread interrupted.");
            }
            this.m_treeSelection.treeNodeSelected(this.m_currentTreeNode);
        }
        if (n == 1) {
            this.selectNewNode();
        }
    }

    private int[] getReportsToRun(TreePath[] treePathArray) {
        int[] nArray = new int[treePathArray.length];
        int n = 0;
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            String string = (String)defaultMutableTreeNode.getUserObject();
            nArray[n] = this.getReportFromNodeName(string);
            ++n;
        }
        return nArray;
    }

    private int getReportToRunFromRightClick() {
        String string = (String)this.m_rightClickTreeNode.getUserObject();
        return this.getReportFromNodeName(string);
    }

    private int getReportFromNodeName(String string) {
        int n = 1;
        if (string.equalsIgnoreCase(MEMBER_COUNT_REPORT)) {
            n = 1;
        } else if (string.equalsIgnoreCase(DISTINCT_DESCRIPTION_REPORT)) {
            n = 2;
        } else if (string.equalsIgnoreCase(NONUNIQUE_MEMBERS_ACROSS_LEVEL)) {
            n = 3;
        } else if (string.equalsIgnoreCase(NULL_MEMBER_REPORT)) {
            n = 4;
        } else if (string.equalsIgnoreCase(NULL_DESCRIPTION_REPORT)) {
            n = 5;
        } else if (string.equalsIgnoreCase(MEMBERS_MULTIPLE_DESCRIPTION_REPORT)) {
            n = 6;
        } else if (string.equalsIgnoreCase(DESCRIPTIONS_WITH_MULTIPLE_MEMBER_REPORT)) {
            n = 7;
        } else if (string.equalsIgnoreCase(MEMBERS_WITH_MULTIPLE_PARENTS_REPORT)) {
            n = 8;
        } else if (string.equalsIgnoreCase(DESCRIPTIONS_WITH_PARENTS_WITH_MULTIPLE_DESCRIPTION_REPORT)) {
            n = 9;
        }
        return n;
    }

    protected DefaultMutableTreeNode initializeTree() {
        this.m_top = new DefaultMutableTreeNode(OLAPDVArb.get("MODELS_LABEL2"));
        if (this.m_treeSelection != null) {
            this.m_treeSelection.resetDividerLocation();
        }
        return this.m_top;
    }

    protected void addModelTreeNode(String string) {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreePanel.this.addModelTreeNodeRun(string2);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            this.addModelTreeNodeRun(string);
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.WARNING, "In method addModelTreeNode, An InterrupedException occurred.");
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.log(Level.WARNING, "In method addModelTreeNode, An InvocationTargetException occurred.");
            }
        }
    }

    protected void addModelTreeNodeRun(String string) {
        this.ALL_MESSAGE_REPORT = OLAPDVArb.format("ALL_MESSAGE_REPORT", string);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.ALL_MESSAGE_REPORT);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(METADATA_AND_MAPPING_REPORT);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(MEMBER_COUNT_REPORT);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(DISTINCT_DESCRIPTION_REPORT);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(NONUNIQUE_MEMBERS_ACROSS_LEVEL);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(NULL_MEMBER_REPORT);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(NULL_DESCRIPTION_REPORT);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(MEMBERS_MULTIPLE_DESCRIPTION_REPORT);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(DESCRIPTIONS_WITH_MULTIPLE_MEMBER_REPORT);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(MEMBERS_WITH_MULTIPLE_PARENTS_REPORT);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(DESCRIPTIONS_WITH_PARENTS_WITH_MULTIPLE_DESCRIPTION_REPORT);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        if (this.m_top.getChildCount() == 0) {
            this.m_top.add(defaultMutableTreeNode);
            this.refreshTree();
            this.autoSelectFirstTreeNode();
        } else {
            this.m_treeModel.insertNodeInto(defaultMutableTreeNode, this.m_top, this.m_top.getChildCount());
        }
    }

    protected static Point getSuitableLocation(Point point, Dimension dimension, Component component) {
        Component component2;
        for (component2 = component; component2 != null && !(component2 instanceof JFrame) && !(component2 instanceof JDialog); component2 = component2.getParent()) {
        }
        if (component2 != null) {
            int n;
            int n2;
            Rectangle rectangle = component2.getBounds();
            SwingUtilities.convertPointToScreen(point, component);
            if (point.x + dimension.width > rectangle.x + rectangle.width) {
                n2 = rectangle.x + rectangle.width - dimension.width;
                if (n2 > 16) {
                    n2 -= 16;
                }
            } else {
                n2 = point.x;
            }
            if (point.y + dimension.height > rectangle.y + rectangle.height) {
                n = rectangle.y + rectangle.height - dimension.height;
                if (n > 16) {
                    n -= 16;
                }
            } else {
                n = point.y;
            }
            if (n2 >= 0 && n >= 0) {
                point.x = n2;
                point.y = n;
            }
        }
        SwingUtilities.convertPointFromScreen(point, component);
        return point;
    }

    private void recordLastTimeDimensionsModified(String string, ValidateModelDO validateModelDO) {
        QueryManager queryManager = new QueryManager();
        for (DimensionDO dimensionDO : validateModelDO.getDimensionDOs()) {
            String string2 = queryManager.getLastTimeDimensionModified(string, dimensionDO.getName());
            dimensionDO.setLastTimeDimensionModified(string2);
        }
    }

    protected class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        protected MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            String string = (String)defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode.getDepth() == 0) {
                if (string.equalsIgnoreCase(OLAPDVArb.get("MODELS_LABEL2"))) {
                    this.setIcon(TreePanel.this.m_modelNodeImage);
                } else {
                    this.setIcon(TreePanel.this.m_reportNodeImage);
                }
            }
            if (defaultMutableTreeNode.getDepth() == 1) {
                this.setIcon(TreePanel.this.m_modelNodeImage);
            }
            if (defaultMutableTreeNode.getDepth() == 2) {
                this.setIcon(TreePanel.this.m_modelNodeImage);
            }
            return this;
        }
    }

    protected class ImportAWThread
    extends Thread {
        private Connection conn;
        private String owner;
        private String awName;
        private String newModelName;
        private boolean updateTreeFlag;

        protected ImportAWThread(Connection connection, String string, String string2, String string3, boolean bl) {
            this.conn = connection;
            this.owner = string;
            this.awName = string2;
            this.newModelName = string3;
            this.updateTreeFlag = bl;
        }

        @Override
        public void run() {
            ProgressStatusPanel progressStatusPanel = TreePanel.this.m_progressStatusDialog.getProgressStatusPanel();
            if (LaunchStatus.getInterrupted()) {
                return;
            }
            progressStatusPanel.updateProgressLabel(OLAPDVArb.format("IMPORT_AW_PROGRESS_MSG1", this.awName));
            progressStatusPanel.updateProgressBar(10);
            AwProvider awProvider = new AwProvider();
            AWDO aWDO = awProvider.getOLAPObjectModel(this.owner, this.awName);
            aWDO.setName(this.newModelName);
            if (LaunchStatus.getInterrupted()) {
                return;
            }
            progressStatusPanel.updateProgressLabel(OLAPDVArb.get("IMPORT_AW_PROGRESS_MSG2"));
            progressStatusPanel.updateProgressBar(40);
            CreateSchemaObjects createSchemaObjects = new CreateSchemaObjects();
            createSchemaObjects.create();
            boolean bl = false;
            if (LaunchStatus.getInterrupted()) {
                return;
            }
            progressStatusPanel.updateProgressLabel(OLAPDVArb.get("IMPORT_AW_PROGRESS_MSG3"));
            progressStatusPanel.updateProgressBar(60);
            Object object = new ModelWriter(aWDO, TreePanel.this.m_parentComponent);
            bl = ((ModelWriter)object).writeDimensionsToDataValidationTable(this.owner, false);
            object = null;
            if (LaunchStatus.getInterrupted()) {
                return;
            }
            progressStatusPanel.updateProgressLabel(OLAPDVArb.get("IMPORT_AW_PROGRESS_MSG4"));
            progressStatusPanel.updateProgressBar(80);
            Object object2 = new ModelReader();
            object = ((ModelReader)object2).populateDataValidationObjectModel(this.conn, this.owner, this.newModelName);
            if (!LaunchStatus.getInterrupted()) {
                if (!bl) {
                    ((ValidateModelDO)object).resetDepthAfterErrorFromCreateFromAW();
                    object2 = new ModelWriter((ValidateModelDO)object);
                    ((ModelWriter)object2).writeValidateModelToValidationTable(this.owner, false);
                }
            } else {
                return;
            }
            ((ValidateModelDO)object).setModelChangesPending(false);
            TreePanel.this.m_validateTopDO.setPendingSQLUpdates(false);
            ((ValidateModelDO)object).setLaunchedFromCache(false);
            TreePanel.this.recordLastTimeDimensionsModified(this.owner, (ValidateModelDO)object);
            object2 = new QueryManager();
            List<String> list = ((QueryManager)object2).getDimensionsInAW(this.owner, this.awName);
            ((ValidateModelDO)object).setAllDimensionListCache(list);
            if (this.updateTreeFlag) {
                TreePanel.this.m_validateTopDO.addNewValidateModel((ValidateModelDO)object);
                this.updateTree((ValidateModelDO)object);
            } else {
                TreePanel.this.m_validateTopDO.replaceValidateModelDO((ValidateModelDO)object);
            }
            if (TreePanel.this.m_progressStatusDialog != null) {
                TreePanel.this.m_progressStatusDialog.dispose();
            }
        }

        protected void updateTree(ValidateModelDO validateModelDO) {
            final ValidateModelDO validateModelDO2 = validateModelDO;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TreePanel.this.addModelTreeNode(validateModelDO2.getName());
                    TreePanel.this.m_treeSelection.refreshRootNodePanel();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

