/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.ProgressStatusDialog;

public class ProgressStatusPanel
extends JPanel {
    private ProgressStatusPanel m_thisPanel;
    private ProgressStatusDialog m_progressStatusDialog;
    private JLabel m_progressLabel;
    private JProgressBar m_progressBar;

    public ProgressStatusPanel(ProgressStatusDialog progressStatusDialog, String string, boolean bl) {
        this.m_progressStatusDialog = progressStatusDialog;
        this.m_thisPanel = this;
        this.jbinit(string, bl);
    }

    private void jbinit(String string, boolean bl) {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.m_progressLabel = new JLabel();
        this.m_progressBar = new JProgressBar(0, 100);
        if (this.m_progressStatusDialog.getIsIndeterminate()) {
            this.m_progressBar.setIndeterminate(true);
        }
        jPanel.add((Component)new JLabel(string), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(25, 5, 2, 5);
        jPanel.add((Component)this.m_progressLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        jPanel.add((Component)this.m_progressBar, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton(OLAPDVArb.getString("CANCEL_BUTTON"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        if (bl) {
            this.add((Component)jButton, gridBagConstraints);
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgressStatusPanel.this.m_progressStatusDialog.cancelWorkerThread();
                ProgressStatusPanel.this.m_progressStatusDialog.dispose();
            }
        });
    }

    public void updateProgressBar(int n) {
        final int n2 = n;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProgressStatusPanel.this.m_progressBar.setValue(n2);
                ProgressStatusPanel.this.m_thisPanel.repaint();
                ProgressStatusPanel.this.m_progressStatusDialog.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void updateProgressLabel(String string) {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProgressStatusPanel.this.m_progressLabel.setText(string2);
                ProgressStatusPanel.this.m_thisPanel.repaint();
                ProgressStatusPanel.this.m_progressStatusDialog.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

