/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.DataValidateApp;
import oracle.olapdv.app.DataValidateDialog;
import oracle.olapdv.app.DataValidatePanel;
import oracle.olapdv.app.ModelMessagePanel;
import oracle.olapdv.app.ModelPanel;
import oracle.olapdv.app.ValidateViewer;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;

public class ModelViewer
extends JPanel {
    private Logger LOG = Logger.getLogger(ModelViewer.class.getName());
    private Component m_parentComponent;
    private ValidateTopDO m_validateTopDO;
    private ValidateModelDO m_validateModelDO;
    private ModelPanel m_modelPanel;
    private ModelMessagePanel m_modelMessagePanel;
    private DataValidateApp m_validateApp;
    private ValidateViewer m_validateViewer;
    private JButton helpButton;

    public ModelViewer(Component component, ValidateTopDO validateTopDO, ValidateModelDO validateModelDO, DataValidateApp dataValidateApp) {
        this.m_parentComponent = component;
        this.m_validateTopDO = validateTopDO;
        this.m_validateModelDO = validateModelDO;
        this.m_validateApp = dataValidateApp;
        this.jbinit();
    }

    public void setValidateTopDO(ValidateTopDO validateTopDO) {
        this.m_validateTopDO = validateTopDO;
    }

    public void refreshModelPanelTopLabel() {
        if (this.m_validateModelDO != null) {
            this.m_modelPanel.refreshTopLabel(OLAPDVArb.format("MODEL_DETAIL_FOR", this.m_validateModelDO.getName()));
        }
    }

    public void maximizeDialog() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = new Rectangle(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
        Rectangle rectangle2 = new Rectangle(25, 25, (int)rectangle.getWidth() - 50, (int)rectangle.getHeight() - 50);
        DataValidatePanel dataValidatePanel = this.m_validateApp.getDataValidatePanel();
        Frame frame = dataValidatePanel.getParentFrame();
        if (frame != null) {
            frame.setBounds(rectangle2);
        }
        if (this.m_parentComponent instanceof JDialog) {
            JDialog jDialog = (JDialog)this.m_parentComponent;
            jDialog.setBounds(rectangle2);
            jDialog.invalidate();
            jDialog.repaint();
            if (this.m_parentComponent instanceof DataValidateDialog) {
                DataValidateDialog dataValidateDialog = (DataValidateDialog)this.m_parentComponent;
                dataValidateDialog.setBounds(rectangle2);
                dataValidateDialog.invalidate();
                dataValidateDialog.repaint();
                dataValidatePanel.revalidate();
                dataValidatePanel.repaint();
                dataValidatePanel.getRightComponent().invalidate();
                dataValidatePanel.getRightComponent().repaint();
                dataValidatePanel.getLeftComponent().invalidate();
                dataValidatePanel.getLeftComponent().repaint();
            }
        } else {
            this.m_parentComponent.setBounds(rectangle2);
            this.m_parentComponent.repaint();
        }
        dataValidatePanel.revalidate();
        dataValidatePanel.repaint();
    }

    private void jbinit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        this.m_modelPanel = new ModelPanel(this.m_parentComponent, this, this.m_validateModelDO);
        this.m_modelMessagePanel = new ModelMessagePanel(this.m_parentComponent, this, this.m_validateModelDO);
        JSplitPane jSplitPane = new JSplitPane(0, this.m_modelPanel, this.m_modelMessagePanel);
        jSplitPane.setDividerLocation(525);
        this.add((Component)jSplitPane, gridBagConstraints);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_modelPanel, "olapdv_metadata_and_mapping");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelViewer.this.showHelp();
            }
        };
        ActionMap actionMap = ((JDialog)this.m_parentComponent).getRootPane().getActionMap();
        InputMap inputMap = ((JDialog)this.m_parentComponent).getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("F1"), "help");
        actionMap.put("help", abstractAction);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JButton jButton = new JButton(OLAPDVArb.getString("CLOSE_BUTTON"));
        jButton.setMnemonic(76);
        this.helpButton = new JButton(StringUtils.stripMnemonic((String)OLAPDVArb.getString("HELP_BUTTON")));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPDVArb.getString("HELP_BUTTON")));
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.helpButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel, gridBagConstraints);
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelViewer.this.showHelp();
            }
        });
    }

    public void refreshModelViewPanel(ValidateModelDO validateModelDO) {
        this.m_modelPanel.setModelDO(validateModelDO);
        this.m_modelPanel.refreshTableData();
        this.m_modelMessagePanel.refreshMessageData(validateModelDO);
        this.m_validateModelDO = validateModelDO;
    }

    public void setValidateViewer(ValidateViewer validateViewer) {
        this.m_validateViewer = validateViewer;
    }

    public ValidateViewer getValidateViewer() {
        return this.m_validateViewer;
    }

    public void replaceValidateModelDO(ValidateModelDO validateModelDO) {
        this.m_validateTopDO.replaceValidateModelDO(validateModelDO);
    }

    private void showHelp() {
        HelpSystem.getHelpSystem().showHelp((JComponent)this.m_modelPanel);
    }

    public ModelPanel getModelPanel() {
        return this.m_modelPanel;
    }
}

