/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.jdbc.internal.OracleConnection;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.AppLog;
import oracle.olapdv.app.DataValidateFrame;
import oracle.olapdv.app.DataValidatePanel;
import oracle.olapdv.app.LoginDialog;
import oracle.olapdv.app.LoginPanel;
import oracle.olapdv.app.TreePanel;
import oracle.olapdv.app.TreeSelection;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.log.ValidateLogger;
import oracle.olapdv.olap.model.AWDO;
import oracle.olapdv.olap.model.AttributeDO;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.reader.ModelReader;
import oracle.olapdv.test.TestSQL;
import oracle.olapdv.util.Logger;
import oracle.olapdv.util.MiscUtils;
import oracle.olapdv.writer.CreateSchemaObjects;

public class DataValidateApp {
    private static JFrame m_frame;
    private Connection m_conn;
    private AWDO m_AWDO;
    private DataValidatePanel m_dataValidatePanel;
    private String m_plugInAWName = null;
    private int m_launchType;
    public static final int STANDALONE = 1;
    public static final int PLUGIN = 2;

    public AWDO getAwmDO() {
        return this.m_AWDO;
    }

    public void setAwmDO(AWDO aWDO) {
        this.m_AWDO = aWDO;
    }

    public boolean connect(String string, String string2, String string3) {
        ConnectionManager connectionManager = ConnectionManager.getInstance();
        try {
            connectionManager.setUserName(string);
            connectionManager.setPassword(string2);
            connectionManager.setConnectionString(string3);
            this.m_conn = connectionManager.getClonedConnection();
            return true;
        }
        catch (SQLException sQLException) {
            Logger.logError("connect", "SQLException: " + sQLException);
            JOptionPane.showMessageDialog(m_frame, OLAPDVArb.format("CONNECTION_FAILED_WITH", sQLException), OLAPDVArb.getString("CONNECTION_FAILED_TITLE"), 0);
            return false;
        }
    }

    public void disconnect() {
        try {
            if (this.m_conn != null && !this.m_conn.isClosed()) {
                this.m_conn.close();
                this.m_conn = null;
            }
        }
        catch (SQLException sQLException) {
            Logger.logError("DatabaseNode.disconnect", sQLException);
        }
    }

    public static final void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = "GLOBAL";
        String string4 = "GLOBAL";
        String string5 = "global";
        String string6 = "NO";
        int n = 0;
        DataValidateApp dataValidateApp = new DataValidateApp();
        DataValidateApp.invokeInEventThreadAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel("oracle.bali.ewt.olaf2.OracleLookAndFeel");
                    UIManager.put("TabbedPane.focus", UIManager.get("TabbedPane.foreground"));
                }
                catch (Exception exception) {
                    Logger.logError("main", "setting look and feel " + exception);
                }
            }
        });
        dataValidateApp.setLaunchType(1);
        for (String object2 : stringArray) {
            if (object2.toUpperCase().startsWith("NAME=")) {
                string4 = object2.toUpperCase().substring(5);
                continue;
            }
            if (object2.toUpperCase().startsWith("CONNSTR=")) {
                string = object2.substring(8);
                continue;
            }
            if (object2.toUpperCase().startsWith("USERNAME=")) {
                string5 = object2.substring(9);
                continue;
            }
            if (object2.toUpperCase().startsWith("PASSWORD=")) {
                string2 = object2.substring(9);
                continue;
            }
            if (object2.toUpperCase().startsWith("NOGUI=")) {
                string6 = object2.substring(6);
                if (string6 != null && string6.length() != 0) continue;
                string6 = "NO";
                continue;
            }
            if (!object2.toUpperCase().startsWith("LOGLEVEL=")) continue;
            n = Integer.parseInt(object2.substring(9));
        }
        if (n != 0) {
            Logger.setLoggingLevel(n);
        }
        AppLog appLog = AppLog.getInstance();
        appLog.write(" Data Validation Log File");
        appLog.write(" Analytic Workspace Name = " + string4);
        appLog.write(" Connection String = " + string);
        appLog.write(" UserName = " + string5);
        DataValidateFrame dataValidateFrame = new DataValidateFrame("Data Validation", dataValidateApp);
        dataValidateFrame.setDefaultCloseOperation(3);
        m_frame = dataValidateFrame;
        DataValidatePanel dataValidatePanel = new DataValidatePanel(dataValidateFrame, dataValidateApp);
        dataValidateApp.setDataValidatePanel(dataValidatePanel);
        dataValidateFrame.getContentPane().add(dataValidatePanel);
        dataValidateFrame.pack();
        Rectangle rectangle = new Rectangle(30, 30, 1200, 850);
        dataValidateFrame.setBounds(rectangle);
        dataValidateApp.loginAndInitialize(dataValidateFrame, dataValidateApp);
        dataValidateFrame.setVisible(true);
    }

    public void loginAndInitialize(JFrame jFrame, DataValidateApp dataValidateApp) {
        final JFrame jFrame2 = jFrame;
        final DataValidateApp dataValidateApp2 = dataValidateApp;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                LoginDialog loginDialog;
                String[] stringArray = new String[]{"", "", ""};
                String string = null;
                boolean bl = false;
                while (!bl) {
                    loginDialog = new LoginDialog(jFrame2);
                    loginDialog.setTitle("Login");
                    object4 = new LoginPanel(loginDialog, stringArray);
                    loginDialog.setContentPane((Container)object4);
                    object3 = MiscUtils.centerWindow(jFrame2, 400, 225);
                    loginDialog.setBounds((Rectangle)object3);
                    loginDialog.setModal(true);
                    while (!jFrame2.isVisible()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    loginDialog.setVisible(true);
                    string = stringArray[0] != null && stringArray[0].length() > 0 ? stringArray[0].toUpperCase() : null;
                    object2 = stringArray[1];
                    object = stringArray[2];
                    if (string == null || string.length() == 0 || object2 == null || ((String)object2).length() == 0 || object == null || ((String)object).length() == 0) {
                        dataValidateApp2.closeApplication(dataValidateApp2);
                    }
                    bl = dataValidateApp2.connect(string, (String)object2, (String)object);
                }
                loginDialog = null;
                object4 = ConnectionManager.getInstance();
                try {
                    loginDialog = (OracleConnection)((ConnectionManager)object4).getClonedConnection();
                }
                catch (SQLException sQLException) {
                    Logger.logError("loginAndInitialize", sQLException);
                }
                jFrame2.setCursor(new Cursor(3));
                object3 = new CreateSchemaObjects();
                if (!((CreateSchemaObjects)object3).create()) {
                    JOptionPane.showMessageDialog(jFrame2, OLAPDVArb.getString("MISSING_REQUIRED_DATABASE_PRIVILEGES"), OLAPDVArb.getString("MISSING_PRIVILEGES_TITLE"), 0);
                    DataValidateApp.this.closeApplication(dataValidateApp2);
                }
                object2 = ValidateTopDO.getInstance();
                object = new ModelReader();
                ((ModelReader)object).readValidateTable(string, DataValidateApp.this.m_plugInAWName);
                QueryManager queryManager = new QueryManager();
                List<AWDO> list = queryManager.getAllAWsAvailableToUser();
                ((ValidateTopDO)object2).setAWDOs(list);
                DataValidatePanel dataValidatePanel = dataValidateApp2.getDataValidatePanel();
                TreePanel treePanel = dataValidatePanel.getTreePanel();
                for (ValidateModelDO validateModelDO : ((ValidateTopDO)object2).getModels()) {
                    treePanel.addModelTreeNode(validateModelDO.getName());
                }
                dataValidatePanel.refreshModelViewerWithValidateTopDO((ValidateTopDO)object2);
                TreeSelection treeSelection = dataValidatePanel.getTreeSelection();
                treeSelection.setTopValidateModelDO((ValidateTopDO)object2);
                treePanel.refreshTree();
                treePanel.setValidateTopDO((ValidateTopDO)object2);
                if (DataValidateApp.this.m_plugInAWName != null) {
                    treePanel.autoSelectNode(DataValidateApp.this.m_plugInAWName);
                } else {
                    treePanel.autoSelectFirstTreeNode();
                }
                jFrame2.setCursor(Cursor.getDefaultCursor());
                jFrame2.setTitle(OLAPDVArb.format("DATA_VALIDATION_FOR_SCHEMA", string));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setDataValidatePanel(DataValidatePanel dataValidatePanel) {
        this.m_dataValidatePanel = dataValidatePanel;
    }

    public DataValidatePanel getDataValidatePanel() {
        return this.m_dataValidatePanel;
    }

    private void verifyOLAPIMetadata(AWDO aWDO, Connection connection) {
        AppLog appLog = AppLog.getInstance();
        TestSQL testSQL = new TestSQL();
        appLog.write("------------------ Verify the OLAP API metadata ------------------");
        ArrayList<DimensionDO> arrayList = aWDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList) {
            appLog.write("Dimension: " + dimensionDO.getName());
            ArrayList<AttributeDO> arrayList2 = dimensionDO.getAttributeDOs();
            for (AttributeDO attributeDO : arrayList2) {
                appLog.write(" Attribute : " + attributeDO.getName());
            }
            AttributeDO attributeDO = dimensionDO.getLongDescriptionAttributeDO();
            if (attributeDO != null) {
                appLog.write("   -- " + OLAPDVArb.format("LONG_DESCRIPTION_ATTRIBUTE_IS", attributeDO.getName()));
            } else {
                appLog.write("   -- " + OLAPDVArb.getString("LONG_DESCRIPTION_ATTRIBUTE_IS_NOT_FOUND"));
            }
            ArrayList<HierarchyDO> object2 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : object2) {
                appLog.write(" Hierarchy : " + hierarchyDO.getName());
                ArrayList<LevelDO> arrayList3 = hierarchyDO.getLevelDOs();
                for (LevelDO levelDO : arrayList3) {
                    appLog.write("  Level : " + levelDO.getName());
                    LevelMapDO levelMapDO = levelDO.getLevelMapDO();
                    appLog.write("   Owner : " + levelMapDO.getOwner());
                    appLog.write("   table Name : " + levelMapDO.getTableName());
                    appLog.write("   Column Name : " + levelMapDO.getColumnName());
                    try {
                        int n;
                        if (levelMapDO.getOwner() != null) {
                            n = testSQL.runSQL(connection, levelMapDO.getOwner(), levelMapDO.getTableName(), levelMapDO.getColumnName());
                            appLog.write("    ** Row count is " + n);
                        }
                        if (levelMapDO.getLongDescriptionColumnName() == null) continue;
                        n = testSQL.runSQL(connection, levelMapDO.getOwner(), levelMapDO.getTableName(), levelMapDO.getLongDescriptionColumnName());
                        appLog.write("    ** Row Description count is " + n);
                    }
                    catch (SQLException sQLException) {
                        Logger.logError("verifyOLAPMetadata", sQLException);
                    }
                }
            }
        }
    }

    public static void invokeInEventThreadAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Logger.logError("MiscUtils.invokeInEventThreadAndWait", exception);
            }
        }
    }

    public void setLaunchType(int n) {
        this.m_launchType = n;
    }

    public int getLaunchType() {
        return this.m_launchType;
    }

    public void setPlugInAWName(String string) {
        this.m_plugInAWName = string;
    }

    public String getPlugInAWName() {
        return this.m_plugInAWName;
    }

    public void closeApplication(DataValidateApp dataValidateApp) {
        if (this.m_launchType == 1) {
            dataValidateApp.disconnect();
            AppLog appLog = AppLog.getInstance();
            appLog.shutDown();
            ValidateLogger validateLogger = ValidateLogger.getInstance();
            validateLogger.closeDown();
            System.exit(0);
        } else {
            AppLog appLog = AppLog.getInstance();
            appLog.shutDown();
            ValidateLogger validateLogger = ValidateLogger.getInstance();
            validateLogger.closeDown();
        }
    }
}

