/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.app;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import oracle.olapdv.OLAPDVArb;

public class AppLog {
    private FileWriter appWriter = null;
    private static AppLog applicationLog = null;
    private StringBuffer m_messageBuffer = new StringBuffer();
    private int m_messageCount = 0;
    private boolean m_countThreshold = false;
    private boolean m_firstWrite = true;

    private AppLog() {
    }

    public static AppLog getInstance() {
        if (applicationLog == null) {
            applicationLog = new AppLog();
        }
        return applicationLog;
    }

    public void shutDown() {
        this.closeAppWriter();
    }

    public void write(String string) {
        FileWriter fileWriter = this.getAppWriter();
        try {
            if (this.m_firstWrite) {
                fileWriter.write("-------------------  " + new Date().toString() + "  --------------------\r\n");
                this.m_firstWrite = false;
            }
            fileWriter.write(string + "\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.m_messageCount;
        if (this.m_messageCount < 20) {
            this.m_messageBuffer.append(string + "\n");
        } else if (!this.m_countThreshold) {
            this.m_countThreshold = true;
            this.m_messageBuffer.append(OLAPDVArb.getString("ADDITIONAL_MESSAGES_NOT_SHOWN"));
            this.m_messageBuffer.append(OLAPDVArb.getString("REVIEW_APPLICATION_LOG_FILE"));
        }
    }

    public void writeSummaryInformation(String string) {
        FileWriter fileWriter = this.getAppWriter();
        try {
            fileWriter.write(string + "\r\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_messageBuffer.append(string + "\n");
    }

    public void flush() {
        FileWriter fileWriter = this.getAppWriter();
        try {
            fileWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private FileWriter getAppWriter() {
        if (this.appWriter == null) {
            try {
                this.appWriter = new FileWriter("validaterun.log", true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.appWriter;
    }

    public StringBuffer getMessageBuffer() {
        return this.m_messageBuffer;
    }

    private void closeAppWriter() {
        if (this.appWriter != null) {
            try {
                this.appWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.appWriter = null;
        applicationLog = null;
        this.m_messageCount = 0;
        this.m_countThreshold = false;
        this.m_messageBuffer = new StringBuffer();
    }
}

