/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.ByteArrayOutputStream;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.Signature;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public abstract class PhaosSignatureSpi
extends SignatureSpi {
    private Signature signature;
    private ByteArrayOutputStream buffer;
    private RandomBitsSource random = null;
    private static final int ENGINE_INIT_PRIV_KEY = 1;
    private static final int ENGINE_INIT_PRIV_KEY_RND = 2;
    private static final int ENGINE_INIT_PUB_KEY = 3;
    private int engineInitMethod;
    private java.security.PrivateKey engineInitPrivateKey;
    private PublicKey engineInitPublicKey;
    private SecureRandom engineInitRandom;

    protected PhaosSignatureSpi(Signature signature) {
        this.signature = signature;
    }

    @Override
    protected void engineInitSign(java.security.PrivateKey privateKey, SecureRandom random) throws java.security.InvalidKeyException {
        this.random = random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random);
        this.appRandom = random;
        this.engineInitSign(privateKey);
        this.engineInitMethod = 2;
        this.engineInitPrivateKey = privateKey;
        this.engineInitPublicKey = null;
        this.engineInitRandom = random;
    }

    @Override
    protected void engineInitSign(java.security.PrivateKey privateKey) throws java.security.InvalidKeyException {
        oracle.security.crypto.core.RSAPrivateKey phaosKey;
        this.signature.setRandomBitsSource(this.random);
        if (privateKey instanceof RSAPrivateKey) {
            phaosKey = PhaosJCEKeyTranslator.jceRSAPrivateKeyToPhaos((RSAPrivateKey)privateKey);
        } else if (privateKey instanceof DSAPrivateKey) {
            phaosKey = PhaosJCEKeyTranslator.jceDSAPrivateKeyToPhaos((DSAPrivateKey)privateKey);
        } else {
            throw new java.security.InvalidKeyException("Did not receive an RSA or DSA key");
        }
        try {
            this.signature.setPrivateKey((PrivateKey)phaosKey);
        }
        catch (InvalidKeyException ex) {
            throw new java.security.InvalidKeyException(ex.toString());
        }
        this.initialize();
        this.engineInitMethod = 1;
        this.engineInitPrivateKey = privateKey;
        this.engineInitPublicKey = null;
        this.engineInitRandom = null;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws java.security.InvalidKeyException {
        RSAPublicKey phaosKey;
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            phaosKey = PhaosJCEKeyTranslator.jceRSAPublicKeyToPhaos((java.security.interfaces.RSAPublicKey)publicKey);
        } else if (publicKey instanceof DSAPublicKey) {
            phaosKey = PhaosJCEKeyTranslator.jceDSAPublicKeyToPhaos((DSAPublicKey)publicKey);
        } else {
            throw new java.security.InvalidKeyException("Did not receive an RSA or DSA key");
        }
        try {
            this.signature.setPublicKey((oracle.security.crypto.core.PublicKey)phaosKey);
        }
        catch (InvalidKeyException ex) {
            throw new java.security.InvalidKeyException(ex.toString());
        }
        this.initialize();
        this.engineInitMethod = 3;
        this.engineInitPrivateKey = null;
        this.engineInitPublicKey = publicKey;
        this.engineInitRandom = null;
    }

    void initialize() {
        if (this.buffer == null) {
            this.buffer = new ByteArrayOutputStream();
        } else {
            this.buffer.reset();
        }
    }

    private void reinitialize() {
        block5: {
            try {
                if (this.engineInitMethod == 1) {
                    this.engineInitSign(this.engineInitPrivateKey);
                    break block5;
                }
                if (this.engineInitMethod == 2) {
                    this.engineInitSign(this.engineInitPrivateKey, this.engineInitRandom);
                    break block5;
                }
                if (this.engineInitMethod == 3) {
                    this.engineInitVerify(this.engineInitPublicKey);
                    break block5;
                }
                throw new IllegalStateException("Error occured when re-initializing the object: unknown initialization method");
            }
            catch (java.security.InvalidKeyException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.buffer.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.buffer.write(b, off, len);
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        boolean result;
        this.signature.setDocument(this.buffer.toByteArray());
        this.signature.setSigBytes(sigBytes);
        try {
            result = this.signature.verify();
        }
        catch (AuthenticationException ex) {
            throw new SignatureException(ex.toString());
        }
        this.reinitialize();
        return result;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] result;
        this.signature.setDocument(this.buffer.toByteArray());
        try {
            result = this.signature.sign();
        }
        catch (oracle.security.crypto.core.SignatureException ex) {
            throw new SignatureException(ex.toString());
        }
        this.reinitialize();
        return result;
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("The engineGetParameter() method is not supported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("The engineSetParameter() method is not supported");
    }
}

