/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.MAC;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;

public abstract class PhaosMacSpi
extends MacSpi {
    private AlgorithmIdentifier algID;
    private MAC mac;
    private boolean initialized;
    private byte[] sigBytes;
    private static final int ENGINE_INIT_KEY_ALG = 1;
    private int engineInitMethod;
    private Key engineInitKey;
    private AlgorithmParameterSpec engineInitParamSpec;

    protected PhaosMacSpi(AlgorithmIdentifier algID) {
        this.algID = algID;
        this.initialized = false;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("The key is not a secret key");
        }
        try {
            if (this.mac == null) {
                this.mac = MAC.getInstance((AlgorithmIdentifier)this.algID, (SymmetricKey)PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key));
            } else {
                this.mac.initialize(this.algID, PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key));
            }
        }
        catch (AlgorithmIdentifierException ex) {
            throw new InvalidKeyException(ex.toString());
        }
        this.initialized = true;
        this.engineInitMethod = 1;
        this.engineInitKey = key;
        this.engineInitParamSpec = params;
    }

    @Override
    protected void engineReset() {
        if (this.initialized) {
            this.mac.erase();
            this.initialized = false;
        }
        this.reinitialize();
    }

    @Override
    protected void engineUpdate(byte b) {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.mac.update(b);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.mac.update(input, offset, len);
    }

    @Override
    protected byte[] engineDoFinal() {
        if (!this.initialized) {
            throw new IllegalStateException("MAC not initialized");
        }
        this.initialized = false;
        byte[] res = this.mac.computeMAC();
        this.reinitialize();
        return res;
    }

    private void reinitialize() {
        try {
            if (this.engineInitMethod != 1) {
                throw new IllegalStateException("Error occured when re-initializing the object: unknown initialization method");
            }
            this.engineInit(this.engineInitKey, this.engineInitParamSpec);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new IllegalStateException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new IllegalStateException(ex.toString());
        }
    }
}

