/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import oracle.security.crypto.core.KeyPairGenerator;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public abstract class PhaosKeyPairGeneratorSpi
extends KeyPairGeneratorSpi {
    protected KeyPairGenerator kpg;
    protected boolean initialized = false;

    PhaosKeyPairGeneratorSpi(KeyPairGenerator kpg) {
        this.kpg = kpg;
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        this.kpg.initialize(keysize, (RandomBitsSource)(random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random)));
        this.initialized = true;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException("initialize() method not supported");
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialized) {
            this.initialize(1024, null);
        }
        oracle.security.crypto.core.KeyPair phaosKP = this.kpg.generateKeyPair();
        PublicKey phaosPubKey = phaosKP.getPublic();
        PrivateKey phaosPrivKey = phaosKP.getPrivate();
        java.security.PublicKey pubKey = PhaosJCEKeyTranslator.phaosPublicKeyToJCE(phaosPubKey);
        java.security.PrivateKey privKey = PhaosJCEKeyTranslator.phaosPrivateKeyToJCE(phaosPrivKey);
        return new KeyPair(pubKey, privKey);
    }
}

