/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.jce.provider.PhaosAlgorithmParametersSpi;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public abstract class IVAlgorithmParametersSpi
extends PhaosAlgorithmParametersSpi {
    private CBCAlgorithmIdentifier algID;
    private ASN1ObjectID oid;

    protected IVAlgorithmParametersSpi(String algName, ASN1ObjectID oid) {
        super(algName);
        this.oid = oid;
    }

    IVAlgorithmParametersSpi(AlgorithmIdentifier algID) throws NoSuchAlgorithmException {
        this(IVAlgorithmParametersSpi.oidToString(algID.getOID()), algID.getOID());
        if (algID instanceof CBCAlgorithmIdentifier) {
            this.algID = (CBCAlgorithmIdentifier)algID;
        } else {
            try {
                this.algID = new CBCAlgorithmIdentifier(Utils.toStream((Streamable)algID));
            }
            catch (IOException e) {
                throw new NoSuchAlgorithmException(e.toString());
            }
        }
        this.oid = algID.getOID();
    }

    byte[] getIV() {
        return this.algID == null ? null : this.algID.getIV();
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        if (this.algID != null && this.algID.getParameters() != null) {
            return Utils.toBytes((Streamable)this.algID.getParameters());
        }
        return null;
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (paramSpec.equals(IvParameterSpec.class) && this.getIV() != null) {
            return new IvParameterSpec(this.getIV());
        }
        throw new InvalidParameterSpecException("Invalid parameter: " + paramSpec);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.erase();
        if (!(paramSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter: " + paramSpec);
        }
        this.algID = new CBCAlgorithmIdentifier(this.oid, ((IvParameterSpec)paramSpec).getIV());
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        this.erase();
        if (params == null) {
            return;
        }
        try {
            ASN1Object obj = ASN1Utils.inputASN1Object((byte[])params);
            this.algID = new CBCAlgorithmIdentifier(this.oid, obj);
        }
        catch (AlgorithmIdentifierException ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected String engineToString() {
        return this.getIV() != null ? "IV=" + Utils.toHexString((byte[])this.getIV()) : "";
    }

    private void erase() {
        if (this.getIV() != null) {
            Utils.setArray((byte[])this.getIV(), (byte)0);
        }
        this.algID = null;
    }
}

