/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public final class DSAAlgorithmParametersSpi
extends AlgorithmParametersSpi {
    private DSAParams params;

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        if (this.params != null) {
            return Utils.toBytes((Streamable)this.params);
        }
        return null;
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        if (format.equalsIgnoreCase("ASN.1")) {
            throw new InvalidParameterException("Format unsupported: " + format);
        }
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (this.params == null) {
            return null;
        }
        if (paramSpec.equals(DSAParameterSpec.class)) {
            return new DSAParameterSpec(this.params.getP(), this.params.getQ(), this.params.getG());
        }
        throw new InvalidParameterSpecException("Invalid parameter: " + paramSpec);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.params = null;
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter: " + paramSpec);
        }
        DSAParameterSpec dsaParams = (DSAParameterSpec)paramSpec;
        this.params = new DSAParams(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        this.params = null;
        if (params == null) {
            return;
        }
        this.params = new DSAParams((InputStream)new ByteArrayInputStream(params));
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        if (format.equalsIgnoreCase("ASN.1")) {
            throw new InvalidParameterException("Format unsupported: " + format);
        }
        this.engineInit(params);
    }

    @Override
    protected String engineToString() {
        return "DSA Parameter={p=" + this.params.getP() + "q=" + this.params.getG() + "g=" + this.params.getQ() + "}";
    }
}

